/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.JDKVersionSpecificResourceBuilder;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

class ResourcesHelper {
    ResourcesHelper() {
    }

    private static <T> T urlToResource(String resourceName, URL url) {
        try {
            if (url == null) {
                return null;
            }
            URLConnection urlConnection = url.openConnection();
            Object resource = JDKVersionSpecificResourceBuilder.buildResource(resourceName, url, urlConnection);
            VMError.guarantee(resource != null);
            return (T)resource;
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassCastException classCastException) {
            throw VMError.shouldNotReachHere(classCastException);
        }
    }

    static <T> T nameToResource(String resourceName) {
        return ResourcesHelper.urlToResource(resourceName, ResourcesHelper.nameToResourceURL(resourceName));
    }

    static <T> Enumeration<T> nameToResources(String resourceName) {
        Enumeration<URL> urls = Resources.createURLs(resourceName);
        ArrayList<T> resourceURLs = new ArrayList<T>();
        while (urls.hasMoreElements()) {
            resourceURLs.add(ResourcesHelper.urlToResource(resourceName, urls.nextElement()));
        }
        return Collections.enumeration(resourceURLs);
    }

    static URL nameToResourceURL(String resourceName) {
        return Resources.createURL(resourceName);
    }

    static InputStream nameToResourceInputStream(String resourceName) throws IOException {
        URL url = ResourcesHelper.nameToResourceURL(resourceName);
        return url != null ? url.openStream() : null;
    }

    static List<URL> nameToResourceListURLs(String resourcesName) {
        Enumeration<URL> urls = Resources.createURLs(resourcesName);
        ArrayList<URL> resourceURLs = new ArrayList<URL>();
        while (urls.hasMoreElements()) {
            resourceURLs.add(urls.nextElement());
        }
        return resourceURLs;
    }

    static Enumeration<URL> nameToResourceEnumerationURLs(String resourcesName) {
        return Collections.enumeration(ResourcesHelper.nameToResourceListURLs(resourcesName));
    }
}

