/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.VMError;
import java.security.ProtectionDomain;

public final class DynamicHubCompanion {
    private final DynamicHub hub;
    private String packageName;
    private ClassLoader classLoader;
    private ProtectionDomain protectionDomain;

    public DynamicHubCompanion(DynamicHub hub) {
        this.hub = hub;
    }

    public String getPackageName() {
        if (this.packageName == null) {
            this.packageName = this.hub.computePackageName();
        }
        return this.packageName;
    }

    boolean hasClassLoader() {
        return this.classLoader != null;
    }

    public ClassLoader getClassLoader() {
        ClassLoader loader = this.classLoader;
        VMError.guarantee(loader != null);
        return loader;
    }

    public void setClassLoader(ClassLoader loader) {
        VMError.guarantee(this.classLoader == null && loader != null);
        this.classLoader = loader;
    }

    public ProtectionDomain getProtectionDomain() {
        if (this.protectionDomain == null) {
            this.protectionDomain = DynamicHub.allPermDomainReference.get();
        }
        return this.protectionDomain;
    }

    public void setProtectionDomain(ProtectionDomain domain) {
        VMError.guarantee(this.protectionDomain == null && domain != null);
        this.protectionDomain = domain;
    }
}

