/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.nodes.DeadEndNode;
import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.word.LocationIdentity;

public abstract class NonSnippetLowerings {
    private final RuntimeConfiguration runtimeConfig;
    private final Predicate<ResolvedJavaMethod> mustNotAllocatePredicate;
    private static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> getCachedExceptionDescriptors = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);
    private static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> createExceptionDescriptors;
    private static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> throwCachedExceptionDescriptors;
    private static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> throwNewExceptionDescriptors;

    protected NonSnippetLowerings(RuntimeConfiguration runtimeConfig, Predicate<ResolvedJavaMethod> mustNotAllocatePredicate, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        this.runtimeConfig = runtimeConfig;
        this.mustNotAllocatePredicate = mustNotAllocatePredicate;
        lowerings.put(BytecodeExceptionNode.class, new BytecodeExceptionLowering());
        lowerings.put(ThrowBytecodeExceptionNode.class, new ThrowBytecodeExceptionLowering());
        lowerings.put(GetClassNode.class, new GetClassLowering());
        lowerings.put(InvokeNode.class, new InvokeLowering());
        lowerings.put(InvokeWithExceptionNode.class, new InvokeLowering());
    }

    private ForeignCallDescriptor lookupBytecodeException(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, NodeInputList<ValueNode> exceptionArguments, StructuredGraph graph, LoweringTool tool, EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> withoutAllocationDescriptors, EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> withAllocationDescriptors, List<ValueNode> outArguments) {
        ForeignCallDescriptor descriptor;
        if (this.mustNotAllocatePredicate != null && this.mustNotAllocatePredicate.test(graph.method())) {
            descriptor = withoutAllocationDescriptors.get(exceptionKind);
        } else {
            descriptor = withAllocationDescriptors.get(exceptionKind);
            if (exceptionKind.getExceptionMessage() != null) {
                outArguments.add((ValueNode)ConstantNode.forConstant((JavaConstant)tool.getConstantReflection().forString(exceptionKind.getExceptionMessage()), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)graph));
            }
            outArguments.addAll((Collection<ValueNode>)exceptionArguments);
        }
        assert (descriptor != null && descriptor.getArgumentTypes().length == outArguments.size());
        return descriptor;
    }

    static {
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, ImplicitExceptions.GET_CACHED_NULL_POINTER_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, ImplicitExceptions.GET_CACHED_OUT_OF_BOUNDS_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, ImplicitExceptions.GET_CACHED_CLASS_CAST_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, ImplicitExceptions.GET_CACHED_ARRAY_STORE_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_NEGATIVE_LENGTH, ImplicitExceptions.GET_CACHED_ILLEGAL_ARGUMENT_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY, ImplicitExceptions.GET_CACHED_ILLEGAL_ARGUMENT_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, ImplicitExceptions.GET_CACHED_ARITHMETIC_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_NULLARY, ImplicitExceptions.GET_CACHED_ASSERTION_ERROR);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_OBJECT, ImplicitExceptions.GET_CACHED_ASSERTION_ERROR);
        createExceptionDescriptors = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, ImplicitExceptions.CREATE_NULL_POINTER_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, ImplicitExceptions.CREATE_OUT_OF_BOUNDS_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, ImplicitExceptions.CREATE_CLASS_CAST_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, ImplicitExceptions.CREATE_ARRAY_STORE_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_NEGATIVE_LENGTH, ImplicitExceptions.CREATE_ILLEGAL_ARGUMENT_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY, ImplicitExceptions.CREATE_ILLEGAL_ARGUMENT_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, ImplicitExceptions.CREATE_DIVISION_BY_ZERO_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_NULLARY, ImplicitExceptions.CREATE_ASSERTION_ERROR_NULLARY);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_OBJECT, ImplicitExceptions.CREATE_ASSERTION_ERROR_OBJECT);
        throwCachedExceptionDescriptors = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, ImplicitExceptions.THROW_CACHED_NULL_POINTER_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, ImplicitExceptions.THROW_CACHED_OUT_OF_BOUNDS_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, ImplicitExceptions.THROW_CACHED_CLASS_CAST_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, ImplicitExceptions.THROW_CACHED_ARRAY_STORE_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_NEGATIVE_LENGTH, ImplicitExceptions.THROW_CACHED_ILLEGAL_ARGUMENT_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY, ImplicitExceptions.THROW_CACHED_ILLEGAL_ARGUMENT_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, ImplicitExceptions.THROW_CACHED_ARITHMETIC_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_NULLARY, ImplicitExceptions.THROW_CACHED_ASSERTION_ERROR);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_OBJECT, ImplicitExceptions.THROW_CACHED_ASSERTION_ERROR);
        throwNewExceptionDescriptors = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, ImplicitExceptions.THROW_NEW_NULL_POINTER_EXCEPTION);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, ImplicitExceptions.THROW_NEW_OUT_OF_BOUNDS_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, ImplicitExceptions.THROW_NEW_CLASS_CAST_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, ImplicitExceptions.THROW_NEW_ARRAY_STORE_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_NEGATIVE_LENGTH, ImplicitExceptions.THROW_NEW_ILLEGAL_ARGUMENT_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY, ImplicitExceptions.THROW_NEW_ILLEGAL_ARGUMENT_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, ImplicitExceptions.THROW_NEW_DIVISION_BY_ZERO_EXCEPTION);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_NULLARY, ImplicitExceptions.THROW_NEW_ASSERTION_ERROR_NULLARY);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_OBJECT, ImplicitExceptions.THROW_NEW_ASSERTION_ERROR_OBJECT);
    }

    private class InvokeLowering
    implements NodeLoweringProvider<FixedNode> {
        private InvokeLowering() {
        }

        @Override
        public void lower(FixedNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            Invoke invoke = (Invoke)node;
            if (invoke.callTarget() instanceof MethodCallTargetNode) {
                CallTargetNode loweredCallTarget;
                MethodCallTargetNode callTarget = (MethodCallTargetNode)invoke.callTarget();
                NodeInputList parameters = callTarget.arguments();
                ValueNode receiver = parameters.size() <= 0 ? null : (ValueNode)parameters.get(0);
                FixedGuardNode nullCheck = null;
                if (!callTarget.isStatic() && receiver.getStackKind() == JavaKind.Object && !StampTool.isPointerNonNull((ValueNode)receiver)) {
                    LogicNode isNull = (LogicNode)graph.unique((Node)IsNullNode.create((ValueNode)receiver));
                    nullCheck = (FixedGuardNode)graph.add((Node)new FixedGuardNode(isNull, DeoptimizationReason.NullCheckException, DeoptimizationAction.None, true));
                    graph.addBeforeFixed(node, (FixedWithNextNode)nullCheck);
                }
                SharedMethod method = (SharedMethod)callTarget.targetMethod();
                JavaType[] signature = method.getSignature().toParameterTypes((JavaType)(callTarget.isStatic() ? null : method.getDeclaringClass()));
                SubstrateCallingConventionType callType = SubstrateCallingConventionType.JavaCall;
                CallTargetNode.InvokeKind invokeKind = callTarget.invokeKind();
                SharedMethod[] implementations = method.getImplementations();
                LoadHubNode hub = null;
                if (invokeKind.isDirect() || implementations.length == 1) {
                    SharedMethod targetMethod = method;
                    if (!invokeKind.isDirect()) {
                        targetMethod = implementations[0];
                    }
                    if (!SubstrateBackend.shouldEmitOnlyIndirectCalls()) {
                        loweredCallTarget = (CallTargetNode)graph.add((Node)new DirectCallTargetNode((ValueNode[])parameters.toArray((Object[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, (ResolvedJavaMethod)targetMethod, (CallingConvention.Type)callType, invokeKind));
                    } else {
                        JavaConstant codeInfo = SubstrateObjectConstant.forObject(CodeInfoTable.getImageCodeCache());
                        ConstantNode codeInfoConstant = ConstantNode.forConstant((JavaConstant)codeInfo, (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)graph);
                        ConstantNode codeStartFieldOffset = ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)NonSnippetLowerings.this.runtimeConfig.getImageCodeInfoCodeStartOffset(), (StructuredGraph)graph);
                        AddressNode codeStartField = (AddressNode)graph.unique((Node)new OffsetAddressNode((ValueNode)codeInfoConstant, (ValueNode)codeStartFieldOffset));
                        ReadNode codeStart = (ReadNode)graph.add((Node)new ReadNode(codeStartField, LocationIdentity.ANY_LOCATION, FrameAccess.getWordStamp(), OnHeapMemoryAccess.BarrierType.NONE));
                        ConstantNode offset = ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)targetMethod.getCodeOffsetInImage(), (StructuredGraph)graph);
                        AddressNode address = (AddressNode)graph.unique((Node)new OffsetAddressNode((ValueNode)codeStart, (ValueNode)offset));
                        loweredCallTarget = (CallTargetNode)graph.add((Node)new IndirectCallTargetNode((ValueNode)address, (ValueNode[])parameters.toArray((Object[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, (ResolvedJavaMethod)targetMethod, (CallingConvention.Type)callType, invokeKind));
                        graph.addBeforeFixed(node, (FixedWithNextNode)codeStart);
                    }
                } else if (implementations.length == 0) {
                    FixedGuardNode unreachedGuard = (FixedGuardNode)graph.add((Node)new FixedGuardNode((LogicNode)LogicConstantNode.forBoolean((boolean)true, (Graph)graph), DeoptimizationReason.UnreachedCode, DeoptimizationAction.None, true));
                    graph.addBeforeFixed(node, (FixedWithNextNode)unreachedGuard);
                    unreachedGuard.lower(tool);
                    loweredCallTarget = (CallTargetNode)graph.add((Node)new DirectCallTargetNode((ValueNode[])parameters.toArray((Object[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, (ResolvedJavaMethod)method, (CallingConvention.Type)callType, invokeKind));
                } else {
                    int vtableEntryOffset = NonSnippetLowerings.this.runtimeConfig.getVTableOffset(method.getVTableIndex());
                    hub = (LoadHubNode)graph.unique((Node)new LoadHubNode(NonSnippetLowerings.this.runtimeConfig.getProviders().getStampProvider(), (ValueNode)graph.maybeAddOrUnique((Node)PiNode.create((ValueNode)receiver, (ValueNode)nullCheck))));
                    AddressNode address = (AddressNode)graph.unique((Node)new OffsetAddressNode((ValueNode)hub, (ValueNode)ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)vtableEntryOffset, (StructuredGraph)graph)));
                    ReadNode entry = (ReadNode)graph.add((Node)new ReadNode(address, NamedLocationIdentity.FINAL_LOCATION, FrameAccess.getWordStamp(), OnHeapMemoryAccess.BarrierType.NONE));
                    loweredCallTarget = (CallTargetNode)graph.add((Node)new IndirectCallTargetNode((ValueNode)entry, (ValueNode[])parameters.toArray((Object[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, (ResolvedJavaMethod)method, (CallingConvention.Type)callType, invokeKind));
                    graph.addBeforeFixed(node, (FixedWithNextNode)entry);
                }
                callTarget.replaceAndDelete((Node)loweredCallTarget);
                if (nullCheck != null) {
                    nullCheck.lower(tool);
                }
                if (hub != null) {
                    hub.lower(tool);
                }
            }
        }
    }

    private static class GetClassLowering
    implements NodeLoweringProvider<GetClassNode> {
        private GetClassLowering() {
        }

        @Override
        public void lower(GetClassNode node, LoweringTool tool) {
            StampProvider stampProvider = tool.getStampProvider();
            LoadHubNode loadHub = (LoadHubNode)node.graph().unique((Node)new LoadHubNode(stampProvider, node.getObject()));
            node.replaceAtUsagesAndDelete((Node)loadHub);
            tool.getLowerer().lower((Node)loadHub, tool);
        }
    }

    private class ThrowBytecodeExceptionLowering
    implements NodeLoweringProvider<ThrowBytecodeExceptionNode> {
        private ThrowBytecodeExceptionLowering() {
        }

        @Override
        public void lower(ThrowBytecodeExceptionNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                return;
            }
            StructuredGraph graph = node.graph();
            ArrayList arguments = new ArrayList();
            ForeignCallDescriptor descriptor = NonSnippetLowerings.this.lookupBytecodeException(node.getExceptionKind(), (NodeInputList<ValueNode>)node.getArguments(), graph, tool, throwCachedExceptionDescriptors, throwNewExceptionDescriptors, arguments);
            ForeignCallNode foreignCallNode = (ForeignCallNode)graph.add((Node)new ForeignCallNode(descriptor, node.stamp(NodeView.DEFAULT), arguments));
            foreignCallNode.setStateDuring(node.stateBefore());
            node.replaceAndDelete((Node)foreignCallNode);
            DeadEndNode deadEnd = (DeadEndNode)graph.add((Node)new DeadEndNode());
            foreignCallNode.setNext((FixedNode)deadEnd);
        }
    }

    private class BytecodeExceptionLowering
    implements NodeLoweringProvider<BytecodeExceptionNode> {
        private BytecodeExceptionLowering() {
        }

        @Override
        public void lower(BytecodeExceptionNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                return;
            }
            StructuredGraph graph = node.graph();
            ArrayList arguments = new ArrayList();
            ForeignCallDescriptor descriptor = NonSnippetLowerings.this.lookupBytecodeException(node.getExceptionKind(), (NodeInputList<ValueNode>)node.getArguments(), graph, tool, getCachedExceptionDescriptors, createExceptionDescriptors, arguments);
            ForeignCallNode foreignCallNode = (ForeignCallNode)graph.add((Node)new ForeignCallNode(descriptor, node.stamp(NodeView.DEFAULT), arguments));
            foreignCallNode.setStateAfter(node.createStateDuring());
            graph.replaceFixedWithFixed((FixedWithNextNode)node, (FixedWithNextNode)foreignCallNode);
        }
    }
}

