/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.graal.nodes.DeadEndNode;
import java.util.ArrayDeque;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.SwitchNode;
import org.graalvm.compiler.phases.Phase;

public class OptimizeExceptionPathsPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        NodeBitMap exceptionPaths = new NodeBitMap((Graph)graph);
        for (UnwindNode unwind : graph.getNodes().filter(UnwindNode.class)) {
            OptimizeExceptionPathsPhase.walkBack((ControlSinkNode)unwind, exceptionPaths);
        }
        for (DeadEndNode deadEnd : graph.getNodes(DeadEndNode.TYPE)) {
            OptimizeExceptionPathsPhase.walkBack(deadEnd, exceptionPaths);
        }
        for (Node n : exceptionPaths) {
            AbstractBeginNode exceptionBegin = (AbstractBeginNode)n;
            ControlSplitNode controlSplitNode = (ControlSplitNode)exceptionBegin.predecessor();
            if (controlSplitNode.getProfileData().getProfileSource() == ProfileData.ProfileSource.PROFILED) continue;
            controlSplitNode.setProbability(exceptionBegin, BranchProbabilityNode.EXTREMELY_SLOW_PATH_PROFILE);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void walkBack(ControlSinkNode sink, NodeBitMap exceptionPaths) {
        worklist = new ArrayDeque<Object>();
        worklist.push(sink);
        block0: while (!worklist.isEmpty()) {
            node = (Node)worklist.pop();
            predecessor = node.predecessor();
            while (predecessor != null) {
                if (!(predecessor instanceof IfNode) && !(predecessor instanceof SwitchNode) || !(node instanceof AbstractBeginNode)) ** GOTO lbl20
                allSuccessorsInExceptionPaths = true;
                for (Node sux : predecessor.successors()) {
                    if (sux == node || exceptionPaths.contains(sux)) continue;
                    allSuccessorsInExceptionPaths = false;
                    break;
                }
                if (allSuccessorsInExceptionPaths) {
                    for (Node sux : predecessor.successors()) {
                        exceptionPaths.clear(sux);
                    }
                } else {
                    exceptionPaths.mark(node);
                    continue block0;
lbl20:
                    // 1 sources

                    if (predecessor instanceof MergeNode) {
                        for (ValueNode endNode : ((MergeNode)predecessor).cfgPredecessors()) {
                            worklist.push(endNode);
                        }
                        continue block0;
                    }
                    if (predecessor instanceof WithExceptionNode != false && node instanceof AbstractBeginNode != false ? node == ((WithExceptionNode)predecessor).exceptionEdge() : predecessor instanceof AbstractMergeNode != false || predecessor instanceof ControlSplitNode != false) continue block0;
                }
                node = predecessor;
                predecessor = node.predecessor();
            }
        }
    }
}

