/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.remset;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.remset.CardTable;
import com.oracle.svm.core.util.HostedByteBufferPointer;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.replacements.nodes.AssertionNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class UnalignedChunkRememberedSet {
    private UnalignedChunkRememberedSet() {
    }

    @Fold
    public static UnsignedWord getHeaderSize() {
        UnsignedWord headerSize = UnalignedChunkRememberedSet.getCardTableLimitOffset();
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(headerSize, alignment);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void enableRememberedSet(HostedByteBufferPointer chunk) {
        CardTable.cleanTable(UnalignedChunkRememberedSet.getCardTableStart(chunk), UnalignedChunkRememberedSet.getCardTableSize());
    }

    public static void enableRememberedSet(UnalignedHeapChunk.UnalignedHeader chunk) {
        CardTable.cleanTable(UnalignedChunkRememberedSet.getCardTableStart(chunk), UnalignedChunkRememberedSet.getCardTableSize());
        Object obj = UnalignedHeapChunk.getObjectStart(chunk).toObject();
        ObjectHeaderImpl.setRememberedSetBit(obj);
    }

    public static void clearRememberedSet(UnalignedHeapChunk.UnalignedHeader chunk) {
        CardTable.cleanTable(UnalignedChunkRememberedSet.getCardTableStart(chunk), UnalignedChunkRememberedSet.getCardTableSize());
    }

    public static void dirtyCardForObject(Object obj, boolean verifyOnly) {
        UnalignedHeapChunk.UnalignedHeader chunk = UnalignedHeapChunk.getEnclosingChunk(obj);
        Pointer cardTableStart = UnalignedChunkRememberedSet.getCardTableStart(chunk);
        UnsignedWord objectIndex = UnalignedChunkRememberedSet.getObjectIndex();
        if (verifyOnly) {
            AssertionNode.assertion((boolean)false, (boolean)CardTable.isDirty(cardTableStart, objectIndex), (String)"card must be dirty", (Object)"", (Object)"", (long)0L, (long)0L);
        } else {
            CardTable.setDirty(cardTableStart, objectIndex);
        }
    }

    public static void walkDirtyObjects(UnalignedHeapChunk.UnalignedHeader chunk, GreyToBlackObjectVisitor visitor) {
        UnsignedWord objectIndex;
        Pointer rememberedSetStart = UnalignedChunkRememberedSet.getCardTableStart(chunk);
        if (CardTable.isDirty(rememberedSetStart, objectIndex = UnalignedChunkRememberedSet.getObjectIndex())) {
            CardTable.setClean(rememberedSetStart, objectIndex);
            Pointer objectsStart = UnalignedHeapChunk.getObjectStart(chunk);
            Object obj = objectsStart.toObject();
            visitor.visitObjectInline(obj);
        }
    }

    public static boolean verify(UnalignedHeapChunk.UnalignedHeader chunk) {
        return CardTable.verify(UnalignedChunkRememberedSet.getCardTableStart(chunk), UnalignedHeapChunk.getObjectStart(chunk), HeapChunk.getTopPointer(chunk));
    }

    @Fold
    static UnsignedWord getCardTableStartOffset() {
        UnsignedWord headerSize = WordFactory.unsigned((int)SizeOf.get(UnalignedHeapChunk.UnalignedHeader.class));
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(headerSize, alignment);
    }

    @Fold
    static UnsignedWord getCardTableSize() {
        UnsignedWord requiredSize = CardTable.tableSizeForMemorySize(WordFactory.unsigned((int)1));
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(requiredSize, alignment);
    }

    @Fold
    static UnsignedWord getCardTableLimitOffset() {
        UnsignedWord tableStart = UnalignedChunkRememberedSet.getCardTableStartOffset();
        UnsignedWord tableSize = UnalignedChunkRememberedSet.getCardTableSize();
        UnsignedWord tableLimit = tableStart.add(tableSize);
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(tableLimit, alignment);
    }

    @Fold
    static UnsignedWord getObjectIndex() {
        return (UnsignedWord)WordFactory.zero();
    }

    private static Pointer getCardTableStart(UnalignedHeapChunk.UnalignedHeader chunk) {
        return UnalignedChunkRememberedSet.getCardTableStart(HeapChunk.asPointer(chunk));
    }

    private static Pointer getCardTableStart(Pointer chunk) {
        return chunk.add(UnalignedChunkRememberedSet.getCardTableStartOffset());
    }
}

