/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AuxiliaryImageHeap;
import com.oracle.svm.core.genscavenge.GCAccounting;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.HeapPolicyOptions;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ImageHeapWalker;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.PinnedObjectImpl;
import com.oracle.svm.core.genscavenge.RuntimeCodeInfoGCSupportImpl;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceHandlerThreadSupport;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.heap.RuntimeCodeInfoGCSupport;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.UserError;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class HeapImpl
extends Heap {
    private static final VMMutex REF_MUTEX = new VMMutex();
    private static final VMCondition REF_CONDITION = new VMCondition(REF_MUTEX);
    private final YoungGeneration youngGeneration = new YoungGeneration("YoungGeneration");
    private final OldGeneration oldGeneration = new OldGeneration("OldGeneration");
    private final HeapChunkProvider chunkProvider = new HeapChunkProvider();
    private final ObjectHeaderImpl objectHeaderImpl = new ObjectHeaderImpl();
    private final GCImpl gcImpl;
    private final RuntimeCodeInfoGCSupportImpl runtimeCodeInfoGcSupport;
    private final HeapPolicy heapPolicy;
    private final ImageHeapInfo imageHeapInfo = new ImageHeapInfo();
    private Reference<?> refPendingList;
    private volatile long refListOfferCounter;
    private volatile long refListWaiterWakeUpCounter;
    private final UninterruptibleUtils.AtomicReference<PinnedObjectImpl> pinHead = new UninterruptibleUtils.AtomicReference();
    private List<Class<?>> classList;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapImpl(Feature.FeatureAccess access) {
        this.gcImpl = new GCImpl(access);
        this.runtimeCodeInfoGcSupport = new RuntimeCodeInfoGCSupportImpl();
        this.heapPolicy = new HeapPolicy();
        SubstrateDiagnostics.DiagnosticThunkRegister.getSingleton().register(new HeapDiagnosticsPrinter());
    }

    @Fold
    public static HeapImpl getHeapImpl() {
        Heap heap = Heap.getHeap();
        assert (heap instanceof HeapImpl) : "VMConfiguration heap is not a HeapImpl.";
        return (HeapImpl)heap;
    }

    @Fold
    public static ImageHeapInfo getImageHeapInfo() {
        return HeapImpl.getHeapImpl().imageHeapInfo;
    }

    @Fold
    static HeapChunkProvider getChunkProvider() {
        return HeapImpl.getHeapImpl().chunkProvider;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Object obj) {
        return this.isInImageHeap((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Pointer pointer) {
        return this.imageHeapInfo.isInImageHeap(pointer) || AuxiliaryImageHeap.isPresent() && AuxiliaryImageHeap.singleton().containsObject(pointer);
    }

    @Override
    public void suspendAllocation() {
        ThreadLocalAllocation.suspendInCurrentThread();
    }

    @Override
    public void resumeAllocation() {
        ThreadLocalAllocation.resumeInCurrentThread();
    }

    @Override
    public boolean walkObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("must only be executed at a safepoint");
        return this.walkImageHeapObjects(visitor) && this.walkCollectedHeapObjects(visitor);
    }

    boolean walkMemory(MemoryWalker.Visitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("must only be executed at a safepoint");
        return this.walkNativeImageHeapRegions(visitor) && this.getYoungGeneration().walkHeapChunks(visitor) && this.getOldGeneration().walkHeapChunks(visitor) && HeapImpl.getChunkProvider().walkHeapChunks(visitor);
    }

    @Override
    @Uninterruptible(reason="Tear-down in progress.")
    public boolean tearDown() {
        this.youngGeneration.tearDown();
        this.oldGeneration.tearDown();
        HeapImpl.getChunkProvider().tearDown();
        return true;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public ObjectHeader getObjectHeader() {
        return this.objectHeaderImpl;
    }

    ObjectHeaderImpl getObjectHeaderImpl() {
        return this.objectHeaderImpl;
    }

    @Override
    @Fold
    public GC getGC() {
        return this.getGCImpl();
    }

    @Override
    @Fold
    public RuntimeCodeInfoGCSupport getRuntimeCodeInfoGCSupport() {
        return this.runtimeCodeInfoGcSupport;
    }

    GCImpl getGCImpl() {
        return this.gcImpl;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAllocationDisallowed() {
        return NoAllocationVerifier.isActive() || this.gcImpl.isCollectionInProgress();
    }

    static void exitIfAllocationDisallowed(String callSite, String typeName) {
        if (HeapImpl.getHeapImpl().isAllocationDisallowed()) {
            NoAllocationVerifier.exit(callSite, typeName);
        }
    }

    @AlwaysInline(value="GC performance")
    Object promoteObject(Object original, UnsignedWord header) {
        Log trace = Log.noopLog().string("[HeapImpl.promoteObject:").string("  original: ").object(original);
        Object result = HeapPolicy.getMaxSurvivorSpaces() > 0 && !this.getGCImpl().isCompleteCollection() ? this.getYoungGeneration().promoteObject(original, header) : this.getOldGeneration().promoteObject(original, header);
        trace.string("  result: ").object(result).string("]").newline();
        return result;
    }

    HeapPolicy getHeapPolicy() {
        return this.heapPolicy;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public YoungGeneration getYoungGeneration() {
        return this.youngGeneration;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public OldGeneration getOldGeneration() {
        return this.oldGeneration;
    }

    UninterruptibleUtils.AtomicReference<PinnedObjectImpl> getPinHead() {
        return this.pinHead;
    }

    @Uninterruptible(reason="Necessary to return a reasonably consistent value (a GC can change the queried values).")
    public UnsignedWord getUsedBytes() {
        return this.getOldGeneration().getChunkBytes().add(HeapPolicy.getYoungUsedBytes());
    }

    @Uninterruptible(reason="Necessary to return a reasonably consistent value (a GC can change the queried values).")
    public UnsignedWord getCommittedBytes() {
        return this.getUsedBytes().add(HeapImpl.getChunkProvider().getBytesInUnusedChunks());
    }

    void report(Log log) {
        this.report(log, HeapPolicyOptions.TraceHeapChunks.getValue());
    }

    Log report(Log log, boolean traceHeapChunks) {
        log.newline().string("[Heap:").indent(true);
        this.getYoungGeneration().report(log, traceHeapChunks).newline();
        this.getOldGeneration().report(log, traceHeapChunks).newline();
        HeapImpl.getChunkProvider().report(log, traceHeapChunks);
        log.redent(false).string("]");
        return log;
    }

    Log logImageHeapPartitionBoundaries(Log log) {
        log.string("[Native image heap boundaries: ").indent(true);
        ImageHeapWalker.logPartitionBoundaries(log, this.imageHeapInfo);
        log.redent(false).string("]");
        return log;
    }

    static Log zapValuesToLog(Log log) {
        if (HeapPolicy.getZapProducedHeapChunks() || HeapPolicy.getZapConsumedHeapChunks()) {
            log.string("[Heap Chunk zap values: ").indent(true);
            if (HeapPolicy.getZapProducedHeapChunks()) {
                log.string("  producedHeapChunkZapInt: ").string("  hex: ").spaces(8).hex(HeapPolicy.getProducedHeapChunkZapInt()).string("  signed: ").spaces(9).signed(HeapPolicy.getProducedHeapChunkZapInt()).string("  unsigned: ").spaces(10).unsigned(HeapPolicy.getProducedHeapChunkZapInt()).newline();
                log.string("  producedHeapChunkZapWord:").string("  hex: ").hex((WordBase)HeapPolicy.getProducedHeapChunkZapWord()).string("  signed: ").signed((WordBase)HeapPolicy.getProducedHeapChunkZapWord()).string("  unsigned: ").unsigned((WordBase)HeapPolicy.getProducedHeapChunkZapWord());
                if (HeapPolicy.getZapConsumedHeapChunks()) {
                    log.newline();
                }
            }
            if (HeapPolicy.getZapConsumedHeapChunks()) {
                log.string("  consumedHeapChunkZapInt: ").string("  hex: ").spaces(8).hex(HeapPolicy.getConsumedHeapChunkZapInt()).string("  signed: ").spaces(10).signed(HeapPolicy.getConsumedHeapChunkZapInt()).string("  unsigned: ").spaces(10).unsigned(HeapPolicy.getConsumedHeapChunkZapInt()).newline();
                log.string("  consumedHeapChunkZapWord:").string("  hex: ").hex((WordBase)HeapPolicy.getConsumedHeapChunkZapWord()).string("  signed: ").signed((WordBase)HeapPolicy.getConsumedHeapChunkZapWord()).string("  unsigned: ").unsigned((WordBase)HeapPolicy.getConsumedHeapChunkZapWord());
            }
            log.redent(false).string("]");
        }
        return log;
    }

    @Override
    public int getClassCount() {
        return this.imageHeapInfo.dynamicHubCount;
    }

    @Override
    protected List<Class<?>> getAllClasses() {
        if (this.classList == null) {
            ArrayList list = new ArrayList(1024);
            ImageHeapWalker.walkRegions(this.imageHeapInfo, new ClassListBuilderVisitor(list));
            list.trimToSize();
            this.classList = list;
        }
        assert (this.classList.size() == this.imageHeapInfo.dynamicHubCount);
        return this.classList;
    }

    @Override
    public void prepareForSafepoint() {
    }

    @Override
    public void endSafepoint() {
    }

    @Override
    @Uninterruptible(reason="Called during startup.")
    public void attachThread(IsolateThread isolateThread) {
    }

    @Override
    public void detachThread(IsolateThread isolateThread) {
        ThreadLocalAllocation.disableAndFlushForThread(isolateThread);
    }

    @Fold
    public static boolean usesImageHeapChunks() {
        return HeapImpl.usesImageHeapCardMarking();
    }

    @Fold
    public static boolean usesImageHeapCardMarking() {
        Boolean enabled = HeapOptions.ImageHeapCardMarking.getValue();
        if (enabled == Boolean.FALSE || enabled == null && !SubstrateOptions.useRememberedSet()) {
            return false;
        }
        if (enabled == null) {
            return CommittedMemoryProvider.get().guaranteesHeapPreferredAddressSpaceAlignment();
        }
        UserError.guarantee(CommittedMemoryProvider.get().guaranteesHeapPreferredAddressSpaceAlignment(), "Enabling option %s requires a custom image heap alignment at runtime, which cannot be ensured with the current configuration (option %s might be disabled)", new Object[]{HeapOptions.ImageHeapCardMarking, SubstrateOptions.SpawnIsolates});
        return true;
    }

    @Override
    @Fold
    public int getPreferredAddressSpaceAlignment() {
        if (HeapImpl.usesImageHeapChunks()) {
            return UnsignedUtils.safeToInt(HeapPolicy.getAlignedHeapChunkAlignment());
        }
        return ConfigurationValues.getObjectLayout().getAlignment();
    }

    @Override
    @Fold
    public int getImageHeapOffsetInAddressSpace() {
        return 0;
    }

    @Override
    public boolean walkImageHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("Must only be called at a safepoint");
        if (visitor != null) {
            return ImageHeapWalker.walkImageHeapObjects(this.imageHeapInfo, visitor) && (!AuxiliaryImageHeap.isPresent() || AuxiliaryImageHeap.singleton().walkObjects(visitor));
        }
        return true;
    }

    @Override
    public boolean walkCollectedHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("Must only be called at a safepoint");
        return this.getYoungGeneration().walkObjects(visitor) && this.getOldGeneration().walkObjects(visitor);
    }

    boolean walkNativeImageHeapRegions(MemoryWalker.ImageHeapRegionVisitor visitor) {
        return ImageHeapWalker.walkRegions(this.imageHeapInfo, visitor) && (!AuxiliaryImageHeap.isPresent() || AuxiliaryImageHeap.singleton().walkRegions(visitor));
    }

    @Override
    public BarrierSet createBarrierSet(MetaAccessProvider metaAccess) {
        return RememberedSet.get().createBarrierSet(metaAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Only the GC increments the volatile field 'refListOfferCounter'.")
    void addToReferencePendingList(Reference<?> list) {
        VMOperation.guaranteeGCInProgress("Must only be called during a GC.");
        if (list == null) {
            return;
        }
        REF_MUTEX.lock();
        try {
            if (this.refPendingList != null) {
                Reference<?> current = this.refPendingList;
                Reference<?> next = ReferenceInternals.getNextDiscovered(current);
                while (next != null) {
                    current = next;
                    next = ReferenceInternals.getNextDiscovered(current);
                }
                ReferenceInternals.setNextDiscovered(current, list);
            } else {
                this.refPendingList = list;
                ++this.refListOfferCounter;
                REF_CONDITION.broadcast();
            }
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public boolean hasReferencePendingList() {
        REF_MUTEX.lockNoTransition();
        try {
            boolean bl = this.refPendingList != null;
            return bl;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    public void waitForReferencePendingList() throws InterruptedException {
        assert (Thread.currentThread() == ((ReferenceHandlerThreadSupport)ImageSingletons.lookup(ReferenceHandlerThreadSupport.class)).getThread());
        long initialOffers = this.refListOfferCounter;
        long initialWakeUps = this.refListWaiterWakeUpCounter;
        if (this.hasReferencePendingList()) {
            return;
        }
        if (Thread.interrupted() || !HeapImpl.waitForPendingReferenceList(initialOffers, initialWakeUps) && Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForPendingReferenceList(long initialOffers, long initialWakeUps) {
        Thread currentThread = Thread.currentThread();
        int oldThreadStatus = JavaThreads.getThreadStatus(currentThread);
        JavaThreads.setThreadStatus(currentThread, 657);
        try {
            boolean bl = HeapImpl.transitionToNativeThenAwaitPendingRefs(initialOffers, initialWakeUps);
            return bl;
        }
        finally {
            JavaThreads.setThreadStatus(currentThread, oldThreadStatus);
        }
    }

    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
    private static boolean transitionToNativeThenAwaitPendingRefs(long initialOffers, long initialWakeUps) {
        CFunctionPrologueNode.cFunctionPrologue(3);
        boolean offered = HeapImpl.awaitPendingRefsInNative(initialOffers, initialWakeUps);
        CFunctionEpilogueNode.cFunctionEpilogue(3);
        return offered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="In native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static boolean awaitPendingRefsInNative(long initialOffers, long initialWakeUps) {
        REF_MUTEX.lockNoTransition();
        try {
            while (HeapImpl.getHeapImpl().refListOfferCounter == initialOffers && HeapImpl.getHeapImpl().refListWaiterWakeUpCounter == initialWakeUps) {
                REF_CONDITION.blockNoTransition();
            }
            boolean bl = HeapImpl.getHeapImpl().refListWaiterWakeUpCounter == initialWakeUps;
            return bl;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="We use a lock when incrementing the volatile field 'refListWaiterWakeUpCounter'.")
    public void wakeUpReferencePendingListWaiters() {
        REF_MUTEX.lockNoTransition();
        try {
            ++this.refListWaiterWakeUpCounter;
            REF_CONDITION.broadcast();
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public Reference<?> getAndClearReferencePendingList() {
        REF_MUTEX.lockNoTransition();
        try {
            Reference<?> list = this.refPendingList;
            if (list != null) {
                this.refPendingList = null;
            }
            Reference<?> reference = list;
            return reference;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    private static class HeapDiagnosticsPrinter
    implements SubstrateDiagnostics.DiagnosticThunk {
        private HeapDiagnosticsPrinter() {
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void invokeWithoutAllocation(Log log) {
            HeapImpl heap = HeapImpl.getHeapImpl();
            GCImpl gc = GCImpl.getGCImpl();
            log.string("[Heap settings and statistics: ").indent(true);
            log.string("Supports isolates: ").bool(SubstrateOptions.SpawnIsolates.getValue()).newline();
            log.string("Object reference size: ").signed(ConfigurationValues.getObjectLayout().getReferenceSize()).newline();
            GCAccounting accounting = gc.getAccounting();
            log.string("Incremental collections: ").unsigned(accounting.getIncrementalCollectionCount()).newline();
            log.string("Complete collections: ").unsigned(accounting.getCompleteCollectionCount());
            log.redent(false).string("]").newline();
            log.newline();
            heap.logImageHeapPartitionBoundaries(log).newline();
            HeapImpl.zapValuesToLog(log).newline();
            heap.report(log, true).newline();
            log.newline();
        }
    }

    private static class ClassListBuilderVisitor
    implements MemoryWalker.ImageHeapRegionVisitor,
    ObjectVisitor {
        private final List<Class<?>> list;

        ClassListBuilderVisitor(List<Class<?>> list) {
            this.list = list;
        }

        @Override
        public <T> boolean visitNativeImageHeapRegion(T region, MemoryWalker.NativeImageHeapRegionAccess<T> access) {
            if (!access.isWritable(region) && access.containsReferences(region)) {
                access.visitObjects(region, this);
            }
            return true;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true, reason="Allocation is fine: this method traverses only the image heap.")
        public boolean visitObject(Object o) {
            if (o instanceof Class) {
                this.list.add((Class)o);
            }
            return true;
        }
    }
}

