/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.genscavenge.AbstractImageHeapLayouter;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapAllocator;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapPartition;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.HostedImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.ImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.RuntimeImageHeapChunkWriter;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayoutInfo;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.graalvm.compiler.core.common.NumUtil;

public class ChunkedImageHeapLayouter
extends AbstractImageHeapLayouter<ChunkedImageHeapPartition> {
    private final ImageHeapInfo heapInfo;
    private final long startOffset;
    private final boolean compressedNullPadding;
    private final long hugeObjectThreshold;
    private ChunkedImageHeapAllocator allocator;

    public ChunkedImageHeapLayouter(ImageHeapInfo heapInfo, long startOffset, boolean compressedNullPadding) {
        this.heapInfo = heapInfo;
        this.startOffset = startOffset;
        this.compressedNullPadding = compressedNullPadding;
        this.hugeObjectThreshold = HeapPolicy.getLargeArrayThreshold().rawValue();
    }

    protected ChunkedImageHeapPartition[] createPartitionsArray(int count) {
        return new ChunkedImageHeapPartition[count];
    }

    @Override
    protected ChunkedImageHeapPartition createPartition(String name, boolean containsReferences, boolean writable, boolean hugeObjects) {
        return new ChunkedImageHeapPartition(name, writable, hugeObjects);
    }

    @Override
    protected long getHugeObjectThreshold() {
        return this.hugeObjectThreshold;
    }

    @Override
    protected ImageHeapLayoutInfo doLayout(ImageHeap imageHeap) {
        assert (!this.compressedNullPadding || AlignedHeapChunk.getObjectsStartOffset().aboveThan(0)) : "Expecting header to pad start so object offsets are strictly greater than 0";
        this.allocator = new ChunkedImageHeapAllocator(imageHeap, this.startOffset);
        for (ChunkedImageHeapPartition partition : (ChunkedImageHeapPartition[])this.getPartitions()) {
            partition.layout(this.allocator);
        }
        return this.populateInfoObjects(imageHeap.countDynamicHubs());
    }

    private ImageHeapLayoutInfo populateInfoObjects(int dynamicHubCount) {
        ChunkedImageHeapAllocator.UnalignedChunk chunk;
        long writableBegin = ((ChunkedImageHeapPartition)this.getWritablePrimitive()).getStartOffset();
        for (ChunkedImageHeapAllocator.AlignedChunk chunk2 : this.allocator.getAlignedChunks()) {
            if (!chunk2.isWritable() || chunk2.getBegin() >= writableBegin) continue;
            assert (writableBegin <= chunk2.getEnd());
            writableBegin = chunk2.getBegin();
            break;
        }
        long firstWritableUnalignedChunk = -1L;
        Iterator<ChunkedImageHeapAllocator.UnalignedChunk> iterator = this.allocator.getUnalignedChunks().iterator();
        if (iterator.hasNext() && (chunk = iterator.next()).isWritable()) {
            firstWritableUnalignedChunk = chunk.getBegin();
        }
        this.heapInfo.initialize(((ChunkedImageHeapPartition)this.getReadOnlyPrimitive()).firstObject, ((ChunkedImageHeapPartition)this.getReadOnlyPrimitive()).lastObject, ((ChunkedImageHeapPartition)this.getReadOnlyReference()).firstObject, ((ChunkedImageHeapPartition)this.getReadOnlyReference()).lastObject, ((ChunkedImageHeapPartition)this.getReadOnlyRelocatable()).firstObject, ((ChunkedImageHeapPartition)this.getReadOnlyRelocatable()).lastObject, ((ChunkedImageHeapPartition)this.getWritablePrimitive()).firstObject, ((ChunkedImageHeapPartition)this.getWritablePrimitive()).lastObject, ((ChunkedImageHeapPartition)this.getWritableReference()).firstObject, ((ChunkedImageHeapPartition)this.getWritableReference()).lastObject, ((ChunkedImageHeapPartition)this.getWritableHuge()).firstObject, ((ChunkedImageHeapPartition)this.getWritableHuge()).lastObject, ((ChunkedImageHeapPartition)this.getReadOnlyHuge()).firstObject, ((ChunkedImageHeapPartition)this.getReadOnlyHuge()).lastObject, writableBegin, firstWritableUnalignedChunk, dynamicHubCount);
        return this.createLayoutInfo(this.startOffset, writableBegin);
    }

    @Override
    public void writeMetadata(ByteBuffer imageHeapBytes, long imageHeapOffsetInBuffer) {
        long layoutToBufferOffsetAddend = imageHeapOffsetInBuffer - this.startOffset;
        ImageHeapChunkWriter writer = SubstrateUtil.HOSTED ? new HostedImageHeapChunkWriter(imageHeapBytes, layoutToBufferOffsetAddend) : new RuntimeImageHeapChunkWriter(imageHeapBytes, layoutToBufferOffsetAddend);
        ChunkedImageHeapLayouter.writeHeaders(writer, this.allocator.getAlignedChunks());
        ChunkedImageHeapLayouter.writeHeaders(writer, this.allocator.getUnalignedChunks());
    }

    private static void writeHeaders(ImageHeapChunkWriter writer, List<? extends ChunkedImageHeapAllocator.Chunk> chunks) {
        ChunkedImageHeapAllocator.Chunk previous = null;
        ChunkedImageHeapAllocator.Chunk current = null;
        for (ChunkedImageHeapAllocator.Chunk chunk : chunks) {
            ChunkedImageHeapLayouter.writeHeader(writer, previous, current, chunk);
            previous = current;
            current = chunk;
        }
        ChunkedImageHeapLayouter.writeHeader(writer, previous, current, null);
    }

    private static void writeHeader(ImageHeapChunkWriter writer, ChunkedImageHeapAllocator.Chunk previous, ChunkedImageHeapAllocator.Chunk current, ChunkedImageHeapAllocator.Chunk next) {
        if (current != null) {
            long offsetToPrevious = previous != null ? previous.getBegin() - current.getBegin() : 0L;
            long offsetToNext = next != null ? next.getBegin() - current.getBegin() : 0L;
            int chunkPosition = NumUtil.safeToInt((long)current.getBegin());
            if (current instanceof ChunkedImageHeapAllocator.AlignedChunk) {
                ChunkedImageHeapAllocator.AlignedChunk aligned = (ChunkedImageHeapAllocator.AlignedChunk)current;
                writer.initializeAlignedChunk(chunkPosition, current.getTopOffset(), current.getEndOffset(), offsetToPrevious, offsetToNext);
                writer.enableRememberedSetForAlignedChunk(chunkPosition, aligned.getObjects());
            } else {
                assert (current instanceof ChunkedImageHeapAllocator.UnalignedChunk);
                writer.initializeUnalignedChunk(chunkPosition, current.getTopOffset(), current.getEndOffset(), offsetToPrevious, offsetToNext);
                writer.enableRememberedSetForUnalignedChunk(chunkPosition);
            }
        }
    }
}

