/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.util.json.JSONParserException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class ConfigurationParser {
    public void parseAndRegister(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            this.parseAndRegister(reader);
        }
    }

    public abstract void parseAndRegister(Reader var1) throws IOException;

    protected static List<Object> asList(Object data, String errorMessage) {
        if (data instanceof List) {
            return (List)data;
        }
        throw new JSONParserException(errorMessage);
    }

    protected static Map<String, Object> asMap(Object data, String errorMessage) {
        if (data instanceof Map) {
            return (Map)data;
        }
        throw new JSONParserException(errorMessage);
    }

    protected static void checkAttributes(Map<String, Object> map, String type, Collection<String> requiredAttrs, Collection<String> optionalAttrs) {
        ArrayList<String> unseenRequired = new ArrayList<String>(requiredAttrs);
        for (String key : map.keySet()) {
            boolean required = unseenRequired.remove(key);
            if (required || optionalAttrs.contains(key)) continue;
            ArrayList<String> supported = new ArrayList<String>(requiredAttrs);
            supported.addAll(optionalAttrs);
            throw new JSONParserException("Unknown attribute '" + key + "' (supported attributes: " + supported + ") in resource definition");
        }
        if (!unseenRequired.isEmpty()) {
            throw new JSONParserException("Missing attribute '" + (String)unseenRequired.get(0) + "' in " + type);
        }
    }

    protected static void checkAttributes(Map<String, Object> data, String type, List<String> requiredAttrs) {
        ConfigurationParser.checkAttributes(data, type, requiredAttrs, Collections.emptyList());
    }

    protected static String asString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JSONParserException("Invalid string value \"" + value + "\".");
    }

    protected static String asString(Object value, String propertyName) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JSONParserException("Invalid string value \"" + value + "\" for element '" + propertyName + "'");
    }

    protected static String asNullableString(Object value, String propertyName) {
        return value == null ? null : ConfigurationParser.asString(value, propertyName);
    }

    protected static boolean asBoolean(Object value, String propertyName) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new JSONParserException("Invalid boolean value '" + value + "' for element '" + propertyName + "'");
    }

    protected static long asLong(Object value, String propertyName) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        throw new JSONParserException("Invalid long value '" + value + "' for element '" + propertyName + "'");
    }
}

