/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.allocationprofile;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class AllocationCounter {
    private final String name;
    @UnknownObjectField(types={AllocationCounter.class})
    private AllocationCounter next;
    private long count;
    private long size;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final Field COUNT_FIELD;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final Field SIZE_FIELD;

    protected AllocationCounter(String name, AllocationCounter next) {
        this.name = name;
        this.next = next;
    }

    public final void incrementCount() {
        ++this.count;
    }

    public final void incrementSize(long inc) {
        this.size += inc;
    }

    public String getName() {
        return this.name;
    }

    public AllocationCounter getNext() {
        return this.next;
    }

    @NeverInline(value="field is written in allocation snippet, so must not be accessed in method that performs allocation")
    public long getCount() {
        return this.count;
    }

    @NeverInline(value="field is written in allocation snippet, so must not be accessed in method that performs allocation")
    public long getSize() {
        return this.size;
    }

    static {
        try {
            COUNT_FIELD = AllocationCounter.class.getDeclaredField("count");
            SIZE_FIELD = AllocationCounter.class.getDeclaredField("size");
        }
        catch (NoSuchFieldException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

