/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.APIOptionGroup;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.XOptions;
import com.oracle.svm.core.util.UserError;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.SpectrePHTMitigations;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionStability;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

public class SubstrateOptions {
    @Option(help={"When true, compiler graphs are parsed only once before static analysis. When false, compiler graphs are parsed for static analysis and again for AOT compilation."})
    public static final HostedOptionKey<Boolean> ParseOnce = new HostedOptionKey<Boolean>(true);
    @Option(help={"Module containing the class that contains the main entry point. Optional if --shared is used."}, type=OptionType.User)
    public static final HostedOptionKey<String> Module = new HostedOptionKey<String>("");
    @Option(help={"Class containing the default entry point method. Optional if --shared is used."}, type=OptionType.User)
    public static final HostedOptionKey<String> Class = new HostedOptionKey<String>("");
    @Option(help={"Name of the main entry point method. Optional if --shared is used."})
    public static final HostedOptionKey<String> Method = new HostedOptionKey<String>("main");
    @Option(help={"Name of the output file to be generated"}, type=OptionType.User)
    public static final HostedOptionKey<String> Name = new HostedOptionKey<String>("");
    @APIOption(name={"shared"})
    @Option(help={"Build shared library"})
    public static final HostedOptionKey<Boolean> SharedLibrary = new HostedOptionKey<Boolean>(false);
    @APIOption(name={"static"})
    @Option(help={"Build statically linked executable (requires static libc and zlib)"})
    public static final HostedOptionKey<Boolean> StaticExecutable = new HostedOptionKey<Boolean>(false);
    @APIOption(name={"target"})
    @Option(help={"Selects native-image compilation target (in <OS>-<architecture> format). Defaults to host's OS-architecture pair."})
    public static final HostedOptionKey<String> TargetPlatform = new HostedOptionKey<String>("");
    @Option(help={"Builds a statically linked executable with libc dynamically linked"}, type=OptionType.Expert, stability=OptionStability.EXPERIMENTAL)
    public static final HostedOptionKey<Boolean> StaticExecutableWithDynamicLibC = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            StaticExecutable.update(values, true);
            super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
        }
    };
    @Option(help={"Build with Loom JDK"})
    public static final HostedOptionKey<Boolean> UseLoom = new HostedOptionKey<Boolean>(false);
    public static final int ForceFallback = 10;
    public static final int Automatic = 5;
    public static final int NoFallback = 0;
    public static final String OptionNameForceFallback = "force-fallback";
    public static final String OptionNameAutoFallback = "auto-fallback";
    public static final String OptionNameNoFallback = "no-fallback";
    @APIOption.List(value={@APIOption(name={"force-fallback"}, fixedValue={"10"}, customHelp="force building of fallback image"), @APIOption(name={"auto-fallback"}, fixedValue={"5"}, customHelp="build stand-alone image if possible"), @APIOption(name={"no-fallback"}, fixedValue={"0"}, customHelp="build stand-alone image or report failure")})
    @Option(help={"Define when fallback-image generation should be used."})
    public static final HostedOptionKey<Integer> FallbackThreshold = new HostedOptionKey<Integer>(5);
    public static final String IMAGE_CLASSPATH_PREFIX = "-imagecp";
    public static final String IMAGE_MODULEPATH_PREFIX = "-imagemp";
    public static final String WATCHPID_PREFIX = "-watchpid";
    private static ValueUpdateHandler optimizeValueUpdateHandler;
    private static ValueUpdateHandler debugInfoValueUpdateHandler;
    @Option(help={"Show available options based on comma-separated option-types (allowed categories: User, Expert, Debug)."})
    public static final OptionKey<String> PrintFlags;
    @Option(help={"Print extra help, if available, based on comma-separated option names. Pass * to show all options that contain extra help."})
    public static final OptionKey<String> PrintFlagsWithExtraHelp;
    @Option(help={"Control native-image code optimizations: 0 - no optimizations, 1 - basic optimizations, 2 - aggressive optimizations."}, type=OptionType.User)
    public static final HostedOptionKey<Integer> Optimize;
    @Option(help={"Track NodeSourcePositions during runtime-compilation"})
    public static final HostedOptionKey<Boolean> IncludeNodeSourcePositions;
    @Option(help={"Search path for C libraries passed to the linker (list of comma-separated directories)"})
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> CLibraryPath;
    @Option(help={"Path passed to the linker as the -rpath (list of comma-separated directories)"})
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> LinkerRPath;
    @Option(help={"Directory of the image file to be generated"}, type=OptionType.User)
    public static final HostedOptionKey<String> Path;
    @APIOption(name={"serial"}, group=GCGroup.class, customHelp="Serial garbage collector")
    @Option(help={"Use a serial GC"})
    public static final HostedOptionKey<Boolean> UseSerialGC;
    @APIOption(name={"epsilon"}, group=GCGroup.class, customHelp="Epsilon garbage collector")
    @Option(help={"Use a no-op GC"})
    public static final HostedOptionKey<Boolean> UseEpsilonGC;
    @Option(help={"The size of each thread stack at run-time, in bytes."}, type=OptionType.User)
    public static final RuntimeOptionKey<Long> StackSize;
    @Option(help={"The maximum number of lines in the stack trace for Java exceptions (0 means all)"}, type=OptionType.User)
    public static final RuntimeOptionKey<Integer> MaxJavaStackTraceDepth;
    @Option(help={"Maximum total size of NIO direct-buffer allocations"})
    public static final RuntimeOptionKey<Long> MaxDirectMemorySize;
    @Option(help={"Verify naming conventions during image construction."})
    public static final HostedOptionKey<Boolean> VerifyNamingConventions;
    @Option(help={"Enable support for threads and and thread-local variables (disable for single-threaded implementation)"})
    public static final HostedOptionKey<Boolean> MultiThreaded;
    @Option(help={"Use only a writable native image heap (requires ld.gold linker)"})
    public static final HostedOptionKey<Boolean> ForceNoROSectionRelocations;
    @Option(help={"Support multiple isolates."})
    public static final HostedOptionKey<Boolean> SpawnIsolates;
    @Option(help={"Trace VMOperation execution."})
    public static final HostedOptionKey<Boolean> TraceVMOperations;
    @APIOption(name={"trace-class-initialization"})
    @Option(help={"Comma-separated list of fully-qualified class names that class initialization is traced for."})
    public static final HostedOptionKey<String> TraceClassInitialization;
    @APIOption(name={"trace-object-instantiation"})
    @Option(help={"Comma-separated list of fully-qualified class names that object instantiation is traced for."})
    public static final HostedOptionKey<String> TraceObjectInstantiation;
    @Option(help={"Trace all native tool invocations as part of image building"}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> TraceNativeToolUsage;
    @Option(help={"Prefix that is added to the names of entry point methods."})
    public static final HostedOptionKey<String> EntryPointNamePrefix;
    @Option(help={"Prefix that is added to the names of API functions."})
    public static final HostedOptionKey<String> APIFunctionPrefix;
    @APIOption.List(value={@APIOption(name={"enable-http"}, fixedValue={"http"}, customHelp="enable http support in the generated image"), @APIOption(name={"enable-https"}, fixedValue={"https"}, customHelp="enable https support in the generated image"), @APIOption(name={"enable-url-protocols"})})
    @Option(help={"List of comma separated URL protocols to enable."})
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> EnableURLProtocols;
    @APIOption(name={"enable-all-security-services"})
    @Option(help={"Add all security service classes to the generated image."}, deprecated=true)
    public static final HostedOptionKey<Boolean> EnableAllSecurityServices;
    @Option(help={"Enable Java Native Interface (JNI) support."})
    public static final HostedOptionKey<Boolean> JNI;
    @Option(help={"Report information about known JNI elements when lookup fails"}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> JNIVerboseLookupErrors;
    @Option(help={"Export Invocation API symbols."}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> JNIExportSymbols;
    @Option(help={"Alignment of AOT and JIT compiled code in bytes."})
    public static final HostedOptionKey<Integer> CodeAlignment;
    @Option(help={"Number of cache lines to load after the array allocation using prefetch instructions."})
    public static final HostedOptionKey<Integer> AllocatePrefetchLines;
    @Option(help={"Number of cache lines to load after the object address using prefetch instructions."})
    public static final HostedOptionKey<Integer> AllocateInstancePrefetchLines;
    @Option(help={"Generated code style for prefetch instructions: for 0 or less no prefetch instructions are generated and for 1 or more prefetch instructions are introduced after each allocation."})
    public static final HostedOptionKey<Integer> AllocatePrefetchStyle;
    @Option(help={"Sets the prefetch instruction to prefetch ahead of the allocation pointer. Possible values are from 0 to 3. The actual instructions behind the values depend on the platform."})
    public static final HostedOptionKey<Integer> AllocatePrefetchInstr;
    @Option(help={"The number of nanoseconds before and between which tearing down an isolate gives a warning message.  0 implies no warning."})
    public static final RuntimeOptionKey<Long> TearDownWarningNanos;
    @Option(help={"The number of nanoseconds before tearing down an isolate gives a failure message.  0 implies no message."})
    public static final RuntimeOptionKey<Long> TearDownFailureNanos;
    @Option(help={"Sets the size (in bytes) of the prefetch distance for object allocation. Memory about to be written with the value of new objects is prefetched up to this distance starting from the address of the last allocated object. Each Java thread has its own allocation point."})
    public static final HostedOptionKey<Integer> AllocatePrefetchDistance;
    @Option(help={"Sets the step size (in bytes) for sequential prefetch instructions."})
    public static final HostedOptionKey<Integer> AllocatePrefetchStepSize;
    @Option(help={"Define the maximum number of stores for which the loop that zeroes out objects is unrolled."})
    public static final HostedOptionKey<Integer> MaxUnrolledObjectZeroingStores;
    @Option(help={"Provide method names for stack traces."})
    public static final HostedOptionKey<Boolean> StackTrace;
    @Option(help={"Parse and consume standard options and system properties from the command line arguments when the VM is created."})
    public static final HostedOptionKey<Boolean> ParseRuntimeOptions;
    @Option(help={"Enable wildcard expansion in command line arguments on Windows."})
    public static final HostedOptionKey<Boolean> EnableWildcardExpansion;
    @Option(help={"Perform method inlining in the AOT compiled native image"})
    public static final HostedOptionKey<Boolean> AOTInline;
    @Option(help={"Perform trivial method inlining in the AOT compiled native image"})
    public static final HostedOptionKey<Boolean> AOTTrivialInline;
    @Option(help={"file:doc-files/NeverInlineHelp.txt"}, type=OptionType.Debug)
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> NeverInline;
    @Option(help={"Maximum number of nodes in a method so that it is considered trivial."})
    public static final HostedOptionKey<Integer> MaxNodesInTrivialMethod;
    @Option(help={"Maximum number of invokes in a method so that it is considered trivial (for testing only)."})
    public static final HostedOptionKey<Integer> MaxInvokesInTrivialMethod;
    @Option(help={"Maximum number of nodes in a method so that it is considered trivial, if it does not have any invokes."})
    public static final HostedOptionKey<Integer> MaxNodesInTrivialLeafMethod;
    @Option(help={"Saves stack base pointer on the stack on method entry."})
    public static final HostedOptionKey<Boolean> PreserveFramePointer;
    @Option(help={"Use callee saved registers to reduce spilling for low-frequency calls to stubs (if callee saved registers are supported by the architecture)"})
    public static final HostedOptionKey<Boolean> UseCalleeSavedRegisters;
    @Option(help={"Report error if <typename>[:<UsageKind>{,<UsageKind>}] is discovered during analysis (valid values for UsageKind: InHeap, Allocated, Reachable)."}, type=OptionType.Debug)
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ReportAnalysisForbiddenType;
    @Option(help={"Backend used by the compiler"}, type=OptionType.User)
    public static final HostedOptionKey<String> CompilerBackend;
    @Option(help={"Determines if VM operations should be executed in a dedicated thread."}, type=OptionType.Expert)
    public static final HostedOptionKey<Boolean> UseDedicatedVMOperationThread;
    @Option(help={"Use linker option to prevent unreferenced symbols in image."})
    public static final HostedOptionKey<Boolean> RemoveUnusedSymbols;
    @Option(help={"Use linker option to remove all local symbols from image."})
    public static final HostedOptionKey<Boolean> DeleteLocalSymbols;
    @Option(help={"Compatibility option to make symbols used for the image heap global. Using global symbols is problematic for shared libraries because the loader implicitly changes the value when the symbol is already defined in the executable loading the library. Setting this option to true preserves the broken behavior of old Native Image versions."})
    public static final HostedOptionKey<Boolean> InternalSymbolsAreGlobal;
    @Option(help={"Common prefix used by method symbols in image."})
    public static final HostedOptionKey<String> ImageSymbolsPrefix;
    @Option(help={"Fold SecurityManager getter."}, stability=OptionStability.EXPERIMENTAL, type=OptionType.Expert)
    public static final HostedOptionKey<Boolean> FoldSecurityManagerGetter;
    @APIOption(name={"native-compiler-path"})
    @Option(help={"Provide custom path to C compiler used for query code compilation and linking."}, type=OptionType.User)
    public static final HostedOptionKey<String> CCompilerPath;
    @APIOption(name={"native-compiler-options"})
    @Option(help={"Provide custom C compiler option used for query code compilation."}, type=OptionType.User)
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> CCompilerOption;
    @Option(help={"Use strict checks when performing query code compilation."}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> StrictQueryCodeCompilation;
    @APIOption(name={"native-image-info"})
    @Option(help={"Show native-toolchain information and image-build settings"}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> DumpTargetInfo;
    @Option(help={"Check if native-toolchain is known to work with native-image"}, type=OptionType.Expert)
    public static final HostedOptionKey<Boolean> CheckToolchain;
    @APIOption(name={"install-exit-handlers"})
    @Option(help={"Provide java.lang.Terminator exit handlers for executable images"}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> InstallExitHandlers;
    @Option(help={"When set to true, the image generator verifies that the image heap does not contain a home directory as a substring"}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> DetectUserDirectoriesInImageHeap;
    @Option(help={"The interval in minutes between watchdog checks (0 disables the watchdog)"}, type=OptionType.Expert)
    public static final HostedOptionKey<Integer> DeadlockWatchdogInterval;
    @Option(help={"Exit the image builder VM after printing call stacks"}, type=OptionType.Expert)
    public static final HostedOptionKey<Boolean> DeadlockWatchdogExitOnTimeout;
    @Option(help={"Populate reference queues in a separate thread rather than after a garbage collection."}, type=OptionType.Expert)
    public static final HostedOptionKey<Boolean> UseReferenceHandlerThread;
    @APIOption(name={"-g"}, fixedValue={"2"}, customHelp="generate debugging information")
    @Option(help={"Insert debug info into the generated native image or library"})
    public static final HostedOptionKey<Integer> GenerateDebugInfo;
    @Option(help={"Search path for source files for Application or GraalVM classes (list of comma-separated directories or jar files)"})
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> DebugInfoSourceSearchPath;
    @Option(help={"Directory under which to create source file cache for Application or GraalVM classes"})
    public static final HostedOptionKey<String> DebugInfoSourceCacheRoot;
    @Option(help={"Omit generation of DebugLineInfo originating from inlined methods"})
    public static final HostedOptionKey<Boolean> OmitInlinedMethodDebugLineInfo;
    @Option(help={"Size of the reserved address space of each compilation isolate (0: default for new isolates)."})
    public static final RuntimeOptionKey<Long> CompilationIsolateAddressSpaceSize;
    @Option(help={"Overwrites the available number of processors provided by the OS. Any value <= 0 means using the processor count from the OS."})
    public static final RuntimeOptionKey<Integer> ActiveProcessorCount;
    @Option(help={"For internal purposes only. Disables type id result verification even when running with assertions enabled."}, stability=OptionStability.EXPERIMENTAL, type=OptionType.Debug)
    public static final HostedOptionKey<Boolean> DisableTypeIdResultVerification;
    @Option(help={"Enables the signal API (sun.misc.Signal or jdk.internal.misc.Signal). Defaults to false for shared library and true for executables"}, stability=OptionStability.EXPERIMENTAL, type=OptionType.Expert)
    public static final HostedOptionKey<Boolean> EnableSignalAPI;
    @Option(help={"Enable Java Flight Recorder."})
    public static final RuntimeOptionKey<Boolean> FlightRecorder;
    @Option(help={"Start flight recording with options."})
    public static final RuntimeOptionKey<String> StartFlightRecording;
    @Option(help={"file:doc-files/FlightRecorderLoggingHelp.txt"})
    public static final RuntimeOptionKey<String> FlightRecorderLogging;

    public static boolean parseOnce() {
        return ParseOnce.getValue() != false && !DeoptimizationSupport.enabled();
    }

    public static void setOptimizeValueUpdateHandler(ValueUpdateHandler updateHandler) {
        optimizeValueUpdateHandler = updateHandler;
    }

    public static void setDebugInfoValueUpdateHandler(ValueUpdateHandler updateHandler) {
        debugInfoValueUpdateHandler = updateHandler;
    }

    public static final long getTearDownWarningNanos() {
        return TearDownWarningNanos.getValue();
    }

    public static final long getTearDownFailureNanos() {
        return TearDownFailureNanos.getValue();
    }

    @Fold
    public static boolean useLLVMBackend() {
        return "llvm".equals(CompilerBackend.getValue());
    }

    @Fold
    public static int codeAlignment() {
        return CodeAlignment.getValue();
    }

    public static void defaultDebugInfoValueUpdateHandler(EconomicMap<OptionKey<?>, Object> values, Integer oldValue, Integer newValue) {
        GraalOptions.TrackNodeSourcePosition.update(values, (Object)(newValue > 0 ? 1 : 0));
        if (OS.WINDOWS.isCurrent()) {
            DeleteLocalSymbols.update(values, newValue == 0);
        }
    }

    public static Path getDebugInfoSourceCacheRoot() {
        try {
            return Paths.get(Path.getValue(), new String[0]).resolve(DebugInfoSourceCacheRoot.getValue());
        }
        catch (InvalidPathException ipe) {
            throw UserError.abort("Invalid path provided for option DebugInfoSourceCacheRoot %s", DebugInfoSourceCacheRoot.getValue());
        }
    }

    @Fold
    public static boolean supportCompileInIsolates() {
        UserError.guarantee(ConcealedOptions.SupportCompileInIsolates.getValue() == false || SpawnIsolates.getValue() != false, "Option %s must be enabled to support isolated compilations through option %s", SpawnIsolates.getName(), ConcealedOptions.SupportCompileInIsolates.getName());
        return ConcealedOptions.SupportCompileInIsolates.getValue();
    }

    public static boolean shouldCompileInIsolates() {
        return SubstrateOptions.supportCompileInIsolates() && ConcealedOptions.CompileInIsolates.getValue() != false;
    }

    @Fold
    public static boolean useRememberedSet() {
        return UseEpsilonGC.getValue() == false && ConcealedOptions.UseRememberedSet.getValue() != false;
    }

    public static boolean areMethodHandlesSupported() {
        return JavaVersionUtil.JAVA_SPEC >= 11;
    }

    static {
        debugInfoValueUpdateHandler = SubstrateOptions::defaultDebugInfoValueUpdateHandler;
        PrintFlags = new OptionKey(null);
        PrintFlagsWithExtraHelp = new OptionKey(null);
        Optimize = new HostedOptionKey<Integer>(Integer.valueOf(2)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Integer oldValue, Integer newValue) {
                IncludeNodeSourcePositions.update(values, newValue < 1);
                AOTInline.update(values, newValue > 0);
                AOTTrivialInline.update(values, newValue > 0);
                if (optimizeValueUpdateHandler != null) {
                    optimizeValueUpdateHandler.onValueUpdate(values, oldValue, newValue);
                }
            }
        };
        IncludeNodeSourcePositions = new HostedOptionKey<Boolean>(false);
        CLibraryPath = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        LinkerRPath = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        Path = new HostedOptionKey<Object>(null);
        UseSerialGC = new HostedOptionKey<Boolean>(true);
        UseEpsilonGC = new HostedOptionKey<Boolean>(false);
        StackSize = new RuntimeOptionKey<Long>(Long.valueOf(0L)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
                if (!SubstrateUtil.HOSTED) {
                    XOptions.getXss().setValue(newValue);
                }
            }
        };
        MaxJavaStackTraceDepth = new RuntimeOptionKey<Integer>(1024);
        MaxDirectMemorySize = new RuntimeOptionKey<Long>(0L);
        VerifyNamingConventions = new HostedOptionKey<Boolean>(false);
        MultiThreaded = new HostedOptionKey<Boolean>(true);
        ForceNoROSectionRelocations = new HostedOptionKey<Boolean>(false);
        SpawnIsolates = new HostedOptionKey<Boolean>(null){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (!values.containsKey((Object)this)) {
                    return !SubstrateOptions.useLLVMBackend();
                }
                return (Boolean)values.get((Object)this);
            }

            public Boolean getValue(OptionValues values) {
                assert (this.checkDescriptorExists());
                return this.getValueOrDefault(values.getMap());
            }
        };
        TraceVMOperations = new HostedOptionKey<Boolean>(false);
        TraceClassInitialization = new HostedOptionKey<String>("");
        TraceObjectInstantiation = new HostedOptionKey<String>("");
        TraceNativeToolUsage = new HostedOptionKey<Boolean>(false);
        EntryPointNamePrefix = new HostedOptionKey<String>("");
        APIFunctionPrefix = new HostedOptionKey<String>("graal_");
        EnableURLProtocols = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        EnableAllSecurityServices = new HostedOptionKey<Boolean>(false);
        JNI = new HostedOptionKey<Boolean>(true);
        JNIVerboseLookupErrors = new HostedOptionKey<Boolean>(false);
        JNIExportSymbols = new HostedOptionKey<Boolean>(true);
        CodeAlignment = new HostedOptionKey<Integer>(16);
        AllocatePrefetchLines = new HostedOptionKey<Integer>(3);
        AllocateInstancePrefetchLines = new HostedOptionKey<Integer>(1);
        AllocatePrefetchStyle = new HostedOptionKey<Integer>(1);
        AllocatePrefetchInstr = new HostedOptionKey<Integer>(0);
        TearDownWarningNanos = new RuntimeOptionKey<Long>(0L);
        TearDownFailureNanos = new RuntimeOptionKey<Long>(0L);
        AllocatePrefetchDistance = new HostedOptionKey<Integer>(256);
        AllocatePrefetchStepSize = new HostedOptionKey<Integer>(16);
        MaxUnrolledObjectZeroingStores = new HostedOptionKey<Integer>(8);
        StackTrace = new HostedOptionKey<Boolean>(true);
        ParseRuntimeOptions = new HostedOptionKey<Boolean>(true);
        EnableWildcardExpansion = new HostedOptionKey<Boolean>(true);
        AOTInline = new HostedOptionKey<Boolean>(true);
        AOTTrivialInline = new HostedOptionKey<Boolean>(true);
        NeverInline = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        MaxNodesInTrivialMethod = new HostedOptionKey<Integer>(20);
        MaxInvokesInTrivialMethod = new HostedOptionKey<Integer>(1);
        MaxNodesInTrivialLeafMethod = new HostedOptionKey<Integer>(40);
        PreserveFramePointer = new HostedOptionKey<Boolean>(false);
        UseCalleeSavedRegisters = new HostedOptionKey<Boolean>(true);
        ReportAnalysisForbiddenType = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        CompilerBackend = new HostedOptionKey<String>("lir"){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
                if ("llvm".equals(newValue)) {
                    if (JavaVersionUtil.JAVA_SPEC >= 9) {
                        GraalOptions.EmitStringSubstitutions.update(values, (Object)false);
                    }
                    RemoveUnusedSymbols.update(values, false);
                    InternalSymbolsAreGlobal.update(values, true);
                    SpectrePHTMitigations.Options.SpectrePHTBarriers.update(values, (Object)SpectrePHTMitigations.None);
                }
            }
        };
        UseDedicatedVMOperationThread = new HostedOptionKey<Boolean>(false);
        RemoveUnusedSymbols = new HostedOptionKey<Boolean>(OS.getCurrent() != OS.DARWIN);
        DeleteLocalSymbols = new HostedOptionKey<Boolean>(true);
        InternalSymbolsAreGlobal = new HostedOptionKey<Boolean>(false);
        ImageSymbolsPrefix = new HostedOptionKey<String>("");
        FoldSecurityManagerGetter = new HostedOptionKey<Boolean>(true);
        CCompilerPath = new HostedOptionKey<Object>(null);
        CCompilerOption = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        StrictQueryCodeCompilation = new HostedOptionKey<Boolean>(true);
        DumpTargetInfo = new HostedOptionKey<Boolean>(false);
        CheckToolchain = new HostedOptionKey<Boolean>(true);
        InstallExitHandlers = new HostedOptionKey<Boolean>(false);
        DetectUserDirectoriesInImageHeap = new HostedOptionKey<Boolean>(false);
        DeadlockWatchdogInterval = new HostedOptionKey<Integer>(10);
        DeadlockWatchdogExitOnTimeout = new HostedOptionKey<Boolean>(true);
        UseReferenceHandlerThread = new HostedOptionKey<Boolean>(false);
        GenerateDebugInfo = new HostedOptionKey<Integer>(Integer.valueOf(0)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Integer oldValue, Integer newValue) {
                debugInfoValueUpdateHandler.onValueUpdate(values, oldValue, newValue);
            }
        };
        DebugInfoSourceSearchPath = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        DebugInfoSourceCacheRoot = new HostedOptionKey<String>("sources");
        OmitInlinedMethodDebugLineInfo = new HostedOptionKey<Boolean>(true);
        CompilationIsolateAddressSpaceSize = new RuntimeOptionKey<Long>(0L);
        ActiveProcessorCount = new RuntimeOptionKey<Integer>(-1);
        DisableTypeIdResultVerification = new HostedOptionKey<Boolean>(true);
        EnableSignalAPI = new HostedOptionKey<Boolean>(null){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (values.containsKey((Object)this)) {
                    return (Boolean)values.get((Object)this);
                }
                return (Boolean)SharedLibrary.getValueOrDefault(values) == false;
            }

            public Boolean getValue(OptionValues values) {
                return this.getValueOrDefault(values.getMap());
            }
        };
        FlightRecorder = new RuntimeOptionKey<Boolean>(false);
        StartFlightRecording = new RuntimeOptionKey<String>("");
        FlightRecorderLogging = new RuntimeOptionKey<String>("all=warning");
    }

    public static class ConcealedOptions {
        @Option(help={"Support runtime compilation in separate isolates (enable at runtime with option CompileInIsolates)."})
        public static final HostedOptionKey<Boolean> SupportCompileInIsolates = new HostedOptionKey<Boolean>(null){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (!values.containsKey((Object)this)) {
                    return (Boolean)SpawnIsolates.getValueOrDefault(values);
                }
                return (Boolean)super.getValueOrDefault(values);
            }

            public Boolean getValue(OptionValues values) {
                return this.getValueOrDefault(values.getMap());
            }
        };
        @Option(help={"Activate runtime compilation in separate isolates (enable support during image build with option SupportCompileInIsolates)."})
        public static final RuntimeOptionKey<Boolean> CompileInIsolates = new RuntimeOptionKey<Boolean>(true);
        @Option(help={"Determines if a remembered sets is used, which is necessary for collecting the young and old generation independently."}, type=OptionType.Expert)
        public static final HostedOptionKey<Boolean> UseRememberedSet = new HostedOptionKey<Boolean>(true);
    }

    public static final class GCGroup
    implements APIOptionGroup {
        @Override
        public String name() {
            return "gc";
        }

        @Override
        public String helpText() {
            return "Select native-image garbage collector implementation.";
        }
    }

    public static interface ValueUpdateHandler {
        public void onValueUpdate(EconomicMap<OptionKey<?>, Object> var1, Integer var2, Integer var3);
    }
}

