/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import java.util.Arrays;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class IsolateListenerSupport {
    private IsolateListener[] listeners = new IsolateListener[0];

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public IsolateListenerSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public synchronized void register(IsolateListener listener) {
        assert (listener != null);
        int oldLength = this.listeners.length;
        this.listeners = Arrays.copyOf(this.listeners, oldLength + 1);
        this.listeners[oldLength] = listener;
    }

    @Fold
    public static IsolateListenerSupport singleton() {
        return (IsolateListenerSupport)ImageSingletons.lookup(IsolateListenerSupport.class);
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    public void afterCreateIsolate(Isolate isolate) {
        if (ImageSingletons.contains(CEntryPointSnippets.IsolateCreationWatcher.class)) {
            CEntryPointSnippets.IsolateCreationWatcher singletonWatcher = (CEntryPointSnippets.IsolateCreationWatcher)ImageSingletons.lookup(CEntryPointSnippets.IsolateCreationWatcher.class);
            singletonWatcher.registerIsolate(isolate);
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].afterCreateIsolate(isolate);
        }
    }

    public static interface IsolateListener {
        @Uninterruptible(reason="Thread state not yet set up.")
        public void afterCreateIsolate(Isolate var1);
    }
}

