/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.serialize.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.SerializationConfigurationParser;
import com.oracle.svm.core.jdk.RecordSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.json.JSONParserException;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import com.oracle.svm.reflect.serialize.hosted.SerializationBuilder;
import com.oracle.svm.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
public class SerializationFeature
implements Feature {
    private int loadedConfigurations;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(ReflectionFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        SerializationBuilder serializationBuilder = new SerializationBuilder(access);
        HashMap deniedClasses = new HashMap();
        SerializationConfigurationParser denyCollectorParser = new SerializationConfigurationParser((strTargetSerializationClass, strCustomTargetConstructorClass) -> {
            Class<?> serializationTargetClass = SerializationFeature.resolveClass(strTargetSerializationClass, access);
            if (serializationTargetClass != null) {
                deniedClasses.put(serializationTargetClass, true);
            }
        });
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        ConfigurationParserUtils.parseAndRegisterConfigurations(denyCollectorParser, imageClassLoader, "serialization", ConfigurationFiles.Options.SerializationDenyConfigurationFiles, ConfigurationFiles.Options.SerializationDenyConfigurationResources, "serialization-deny-config.json");
        SerializationConfigurationParser.SerializationParserFunction serializationAdapter = (strTargetSerializationClass, strCustomTargetConstructorClass) -> {
            Class<?> serializationTargetClass = SerializationFeature.resolveClass(strTargetSerializationClass, access);
            UserError.guarantee(serializationTargetClass != null, "Cannot find serialization target class %s. The missing of this class can't be ignored even if -H:+AllowIncompleteClasspath is set. Please make sure it is in the classpath", strTargetSerializationClass);
            if (Serializable.class.isAssignableFrom(serializationTargetClass)) {
                if (deniedClasses.containsKey(serializationTargetClass)) {
                    if (((Boolean)deniedClasses.get(serializationTargetClass)).booleanValue()) {
                        deniedClasses.put(serializationTargetClass, false);
                        SerializationFeature.println("Warning: Serialization deny list contains " + serializationTargetClass.getName() + ". Image will not support serialization/deserialization of this class.");
                    }
                } else {
                    Class<?> customTargetConstructorClass = null;
                    if (strCustomTargetConstructorClass != null) {
                        customTargetConstructorClass = SerializationFeature.resolveClass(strCustomTargetConstructorClass, access);
                        UserError.guarantee(customTargetConstructorClass != null, "Cannot find customTargetConstructorClass %s that was specified in the serialization configuration. The missing of this class can't be ignored even if -H:+AllowIncompleteClasspath is set. Please make sure it is in the classpath", strCustomTargetConstructorClass);
                        UserError.guarantee(customTargetConstructorClass.isAssignableFrom(serializationTargetClass), "The given customTargetConstructorClass %s that was specified in the serialization configuration is not a subclass of the serialization target class %s.", strCustomTargetConstructorClass, strTargetSerializationClass);
                    }
                    Class<?> targetConstructor = serializationBuilder.addConstructorAccessor(serializationTargetClass, customTargetConstructorClass);
                    SerializationFeature.addReflections(serializationTargetClass, targetConstructor);
                }
            }
        };
        SerializationConfigurationParser parser = new SerializationConfigurationParser(serializationAdapter);
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, imageClassLoader, "serialization", ConfigurationFiles.Options.SerializationConfigurationFiles, ConfigurationFiles.Options.SerializationConfigurationResources, "serialization-config.json");
    }

    public static void addReflections(Class<?> serializationTargetClass, Class<?> targetConstructorClass) {
        RecordSupport recordSupport;
        if (targetConstructorClass != null) {
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupConstructor(targetConstructorClass, (Class[])new Class[0])});
        }
        if (Externalizable.class.isAssignableFrom(serializationTargetClass)) {
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupConstructor(serializationTargetClass, (Class[])null)});
        }
        if ((recordSupport = RecordSupport.singleton()).isRecord(serializationTargetClass)) {
            RuntimeReflection.register((Executable[])new Executable[]{recordSupport.getCanonicalRecordConstructor(serializationTargetClass)});
            RuntimeReflection.register((Executable[])recordSupport.getRecordComponentAccessorMethods(serializationTargetClass));
        }
        RuntimeReflection.register((Class[])new Class[]{serializationTargetClass});
        RuntimeReflection.register((Executable[])serializationTargetClass.getDeclaredConstructors());
        SerializationFeature.registerMethods(serializationTargetClass);
        SerializationFeature.registerFields(serializationTargetClass);
    }

    private static void registerMethods(Class<?> serializationTargetClass) {
        RuntimeReflection.register((Executable[])serializationTargetClass.getDeclaredMethods());
        Method computeDefaultSUID = ReflectionUtil.lookupMethod(ObjectStreamClass.class, (String)"computeDefaultSUID", (Class[])new Class[]{Class.class});
        RuntimeReflection.register((Executable[])new Executable[]{computeDefaultSUID});
    }

    private static void registerFields(Class<?> serializationTargetClass) {
        for (Field f : serializationTargetClass.getDeclaredFields()) {
            int modifiers = f.getModifiers();
            boolean allowWrite = false;
            boolean allowUnsafeAccess = false;
            int staticFinalMask = 24;
            if ((modifiers & staticFinalMask) != staticFinalMask) {
                allowUnsafeAccess = !Modifier.isStatic(f.getModifiers());
            }
            RuntimeReflection.register((boolean)allowWrite, (boolean)allowUnsafeAccess, (Field[])new Field[]{f});
        }
    }

    private static Class<?> resolveClass(String typeName, Feature.FeatureAccess a) {
        Class ret;
        String name = typeName;
        if (name.indexOf(91) != -1) {
            name = MetaUtil.internalNameToJava((String)MetaUtil.toInternalName((String)name), (boolean)true, (boolean)true);
        }
        if ((ret = a.findClassByName(name)) == null) {
            SerializationFeature.handleError("Could not resolve " + name + " for serialization configuration.");
        }
        return ret;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest serializationFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).serializationFallback;
        if (serializationFallback != null && this.loadedConfigurations == 0) {
            throw serializationFallback;
        }
    }

    private static void handleError(String message) {
        boolean allowIncompleteClasspath = NativeImageOptions.AllowIncompleteClasspath.getValue();
        if (!allowIncompleteClasspath) {
            throw new JSONParserException(message + " To allow unresolvable reflection configuration, use option -H:+AllowIncompleteClasspath");
        }
        SerializationFeature.println("WARNING: " + message);
    }

    static void println(String str) {
        System.out.println(str);
    }
}

