/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class CCLinkerInvocation
implements LinkerInvocation {
    protected final List<String> additionalPreOptions = new ArrayList<String>();
    protected final List<String> nativeLinkerOptions = new ArrayList<String>();
    protected final List<Path> inputFilenames = new ArrayList<Path>();
    protected final List<String> rpaths = new ArrayList<String>();
    protected final List<String> libpaths = new ArrayList<String>();
    protected final List<String> libs = new ArrayList<String>();
    protected Path tempDirectory;
    protected Path outputFile;

    @Override
    public List<Path> getInputFiles() {
        return Collections.unmodifiableList(this.inputFilenames);
    }

    @Override
    public void addInputFile(Path filename) {
        this.inputFilenames.add(filename);
    }

    @Override
    public void addInputFile(int index, Path filename) {
        this.inputFilenames.add(index, filename);
    }

    @Override
    public List<String> getLibPaths() {
        return Collections.unmodifiableList(this.libpaths);
    }

    @Override
    public void addLibPath(String libPath) {
        this.addLibPath(this.libpaths.size(), libPath);
    }

    @Override
    public void addLibPath(int index, String libPath) {
        if (!libPath.isEmpty()) {
            this.libpaths.add(index, libPath);
        }
    }

    @Override
    public List<String> getRPaths() {
        return Collections.unmodifiableList(this.rpaths);
    }

    @Override
    public void addRPath(String rPath) {
        this.addRPath(this.rpaths.size(), rPath);
    }

    @Override
    public void addRPath(int index, String rPath) {
        if (!rPath.isEmpty()) {
            this.rpaths.add(rPath);
        }
    }

    @Override
    public Path getOutputFile() {
        return this.outputFile;
    }

    @Override
    public void setOutputFile(Path out) {
        this.outputFile = out;
    }

    public void setTempDirectory(Path tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    @Override
    public Path getTempDirectory() {
        return this.tempDirectory;
    }

    @Override
    public List<String> getLinkedLibraries() {
        return Collections.unmodifiableList(this.libs);
    }

    @Override
    public void addLinkedLibrary(String libname) {
        this.libs.add(libname);
    }

    @Override
    public void addLinkedLibrary(int index, String libname) {
        this.libs.add(index, libname);
    }

    protected List<String> getCompilerCommand(List<String> options) {
        Path[] inputPaths = (Path[])this.inputFilenames.stream().map(path -> path.startsWith(this.tempDirectory) ? this.tempDirectory.relativize((Path)path) : path).toArray(Path[]::new);
        return ((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).createCompilerCommand(options, this.outputFile, inputPaths);
    }

    protected abstract void setOutputKind(List<String> var1);

    @Override
    public List<String> getCommand() {
        List<String> compilerCmd = this.getCompilerCommand(this.additionalPreOptions);
        ArrayList<String> cmd = new ArrayList<String>(compilerCmd);
        this.setOutputKind(cmd);
        cmd.add("-v");
        for (String libpath : this.libpaths) {
            cmd.add("-L" + libpath);
        }
        for (String rpath : this.rpaths) {
            cmd.add("-Wl,-rpath");
            cmd.add("-Wl," + rpath);
        }
        cmd.addAll(this.getLibrariesCommand());
        cmd.addAll(this.getNativeLinkerOptions());
        return cmd;
    }

    protected List<String> getLibrariesCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        for (String lib : this.libs) {
            if (lib.startsWith("-")) {
                cmd.add("-Wl," + lib.replace(" ", ","));
                continue;
            }
            cmd.add("-l" + lib);
        }
        return cmd;
    }

    @Override
    public void addAdditionalPreOption(String option) {
        this.additionalPreOptions.add(option);
    }

    @Override
    public void addNativeLinkerOption(String option) {
        this.nativeLinkerOptions.add(option);
    }

    protected List<String> getNativeLinkerOptions() {
        return Stream.of(this.nativeLinkerOptions, Options.NativeLinkerOption.getValue().values()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static class Options {
        @Option(help={"Pass the provided raw option that will be appended to the linker command to produce the final binary. The possible options are platform specific and passed through without any validation."})
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> NativeLinkerOption = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
    }
}

