/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.hosted.code.CompilationInfoSupport;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;

public class CompilationInfo {
    protected final HostedMethod method;
    protected final AtomicBoolean inParseQueue = new AtomicBoolean(false);
    protected volatile StructuredGraph graph;
    protected boolean isTrivialMethod;
    protected boolean canDeoptForTesting;
    protected ConstantNode[] specializedArguments;
    protected HostedMethod deoptTarget;
    protected HostedMethod deoptOrigin;
    protected CompileQueue.ParseFunction customParseFunction;
    protected CompileQueue.CompileFunction customCompileFunction;
    protected long numNodesBeforeCompilation;
    protected long numNodesAfterCompilation;
    protected long numDeoptEntryPoints;
    protected long numDuringCallEntryPoints;

    public CompilationInfo(HostedMethod method) {
        this.method = method;
    }

    public boolean isDeoptTarget() {
        return this.deoptOrigin != null;
    }

    public boolean isDeoptEntry(int bci, boolean duringCall, boolean rethrowException) {
        return this.isDeoptTarget() && (this.deoptOrigin.compilationInfo.canDeoptForTesting || CompilationInfoSupport.singleton().isDeoptEntry(this.method, bci, duringCall, rethrowException));
    }

    public boolean isRegisteredDeoptEntry(int bci, boolean duringCall, boolean rethrowException) {
        return this.isDeoptTarget() && CompilationInfoSupport.singleton().isDeoptTarget(this.method) && CompilationInfoSupport.singleton().isDeoptEntry(this.method, bci, duringCall, rethrowException);
    }

    public boolean canDeoptForTesting() {
        return this.canDeoptForTesting;
    }

    public HostedMethod getDeoptTargetMethod() {
        return this.deoptTarget;
    }

    public void setDeoptTarget(HostedMethod deoptTarget) {
        assert (this.deoptTarget == null);
        this.deoptTarget = deoptTarget;
        deoptTarget.compilationInfo.deoptOrigin = this.method;
    }

    public void setGraph(StructuredGraph graph) {
        this.graph = graph;
    }

    public void clear() {
        this.graph = null;
        this.specializedArguments = null;
    }

    public StructuredGraph getGraph() {
        return this.graph;
    }

    public boolean isTrivialMethod() {
        return this.isTrivialMethod;
    }

    public void setTrivialMethod(boolean trivial) {
        this.isTrivialMethod = trivial;
    }

    public void setCustomParseFunction(CompileQueue.ParseFunction parseFunction) {
        this.customParseFunction = parseFunction;
    }

    public CompileQueue.ParseFunction getCustomParseFunction() {
        return this.customParseFunction;
    }

    public void setCustomCompileFunction(CompileQueue.CompileFunction compileFunction) {
        this.customCompileFunction = compileFunction;
    }

    public CompileQueue.CompileFunction getCustomCompileFunction() {
        return this.customCompileFunction;
    }

    public boolean hasDefaultParseFunction() {
        return this.customCompileFunction == null;
    }
}

