/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableOption;
import com.oracle.svm.core.option.MultiOptionValue;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.VMError;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateOptionsParser {
    public static final String HOSTED_OPTION_PREFIX = "-H:";
    public static final String RUNTIME_OPTION_PREFIX = "-R:";
    public static final int PRINT_OPTION_INDENTATION = 2;
    public static final int PRINT_OPTION_WIDTH = 45;
    public static final int PRINT_OPTION_WRAP_WIDTH = 120;

    static OptionParseResult parseOption(EconomicMap<String, OptionDescriptor> options, Predicate<OptionKey<?>> isHosted, String option, EconomicMap<OptionKey<?>, Object> valuesMap, String optionPrefix, BooleanOptionFormat booleanOptionFormat) {
        boolean hostedOption;
        OptionKey optionKey;
        LocatableOption current;
        String optionName;
        Object value;
        block28: {
            Class<?> optionType;
            if (option.length() == 0) {
                return OptionParseResult.error("Option name must be specified");
            }
            value = null;
            String valueString = null;
            char first = option.charAt(0);
            int eqIndex = option.indexOf(61);
            if (first == '+' || first == '-') {
                if (eqIndex != -1) {
                    return OptionParseResult.error("Cannot mix +/- with <name>=<value> format: '" + optionPrefix + option + "'");
                }
                optionName = option.substring(1);
                if (booleanOptionFormat == BooleanOptionFormat.NAME_VALUE) {
                    return OptionParseResult.error("Option " + LocatableOption.from(optionName) + " must use <name>=<value> format, not +/- prefix");
                }
                value = first == '+';
            } else if (eqIndex == -1) {
                optionName = option;
                valueString = null;
            } else {
                optionName = option.substring(0, eqIndex);
                valueString = option.substring(eqIndex + 1);
            }
            current = LocatableOption.from(optionName);
            OptionDescriptor desc = (OptionDescriptor)options.get((Object)current.name);
            if (desc == null && value != null && eqIndex != -1) {
                optionName = option.substring(1, eqIndex);
                current = LocatableOption.from(optionName);
                desc = (OptionDescriptor)options.get((Object)current.name);
            }
            optionName = current.name;
            if (desc == null) {
                ArrayList matches = new ArrayList();
                OptionsParser.collectFuzzyMatches((Iterable)options.getValues(), (String)optionName, matches);
                StringBuilder msg = new StringBuilder("Could not find option ").append(current);
                if (!matches.isEmpty()) {
                    msg.append(". Did you mean one of these:");
                    for (OptionDescriptor match : matches) {
                        msg.append(' ').append(match.getName());
                    }
                }
                msg.append(". Use ").append(optionPrefix).append(SubstrateOptions.PrintFlags.getName()).append("= to list all available options.");
                return OptionParseResult.error(msg.toString());
            }
            optionKey = desc.getOptionKey();
            hostedOption = isHosted.test(optionKey);
            Class<?> optionValueType = SubstrateOptionsParser.getMultiOptionValueElementType(optionKey);
            Class<?> clazz = optionType = hostedOption && optionValueType != null ? optionValueType : desc.getOptionValueType();
            if (value == null) {
                if (optionType == Boolean.class && booleanOptionFormat == BooleanOptionFormat.PLUS_MINUS) {
                    return OptionParseResult.error("Boolean option " + current + " must have +/- prefix");
                }
                if (valueString == null) {
                    return OptionParseResult.error("Missing value for option " + current);
                }
                try {
                    value = SubstrateOptionsParser.parseValue(optionType, current, valueString);
                    if (value instanceof OptionParseResult) {
                        return (OptionParseResult)value;
                    }
                    break block28;
                }
                catch (NumberFormatException ex) {
                    return OptionParseResult.error("Invalid value for option " + current + ": '" + valueString + "' is not a valid number");
                }
            }
            if (optionType != Boolean.class) {
                return OptionParseResult.error("Non-boolean option " + current + " can not use +/- prefix. Use '" + current.name + "=<value>' format");
            }
        }
        optionKey.update(valuesMap, hostedOption ? LocatableOption.value(value, current.origin) : value);
        if (SubstrateOptions.PrintFlags.getName().equals(optionName)) {
            EnumSet<OptionType> selectedOptionTypes;
            String optionValue = (String)value;
            if (optionValue.isEmpty()) {
                selectedOptionTypes = EnumSet.allOf(OptionType.class);
            } else {
                selectedOptionTypes = EnumSet.noneOf(OptionType.class);
                String enumString = null;
                try {
                    String[] enumStrings;
                    String[] stringArray = enumStrings = SubstrateUtil.split(optionValue, ",");
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String string;
                        enumString = string = stringArray[i];
                        selectedOptionTypes.add(OptionType.valueOf((String)enumString));
                    }
                }
                catch (IllegalArgumentException e) {
                    StringBuilder sb = new StringBuilder();
                    boolean firstValue = true;
                    for (OptionType ot : OptionType.values()) {
                        if (firstValue) {
                            firstValue = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(ot.name());
                    }
                    String possibleValues = sb.toString();
                    return OptionParseResult.error("Invalid value for option " + current + ". '" + enumString + "' is not one of: " + possibleValues);
                }
            }
            return OptionParseResult.printFlags(selectedOptionTypes);
        }
        if (SubstrateOptions.PrintFlagsWithExtraHelp.getName().equals(optionName)) {
            String optionValue = (String)value;
            String[] optionNames = SubstrateUtil.split(optionValue, ",");
            HashSet<String> selectedOptionNames = new HashSet<String>(Arrays.asList(optionNames));
            return OptionParseResult.printFlagsWithExtraHelp(selectedOptionNames);
        }
        return OptionParseResult.correct();
    }

    private static Class<?> getMultiOptionValueElementType(OptionKey<?> optionKey) {
        Object defaultValue = optionKey.getDefaultValue();
        if (defaultValue instanceof MultiOptionValue) {
            return ((MultiOptionValue)defaultValue).getValueType();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object parseValue(Class<?> optionType, LocatableOption option, String valueString) throws NumberFormatException {
        if (optionType == Integer.class) {
            long longValue = SubstrateOptionsParser.parseLong(valueString);
            if ((long)((int)longValue) == longValue) return (int)longValue;
            return OptionParseResult.error("Wrong value for option " + option + ": '" + valueString + "' is not a valid number");
        }
        if (optionType == Long.class) {
            return SubstrateOptionsParser.parseLong(valueString);
        }
        if (optionType == String.class) {
            return valueString;
        }
        if (optionType == Double.class) {
            return SubstrateOptionsParser.parseDouble(valueString);
        }
        if (optionType == Boolean.class) {
            if (valueString.equals("true")) {
                return true;
            }
            if (!valueString.equals("false")) return OptionParseResult.error("Boolean option " + option + " must have value 'true' or 'false'");
            return false;
        }
        if (!optionType.isEnum()) throw VMError.shouldNotReachHere(option + " uses unsupported option value class: " + optionType.getSimpleName());
        return Enum.valueOf(optionType.asSubclass(Enum.class), valueString);
    }

    public static boolean parseHostedOption(String optionPrefix, EconomicMap<String, OptionDescriptor> options, EconomicMap<OptionKey<?>, Object> valuesMap, BooleanOptionFormat booleanOptionFormat, Set<String> errors, String arg, PrintStream out) {
        OptionParseResult optionParseResult;
        block6: {
            block5: {
                if (!arg.startsWith(optionPrefix)) {
                    return false;
                }
                Predicate<OptionKey<?>> isHosted = optionKey -> optionKey instanceof HostedOptionKey;
                optionParseResult = SubstrateOptionsParser.parseOption(options, isHosted, arg.substring(optionPrefix.length()), valuesMap, optionPrefix, booleanOptionFormat);
                if (optionParseResult.printFlags()) break block5;
                if (!optionParseResult.printFlagsWithExtraHelp()) break block6;
            }
            SubstrateOptionsParser.printFlags(optionParseResult::matchesFlagsHosted, options, optionPrefix, out, optionParseResult.printFlagsWithExtraHelp());
            throw new InterruptImageBuilding("");
        }
        if (!optionParseResult.isValid()) {
            errors.add(optionParseResult.getError());
        }
        return true;
    }

    private static String spaces(int length) {
        return new String(new char[length]).replace('\u0000', ' ');
    }

    private static String wrap(String s, int width) {
        StringBuilder sb = new StringBuilder(s);
        int cursor = 0;
        while (cursor + width < sb.length()) {
            int i = sb.lastIndexOf(" ", cursor + width);
            if (i == -1 || i < cursor) {
                i = sb.indexOf(" ", cursor + width);
            }
            if (i == -1) break;
            sb.replace(i, i + 1, System.lineSeparator());
            cursor = i;
        }
        return sb.toString();
    }

    private static void printOption(PrintStream out, String option, String description, int wrap) {
        SubstrateOptionsParser.printOption(out::println, option, description, 2, 45, wrap);
    }

    public static void printOption(Consumer<String> println, String option, String description, int indentation, int optionWidth, int wrapWidth) {
        String indent = SubstrateOptionsParser.spaces(indentation);
        String desc = description != null ? description : "";
        desc = wrapWidth > 0 ? SubstrateOptionsParser.wrap(desc, wrapWidth) : desc;
        String nl = System.lineSeparator();
        String[] descLines = SubstrateUtil.split(desc, nl);
        if (option.length() >= optionWidth && description != null) {
            println.accept(indent + option + nl + indent + SubstrateOptionsParser.spaces(optionWidth) + descLines[0]);
        } else {
            println.accept(indent + option + SubstrateOptionsParser.spaces(optionWidth - option.length()) + descLines[0]);
        }
        for (int i = 1; i < descLines.length; ++i) {
            println.accept(indent + SubstrateOptionsParser.spaces(optionWidth) + descLines[i]);
        }
    }

    static void printFlags(Predicate<OptionDescriptor> filter, EconomicMap<String, OptionDescriptor> options, String prefix, PrintStream out, boolean verbose) {
        ArrayList<OptionDescriptor> sortedDescriptors = new ArrayList<OptionDescriptor>();
        for (OptionDescriptor option : options.getValues()) {
            if (!filter.test(option)) continue;
            sortedDescriptors.add(option);
        }
        sortedDescriptors.sort(Comparator.comparing(OptionDescriptor::getName));
        for (OptionDescriptor descriptor : sortedDescriptors) {
            int wrapWidth;
            String helpMsg = verbose && !descriptor.getExtraHelp().isEmpty() ? "" : descriptor.getHelp();
            int helpLen = helpMsg.length();
            if (helpLen > 0 && helpMsg.charAt(helpLen - 1) != '.') {
                helpMsg = helpMsg + '.';
            }
            boolean stringifiedArrayValue = false;
            Object defaultValue = descriptor.getOptionKey().getDefaultValue();
            if (defaultValue != null && defaultValue.getClass().isArray()) {
                Object[] defaultValues = (Object[])defaultValue;
                if (defaultValues.length == 1) {
                    defaultValue = defaultValues[0];
                } else {
                    ArrayList<String> stringList = new ArrayList<String>();
                    String optionPrefix = prefix + descriptor.getName() + "=";
                    for (Object rawValue : defaultValues) {
                        String value = rawValue instanceof String ? '\"' + String.valueOf(rawValue) + '\"' : String.valueOf(rawValue);
                        stringList.add(optionPrefix + value);
                    }
                    if (helpLen != 0) {
                        helpMsg = helpMsg + ' ';
                    }
                    helpMsg = helpMsg + "Default: ";
                    helpMsg = stringList.isEmpty() ? helpMsg + "None" : helpMsg + String.join((CharSequence)" ", stringList);
                    stringifiedArrayValue = true;
                }
            }
            String verboseHelp = "";
            if (verbose) {
                verboseHelp = System.lineSeparator() + descriptor.getHelp() + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), descriptor.getExtraHelp());
            } else if (!descriptor.getExtraHelp().isEmpty()) {
                verboseHelp = " [Extra help available]";
            }
            int n = wrapWidth = verbose ? 0 : 120;
            if (descriptor.getOptionValueType() == Boolean.class) {
                Boolean val = (Boolean)defaultValue;
                if (helpLen != 0) {
                    helpMsg = helpMsg + ' ';
                }
                if (val != null) {
                    helpMsg = val != false ? helpMsg + "Default: + (enabled)." : helpMsg + "Default: - (disabled).";
                }
                SubstrateOptionsParser.printOption(out, prefix + "\u00b1" + descriptor.getName(), helpMsg + verboseHelp, wrapWidth);
                continue;
            }
            if (defaultValue == null) {
                if (helpLen != 0) {
                    helpMsg = helpMsg + ' ';
                }
                helpMsg = helpMsg + "Default: None";
            }
            helpMsg = helpMsg + verboseHelp;
            if (stringifiedArrayValue || defaultValue == null) {
                SubstrateOptionsParser.printOption(out, prefix + descriptor.getName() + "=...", helpMsg, wrapWidth);
                continue;
            }
            if (defaultValue instanceof String) {
                defaultValue = '\"' + String.valueOf(defaultValue) + '\"';
            }
            SubstrateOptionsParser.printOption(out, prefix + descriptor.getName() + "=" + defaultValue, helpMsg, wrapWidth);
        }
    }

    public static long parseLong(String v) {
        String valueString = v.trim().toLowerCase();
        long scale = 1L;
        if (valueString.endsWith("k")) {
            scale = 1024L;
        } else if (valueString.endsWith("m")) {
            scale = 0x100000L;
        } else if (valueString.endsWith("g")) {
            scale = 0x40000000L;
        } else if (valueString.endsWith("t")) {
            scale = 0x10000000000L;
        }
        if (scale != 1L) {
            valueString = valueString.substring(0, valueString.length() - 1);
        }
        return Long.parseLong(valueString) * scale;
    }

    public static double parseDouble(String v) {
        String valueString = v.trim();
        int dotPos = valueString.indexOf(46);
        if (dotPos == -1) {
            return SubstrateOptionsParser.parseLong(valueString);
        }
        String beforeDot = valueString.substring(0, dotPos);
        String afterDot = valueString.substring(dotPos + 1);
        double sign = 1.0;
        if (beforeDot.startsWith("-")) {
            sign = -1.0;
            beforeDot = beforeDot.substring(1);
        } else if (beforeDot.startsWith("+")) {
            beforeDot = beforeDot.substring(1);
        }
        if (beforeDot.startsWith("-") || beforeDot.startsWith("+") || afterDot.startsWith("-") || afterDot.startsWith("+") || beforeDot.length() == 0 && afterDot.length() == 0) {
            throw new NumberFormatException(v);
        }
        double integral = 0.0;
        if (beforeDot.length() > 0) {
            integral = Long.parseLong(beforeDot);
        }
        double fraction = 0.0;
        if (afterDot.length() > 0) {
            fraction = (double)Long.parseLong(afterDot) * Math.pow(10.0, -afterDot.length());
        }
        return sign * (integral + fraction);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String commandArgument(OptionKey<?> option, String value) {
        return SubstrateOptionsParser.commandArgument(option, value, null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String commandArgument(OptionKey<?> option, String value, String apiOptionName) {
        String selected;
        APIOption[] apiOptions;
        Field field;
        try {
            field = option.getDescriptor().getDeclaringClass().getDeclaredField(option.getDescriptor().getFieldName());
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        for (APIOption apiOption : apiOptions = (APIOption[])field.getAnnotationsByType(APIOption.class)) {
            selected = SubstrateOptionsParser.selectVariant(apiOption, apiOptionName);
            assert (selected == null || apiOption.deprecated().equals("")) : "Using the deprecated option in a description: " + apiOption;
        }
        if (option.getDescriptor().getOptionValueType() == Boolean.class) {
            VMError.guarantee(value.equals("+") || value.equals("-"), "Boolean option value can be only + or -");
            for (APIOption apiOption : apiOptions) {
                String apiValue;
                selected = SubstrateOptionsParser.selectVariant(apiOption, apiOptionName);
                if (selected == null) continue;
                String string = apiValue = apiOption.kind() == APIOption.APIOptionKind.Negated ? "-" : "+";
                if (!apiValue.equals(value)) continue;
                return APIOption.Utils.optionName(selected);
            }
            return HOSTED_OPTION_PREFIX + value + option;
        }
        String apiOptionWithValue = null;
        for (APIOption apiOption : apiOptions) {
            String selected2 = SubstrateOptionsParser.selectVariant(apiOption, apiOptionName);
            if (selected2 == null) continue;
            String optionName = APIOption.Utils.optionName(selected2);
            if (apiOption.fixedValue().length == 0) {
                if (apiOptionWithValue != null) continue;
                apiOptionWithValue = optionName + apiOption.valueSeparator() + value;
                continue;
            }
            if (!apiOption.fixedValue()[0].equals(value)) continue;
            return optionName;
        }
        if (apiOptionWithValue != null) {
            return apiOptionWithValue;
        }
        assert (apiOptionName == null) : "invalid API option name " + apiOptionName;
        return HOSTED_OPTION_PREFIX + option.getName() + "=" + value;
    }

    private static String selectVariant(APIOption apiOption, String apiOptionName) {
        VMError.guarantee(apiOption.name().length > 0, "APIOption requires at least one name");
        if (apiOptionName == null) {
            return apiOption.name()[0];
        }
        if (Arrays.asList(apiOption.name()).contains(apiOptionName)) {
            return apiOptionName;
        }
        return null;
    }

    public static enum BooleanOptionFormat {
        NAME_VALUE("<name>=<value>"),
        PLUS_MINUS("+/-<name>");

        private final String help;

        private BooleanOptionFormat(String help) {
            this.help = help;
        }

        public String toString() {
            return this.help;
        }
    }

    static final class OptionParseResult {
        private final EnumSet<OptionType> printFlags;
        private final Set<String> optionNameFilter;
        private final String error;
        private static final String EXTRA_HELP_OPTIONS_WILDCARD = "*";

        private OptionParseResult(EnumSet<OptionType> printFlags, String error, Set<String> optionNameFilter) {
            this.printFlags = printFlags;
            this.error = error;
            this.optionNameFilter = optionNameFilter;
        }

        private OptionParseResult(EnumSet<OptionType> printFlags, String error) {
            this(printFlags, error, new HashSet<String>());
        }

        static OptionParseResult error(String message) {
            return new OptionParseResult(EnumSet.noneOf(OptionType.class), message);
        }

        static OptionParseResult correct() {
            return new OptionParseResult(EnumSet.noneOf(OptionType.class), null);
        }

        static OptionParseResult printFlags(EnumSet<OptionType> selectedOptionTypes) {
            return new OptionParseResult(selectedOptionTypes, null);
        }

        static OptionParseResult printFlagsWithExtraHelp(Set<String> optionNameFilter) {
            Set<String> optionNames = optionNameFilter;
            if (optionNames.contains(EXTRA_HELP_OPTIONS_WILDCARD)) {
                optionNames = new HashSet<String>();
                optionNames.add(EXTRA_HELP_OPTIONS_WILDCARD);
            }
            return new OptionParseResult(EnumSet.noneOf(OptionType.class), null, optionNames);
        }

        boolean printFlags() {
            return !this.printFlags.isEmpty();
        }

        boolean printFlagsWithExtraHelp() {
            return !this.optionNameFilter.isEmpty();
        }

        public boolean isValid() {
            return this.printFlags.isEmpty() && this.optionNameFilter.isEmpty() && this.error == null;
        }

        public String getError() {
            return this.error;
        }

        private boolean matchesFlags(OptionDescriptor d, boolean svmOption) {
            if (!this.printFlags.isEmpty()) {
                boolean showAll = this.printFlags.equals(EnumSet.allOf(OptionType.class));
                return showAll || svmOption && this.printFlags.contains(d.getOptionType());
            }
            if (!this.optionNameFilter.isEmpty()) {
                if (this.optionNameFilter.contains(EXTRA_HELP_OPTIONS_WILDCARD) && !d.getExtraHelp().isEmpty()) {
                    return true;
                }
                return this.optionNameFilter.contains(d.getName());
            }
            return false;
        }

        boolean matchesFlagsRuntime(OptionDescriptor d) {
            return this.matchesFlags(d, d.getOptionKey() instanceof RuntimeOptionKey);
        }

        boolean matchesFlagsHosted(OptionDescriptor d) {
            OptionKey key = d.getOptionKey();
            return this.matchesFlags(d, key instanceof RuntimeOptionKey || key instanceof HostedOptionKey);
        }
    }
}

