/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import com.oracle.svm.core.meta.SharedMethod;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.Phase;

public class RemoveUnwindPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        SharedMethod method = (SharedMethod)graph.method();
        if (method.isDeoptTarget()) {
            return;
        }
        ArrayList<WithExceptionNode> withExceptionNodes = new ArrayList<WithExceptionNode>();
        ArrayList<BytecodeExceptionNode> bytecodeExceptionNodes = new ArrayList<BytecodeExceptionNode>();
        for (UnwindNode unwindNode : graph.getNodes().filter(UnwindNode.class)) {
            RemoveUnwindPhase.walkBack(unwindNode.predecessor(), (Node)unwindNode, withExceptionNodes, bytecodeExceptionNodes);
        }
        for (WithExceptionNode withExceptionNode : withExceptionNodes) {
            if (!withExceptionNode.isAlive()) continue;
            withExceptionNode.replaceWithNonThrowing();
        }
        for (BytecodeExceptionNode bytecodeExceptionNode : bytecodeExceptionNodes) {
            if (!bytecodeExceptionNode.isAlive()) continue;
            RemoveUnwindPhase.convertToThrow(bytecodeExceptionNode);
        }
    }

    protected static void walkBack(Node n, Node successor, List<WithExceptionNode> withExceptionNodes, List<BytecodeExceptionNode> bytecodeExceptionNodes) {
        if (n instanceof WithExceptionNode) {
            WithExceptionNode node = (WithExceptionNode)n;
            if (node.exceptionEdge() == successor) {
                withExceptionNodes.add(node);
            }
        } else if (n instanceof BytecodeExceptionNode) {
            BytecodeExceptionNode node = (BytecodeExceptionNode)n;
            bytecodeExceptionNodes.add(node);
        } else if (n instanceof MergeNode) {
            MergeNode node = (MergeNode)n;
            for (ValueNode predecessor : node.cfgPredecessors()) {
                RemoveUnwindPhase.walkBack((Node)predecessor, (Node)node, withExceptionNodes, bytecodeExceptionNodes);
            }
        } else if (n instanceof AbstractBeginNode || n instanceof AbstractEndNode || n instanceof LoopExitNode || n instanceof ExceptionObjectNode) {
            RemoveUnwindPhase.walkBack(n.predecessor(), n, withExceptionNodes, bytecodeExceptionNodes);
        }
    }

    private static void convertToThrow(BytecodeExceptionNode bytecodeExceptionNode) {
        StructuredGraph graph = bytecodeExceptionNode.graph();
        ThrowBytecodeExceptionNode throwNode = (ThrowBytecodeExceptionNode)graph.add((Node)new ThrowBytecodeExceptionNode(bytecodeExceptionNode.getExceptionKind(), (List<ValueNode>)bytecodeExceptionNode.getArguments()));
        throwNode.setStateBefore(bytecodeExceptionNode.createStateDuring());
        FixedWithNextNode predecessor = (FixedWithNextNode)bytecodeExceptionNode.predecessor();
        GraphUtil.killCFG((FixedNode)bytecodeExceptionNode);
        assert (predecessor.next() == null) : "must be killed now";
        predecessor.setNext((FixedNode)throwNode);
    }
}

