/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import java.util.function.Supplier;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_1)
public final class LazyConstantNode
extends FloatingNode
implements Canonicalizable,
Lowerable {
    public static final NodeClass<LazyConstantNode> TYPE = NodeClass.create(LazyConstantNode.class);
    private final Supplier<JavaConstant> constantSupplier;

    protected LazyConstantNode(Stamp stamp, Supplier<JavaConstant> constantSupplier) {
        super(TYPE, stamp);
        this.constantSupplier = constantSupplier;
    }

    public static ValueNode create(Stamp stamp, Supplier<JavaConstant> constantSupplier, MetaAccessProvider metaAccess) {
        ValueNode result = LazyConstantNode.findSynonym(stamp, constantSupplier, metaAccess);
        if (result != null) {
            return result;
        }
        return new LazyConstantNode(stamp, constantSupplier);
    }

    public Node canonical(CanonicalizerTool tool) {
        ValueNode result = LazyConstantNode.findSynonym(this.stamp, this.constantSupplier, tool.getMetaAccess());
        if (result != null) {
            return result;
        }
        return this;
    }

    private static ValueNode findSynonym(Stamp stamp, Supplier<JavaConstant> constantSupplier, MetaAccessProvider metaAccess) {
        JavaConstant constant = constantSupplier.get();
        if (constant == null) {
            return null;
        }
        ConstantNode constantNode = ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)metaAccess);
        Stamp newStamp = constantNode.stamp(NodeView.DEFAULT);
        GraalError.guarantee((newStamp.join(stamp) == newStamp ? 1 : 0) != 0, (String)"Stamp can only improve");
        return constantNode;
    }

    public void lower(LoweringTool tool) {
        throw GraalError.shouldNotReachHere((String)"Constant value must have been computed before first lowering");
    }
}

