/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class ReferenceObjectProcessing {
    private static Reference<?> rememberedRefsList;
    private static UnsignedWord maxSoftRefAccessIntervalMs;
    private static boolean softReferencesAreWeak;
    private static long initialSoftRefClock;

    private ReferenceObjectProcessing() {
    }

    public static void setSoftReferencesAreWeak(boolean enabled) {
        assert (VMOperation.isGCInProgress());
        softReferencesAreWeak = enabled;
    }

    @AlwaysInline(value="GC performance")
    public static void discoverIfReference(Object object, ObjectReferenceVisitor refVisitor) {
        assert (object != null);
        DynamicHub hub = KnownIntrinsics.readHub(object);
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)hub.isReferenceInstanceClass())) {
            ReferenceObjectProcessing.discover(object, refVisitor);
        }
    }

    private static void discover(Object obj, ObjectReferenceVisitor refVisitor) {
        Reference dr = KnownIntrinsics.convertUnknownValue(obj, Reference.class);
        if (ReferenceInternals.getDiscoveredPointer(dr).isNonNull()) {
            return;
        }
        Pointer referentAddr = ReferenceInternals.getReferentPointer(dr);
        if (referentAddr.isNull()) {
            return;
        }
        if (Heap.getHeap().isInImageHeap(referentAddr)) {
            return;
        }
        if (ReferenceObjectProcessing.maybeUpdateForwardedReference(dr, referentAddr)) {
            return;
        }
        Object refObject = referentAddr.toObject();
        if (ReferenceObjectProcessing.willSurviveThisCollection(refObject)) {
            HeapImpl.getHeapImpl().dirtyCardIfNecessary(dr, refObject);
            return;
        }
        if (!softReferencesAreWeak && dr instanceof SoftReference) {
            UnsignedWord elapsed;
            long clock = ReferenceInternals.getSoftReferenceClock();
            long timestamp = ReferenceInternals.getSoftReferenceTimestamp((SoftReference)dr);
            if (timestamp == 0L) {
                timestamp = initialSoftRefClock;
            }
            if ((elapsed = WordFactory.unsigned((long)(clock - timestamp))).belowThan(maxSoftRefAccessIntervalMs)) {
                refVisitor.visitObjectReference(ReferenceInternals.getReferentFieldAddress(dr), true);
                return;
            }
        }
        Reference next = rememberedRefsList != null ? rememberedRefsList : dr;
        ReferenceInternals.setNextDiscovered(dr, next);
        rememberedRefsList = dr;
    }

    static Reference<?> processRememberedReferences() {
        Reference<?> pendingHead = null;
        Reference<?> current = rememberedRefsList;
        rememberedRefsList = null;
        while (current != null) {
            Reference<?> next = ReferenceInternals.getNextDiscovered(current);
            assert (next != null);
            Reference<Object> reference = next = next != current ? next : null;
            if (!ReferenceObjectProcessing.processRememberedRef(current) && ReferenceInternals.hasQueue(current)) {
                ReferenceInternals.setNextDiscovered(current, pendingHead);
                pendingHead = current;
            } else {
                ReferenceInternals.setNextDiscovered(current, null);
            }
            current = next;
        }
        return pendingHead;
    }

    static void afterCollection(UnsignedWord usedBytes, UnsignedWord maxBytes) {
        assert (rememberedRefsList == null);
        UnsignedWord unusedMbytes = maxBytes.subtract(usedBytes).unsignedDivide(0x100000);
        maxSoftRefAccessIntervalMs = unusedMbytes.multiply(HeapOptions.SoftRefLRUPolicyMSPerMB.getValue().intValue());
        ReferenceInternals.updateSoftReferenceClock();
        if (initialSoftRefClock == 0L) {
            initialSoftRefClock = ReferenceInternals.getSoftReferenceClock();
        }
    }

    private static boolean processRememberedRef(Reference<?> dr) {
        Pointer refPointer = ReferenceInternals.getReferentPointer(dr);
        assert (refPointer.isNonNull()) : "Referent is null: should not have been discovered";
        assert (!HeapImpl.getHeapImpl().isInImageHeap(refPointer)) : "Image heap referent: should not have been discovered";
        if (ReferenceObjectProcessing.maybeUpdateForwardedReference(dr, refPointer)) {
            return true;
        }
        Object refObject = refPointer.toObject();
        if (ReferenceObjectProcessing.willSurviveThisCollection(refObject)) {
            HeapImpl.getHeapImpl().dirtyCardIfNecessary(dr, refObject);
            return true;
        }
        ReferenceInternals.setReferent(dr, null);
        return false;
    }

    private static boolean maybeUpdateForwardedReference(Reference<?> dr, Pointer referentAddr) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointer(referentAddr);
        if (ObjectHeaderImpl.isForwardedHeader(header)) {
            Object forwardedObj = ObjectHeaderImpl.getForwardedObject(referentAddr);
            ReferenceInternals.setReferent(dr, forwardedObj);
            return true;
        }
        return false;
    }

    private static boolean willSurviveThisCollection(Object obj) {
        HeapChunk.Header<?> chunk = HeapChunk.getEnclosingHeapChunk(obj);
        Space space = HeapChunk.getSpace(chunk);
        return !space.isFromSpace();
    }

    public static boolean verify(Reference<?> dr) {
        boolean refOldTo;
        Pointer refPointer = ReferenceInternals.getReferentPointer(dr);
        int refClassification = HeapVerifier.classifyPointer(refPointer);
        if (refClassification < 0) {
            Log witness = Log.log();
            witness.string("[ReferenceObjectProcessing.verify:");
            witness.string("  epoch: ").unsigned((WordBase)HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch());
            witness.string("  refClassification: ").signed(refClassification);
            witness.string("]").newline();
            assert (refClassification >= 0) : "Bad referent.";
            return false;
        }
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        boolean refNull = refPointer.isNull();
        boolean refBootImage = !refNull && heap.isInImageHeapSlow(refPointer);
        boolean refYoung = !refNull && youngGen.slowlyFindPointer(refPointer);
        boolean refOldFrom = !refNull && oldGen.slowlyFindPointerInFromSpace(refPointer);
        boolean bl = refOldTo = !refNull && oldGen.slowlyFindPointerInToSpace(refPointer);
        if (!(refNull || refYoung || refBootImage || refOldFrom)) {
            Log witness = Log.log();
            witness.string("[ReferenceObjectProcessing.verify:");
            witness.string("  epoch: ").unsigned((WordBase)HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch());
            witness.string("  refBootImage: ").bool(refBootImage);
            witness.string("  refYoung: ").bool(refYoung);
            witness.string("  refOldFrom: ").bool(refOldFrom);
            witness.string("  referent should be in heap.");
            witness.string("]").newline();
            return false;
        }
        assert (!refOldTo) : "referent should be in the heap.";
        return true;
    }

    static {
        maxSoftRefAccessIntervalMs = UnsignedUtils.MAX_VALUE;
        softReferencesAreWeak = false;
        initialSoftRefClock = 0L;
    }
}

