/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.graal.phases.DeadStoreRemovalPhase;
import com.oracle.svm.truffle.api.SubstrateKnownTruffleTypes;
import com.oracle.svm.truffle.api.SubstratePEGraphDecoder;
import com.oracle.svm.truffle.api.SubstrateTruffleGraphBuilderPlugins;
import com.oracle.svm.truffle.api.TruffleBoundaryPhase;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.graph.SourceLanguagePositionProvider;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.PEGraphDecoder;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;
import org.graalvm.compiler.truffle.compiler.substitutions.TruffleDecodingPlugins;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstratePartialEvaluator
extends PartialEvaluator {
    private final ConcurrentHashMap<ResolvedJavaMethod, Object> invocationPluginsCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<PEGraphDecoder.SpecialCallTargetCacheKey, Object> specialCallTargetCache = new ConcurrentHashMap();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstratePartialEvaluator(Providers providers, GraphBuilderConfiguration configForRoot, SnippetReflectionProvider snippetReflection, Architecture architecture) {
        super(providers, configForRoot, snippetReflection, architecture, (KnownTruffleTypes)new SubstrateKnownTruffleTypes(providers.getMetaAccess()));
    }

    protected PEGraphDecoder createGraphDecoder(PartialEvaluator.Request request, LoopExplosionPlugin loopExplosionPlugin, InvocationPlugins invocationPlugins, InlineInvokePlugin[] inlineInvokePlugins, ParameterPlugin parameterPlugin, NodePlugin[] nodePlugins, SourceLanguagePositionProvider sourceLanguagePositionProvider, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache) {
        return new SubstratePEGraphDecoder(this.architecture, request.graph, (CoreProviders)this.providers.copyWith((ConstantFieldProvider)this.compilationLocalConstantProvider), loopExplosionPlugin, invocationPlugins, inlineInvokePlugins, parameterPlugin, nodePlugins, this.callInlined, sourceLanguagePositionProvider, this.specialCallTargetCache, this.invocationPluginsCache);
    }

    protected StructuredGraph.Builder customizeStructuredGraphBuilder(StructuredGraph.Builder builder) {
        return super.customizeStructuredGraphBuilder(builder).recordInlinedMethods(false);
    }

    public void doGraphPE(PartialEvaluator.Request request, InlineInvokePlugin inlineInvokePlugin, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache) {
        super.doGraphPE(request, inlineInvokePlugin, graphCache);
        new DeadStoreRemovalPhase().apply(request.graph);
        new TruffleBoundaryPhase().apply(request.graph);
    }

    protected void registerTruffleInvocationPlugins(InvocationPlugins invocationPlugins, boolean canDelayIntrinsification) {
        super.registerTruffleInvocationPlugins(invocationPlugins, canDelayIntrinsification);
        SubstrateTruffleGraphBuilderPlugins.registerCompilationFinalReferencePlugins(invocationPlugins, canDelayIntrinsification, (SubstrateKnownTruffleTypes)this.getKnownTruffleTypes());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected InvocationPlugins createDecodingInvocationPlugins(GraphBuilderConfiguration.Plugins parent) {
        InvocationPlugins decodingInvocationPlugins = new InvocationPlugins();
        this.registerTruffleInvocationPlugins(decodingInvocationPlugins, false);
        TruffleDecodingPlugins.registerInvocationPlugins((InvocationPlugins)decodingInvocationPlugins, (Providers)this.providers);
        decodingInvocationPlugins.closeRegistration();
        return decodingInvocationPlugins;
    }

    protected NodePlugin[] createNodePlugins(GraphBuilderConfiguration.Plugins plugins) {
        return null;
    }
}

