/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;

public abstract class VMOperation {
    private final String name;
    private final SystemEffect systemEffect;

    protected VMOperation(String name, SystemEffect systemEffect) {
        this.name = name;
        this.systemEffect = systemEffect;
    }

    public final String getName() {
        return this.name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected boolean isGC() {
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final boolean getCausesSafepoint() {
        return this.systemEffect == SystemEffect.SAFEPOINT;
    }

    protected final void execute(NativeVMOperationData data) {
        Log trace;
        assert (VMOperationControl.mayExecuteVmOperations());
        assert (!this.isFinished(data));
        Log log = trace = SubstrateOptions.TraceVMOperations.getValue() != false ? Log.log() : Log.noopLog();
        if (!this.hasWork(data)) {
            trace.string("[Skipping operation ").string(this.name).string("]");
            return;
        }
        VMOperationControl control = (VMOperationControl)ImageSingletons.lookup(VMOperationControl.class);
        VMOperation prevOperation = control.getInProgress().getOperation();
        IsolateThread prevQueuingThread = control.getInProgress().getQueuingThread();
        IsolateThread prevExecutingThread = control.getInProgress().getExecutingThread();
        control.setInProgress(this, this.getQueuingThread(data), CurrentIsolate.getCurrentThread());
        try {
            trace.string("[Executing operation ").string(this.name);
            this.operate(data);
            trace.string("]");
        }
        catch (Throwable t) {
            trace.string("[VMOperation.execute caught: ").string(t.getClass().getName()).string("]").newline();
            throw VMError.shouldNotReachHere(t);
        }
        finally {
            control.setInProgress(prevOperation, prevQueuingThread, prevExecutingThread);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isInProgress() {
        VMOperationControl.OpInProgress inProgress = VMOperationControl.get().getInProgress();
        return VMOperation.isInProgress(inProgress);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isInProgressAtSafepoint() {
        VMOperationControl.OpInProgress inProgress = VMOperationControl.get().getInProgress();
        return VMOperation.isInProgress(inProgress) && inProgress.operation.getCausesSafepoint();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isInProgress(VMOperationControl.OpInProgress inProgress) {
        return inProgress.getExecutingThread() == CurrentIsolate.getCurrentThread();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isGCInProgress() {
        VMOperation op = VMOperationControl.get().getInProgress().getOperation();
        return op != null && op.isGC();
    }

    public static void guaranteeInProgress(String message) {
        if (!VMOperation.isInProgress()) {
            throw VMError.shouldNotReachHere(message);
        }
    }

    public static void guaranteeNotInProgress(String message) {
        if (VMOperation.isInProgress()) {
            throw VMError.shouldNotReachHere(message);
        }
    }

    public static void guaranteeInProgressAtSafepoint(String message) {
        if (!VMOperation.isInProgressAtSafepoint()) {
            throw VMError.shouldNotReachHere(message);
        }
    }

    public static void guaranteeGCInProgress(String message) {
        if (!VMOperation.isGCInProgress()) {
            throw VMError.shouldNotReachHere(message);
        }
    }

    protected boolean hasWork(NativeVMOperationData data) {
        return true;
    }

    protected abstract IsolateThread getQueuingThread(NativeVMOperationData var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract void setQueuingThread(NativeVMOperationData var1, IsolateThread var2);

    protected abstract boolean isFinished(NativeVMOperationData var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract void setFinished(NativeVMOperationData var1, boolean var2);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true, reason="Whitelisted because some operations may allocate.")
    protected abstract void operate(NativeVMOperationData var1);

    public static enum SystemEffect {
        NONE,
        SAFEPOINT;

    }
}

