/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.AccessControllerUtil;
import java.security.AccessControlContext;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
class AccessControlContextFeature
implements Feature {
    AccessControlContextFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(AccessControlContextFeature::replaceAccessControlContext);
    }

    private static Object replaceAccessControlContext(Object obj) {
        if (obj instanceof AccessControlContext) {
            return AccessControllerUtil.NO_CONTEXT_SINGLETON;
        }
        return obj;
    }
}

