/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.HeapOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionType;

public class HeapOptions_OptionDescriptors
implements OptionDescriptors {
    public OptionDescriptor get(String value) {
        switch (value) {
            case "HeapVerificationFailureIsFatal": {
                return OptionDescriptor.create((String)"HeapVerificationFailureIsFatal", (OptionType)OptionType.Debug, Boolean.class, (String)"Failed verification of the heap (if enabled) causes termination.", HeapOptions.class, (String)"HeapVerificationFailureIsFatal", HeapOptions.HeapVerificationFailureIsFatal, (boolean)false);
            }
            case "ImageHeapCardMarking": {
                return OptionDescriptor.create((String)"ImageHeapCardMarking", (OptionType)OptionType.Expert, Boolean.class, (String)"Enables card marking for image heap objects, which arranges them in chunks. Automatically enabled when supported.", HeapOptions.class, (String)"ImageHeapCardMarking", HeapOptions.ImageHeapCardMarking, (boolean)false);
            }
            case "PrintGCSummary": {
                return OptionDescriptor.create((String)"PrintGCSummary", (OptionType)OptionType.Debug, Boolean.class, (String)"Print summary GC information after application main method returns.", HeapOptions.class, (String)"PrintGCSummary", HeapOptions.PrintGCSummary, (boolean)false);
            }
            case "PrintGCTimeStamps": {
                return OptionDescriptor.create((String)"PrintGCTimeStamps", (OptionType)OptionType.Debug, Boolean.class, (String)"Print a time stamp at each collection, if +PrintGC or +VerboseGC.", HeapOptions.class, (String)"PrintGCTimeStamps", HeapOptions.PrintGCTimeStamps, (boolean)false);
            }
            case "PrintGCTimes": {
                return OptionDescriptor.create((String)"PrintGCTimes", (OptionType)OptionType.Debug, Boolean.class, (String)"Print the time for each of the phases of each collection, if +VerboseGC.", HeapOptions.class, (String)"PrintGCTimes", HeapOptions.PrintGCTimes, (boolean)false);
            }
            case "PrintHeapShape": {
                return OptionDescriptor.create((String)"PrintHeapShape", (OptionType)OptionType.Debug, Boolean.class, (String)"Print the shape of the heap before and after each collection, if +VerboseGC.", HeapOptions.class, (String)"PrintHeapShape", HeapOptions.PrintHeapShape, (boolean)false);
            }
            case "SoftRefLRUPolicyMSPerMB": {
                return OptionDescriptor.create((String)"SoftRefLRUPolicyMSPerMB", (OptionType)OptionType.Expert, Integer.class, (String)"Soft references: this number of milliseconds multiplied by the free heap memory in MByte is the time span for which a soft reference will keep its referent alive after its last access.", HeapOptions.class, (String)"SoftRefLRUPolicyMSPerMB", HeapOptions.SoftRefLRUPolicyMSPerMB, (boolean)false);
            }
            case "TraceHeapVerification": {
                return OptionDescriptor.create((String)"TraceHeapVerification", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace heap verification.", HeapOptions.class, (String)"TraceHeapVerification", HeapOptions.TraceHeapVerification, (boolean)false);
            }
            case "TraceObjectPromotion": {
                return OptionDescriptor.create((String)"TraceObjectPromotion", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace each object promotion (generates significant amounts of output).", HeapOptions.class, (String)"TraceObjectPromotion", HeapOptions.TraceObjectPromotion, (boolean)false);
            }
            case "TraceStackVerification": {
                return OptionDescriptor.create((String)"TraceStackVerification", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace stack verification.", HeapOptions.class, (String)"TraceStackVerification", HeapOptions.TraceStackVerification, (boolean)false);
            }
            case "VerifyDirtyCardsAfterCollection": {
                return OptionDescriptor.create((String)"VerifyDirtyCardsAfterCollection", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify dirty cards after each collection.", HeapOptions.class, (String)"VerifyDirtyCardsAfterCollection", HeapOptions.VerifyDirtyCardsAfterCollection, (boolean)false);
            }
            case "VerifyDirtyCardsBeforeCollection": {
                return OptionDescriptor.create((String)"VerifyDirtyCardsBeforeCollection", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify dirty cards before each collection.", HeapOptions.class, (String)"VerifyDirtyCardsBeforeCollection", HeapOptions.VerifyDirtyCardsBeforeCollection, (boolean)false);
            }
            case "VerifyHeapAfterCollection": {
                return OptionDescriptor.create((String)"VerifyHeapAfterCollection", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify the heap after each collection.", HeapOptions.class, (String)"VerifyHeapAfterCollection", HeapOptions.VerifyHeapAfterCollection, (boolean)false);
            }
            case "VerifyHeapBeforeCollection": {
                return OptionDescriptor.create((String)"VerifyHeapBeforeCollection", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify the heap before each collection.", HeapOptions.class, (String)"VerifyHeapBeforeCollection", HeapOptions.VerifyHeapBeforeCollection, (boolean)false);
            }
            case "VerifyStackAfterCollection": {
                return OptionDescriptor.create((String)"VerifyStackAfterCollection", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify stacks after each collection.", HeapOptions.class, (String)"VerifyStackAfterCollection", HeapOptions.VerifyStackAfterCollection, (boolean)false);
            }
            case "VerifyStackBeforeCollection": {
                return OptionDescriptor.create((String)"VerifyStackBeforeCollection", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify stacks before each collection.", HeapOptions.class, (String)"VerifyStackBeforeCollection", HeapOptions.VerifyStackBeforeCollection, (boolean)false);
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 16;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return HeapOptions_OptionDescriptors.this.get("HeapVerificationFailureIsFatal");
                    }
                    case 1: {
                        return HeapOptions_OptionDescriptors.this.get("ImageHeapCardMarking");
                    }
                    case 2: {
                        return HeapOptions_OptionDescriptors.this.get("PrintGCSummary");
                    }
                    case 3: {
                        return HeapOptions_OptionDescriptors.this.get("PrintGCTimeStamps");
                    }
                    case 4: {
                        return HeapOptions_OptionDescriptors.this.get("PrintGCTimes");
                    }
                    case 5: {
                        return HeapOptions_OptionDescriptors.this.get("PrintHeapShape");
                    }
                    case 6: {
                        return HeapOptions_OptionDescriptors.this.get("SoftRefLRUPolicyMSPerMB");
                    }
                    case 7: {
                        return HeapOptions_OptionDescriptors.this.get("TraceHeapVerification");
                    }
                    case 8: {
                        return HeapOptions_OptionDescriptors.this.get("TraceObjectPromotion");
                    }
                    case 9: {
                        return HeapOptions_OptionDescriptors.this.get("TraceStackVerification");
                    }
                    case 10: {
                        return HeapOptions_OptionDescriptors.this.get("VerifyDirtyCardsAfterCollection");
                    }
                    case 11: {
                        return HeapOptions_OptionDescriptors.this.get("VerifyDirtyCardsBeforeCollection");
                    }
                    case 12: {
                        return HeapOptions_OptionDescriptors.this.get("VerifyHeapAfterCollection");
                    }
                    case 13: {
                        return HeapOptions_OptionDescriptors.this.get("VerifyHeapBeforeCollection");
                    }
                    case 14: {
                        return HeapOptions_OptionDescriptors.this.get("VerifyStackAfterCollection");
                    }
                    case 15: {
                        return HeapOptions_OptionDescriptors.this.get("VerifyStackBeforeCollection");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

