/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.UserError;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;

public final class ConfigurationFiles {
    private static final String SUFFIX = "-config.json";
    public static final String DYNAMIC_PROXY_NAME = "proxy-config.json";
    public static final String RESOURCES_NAME = "resource-config.json";
    public static final String JNI_NAME = "jni-config.json";
    public static final String REFLECTION_NAME = "reflect-config.json";

    public static List<Path> findConfigurationFiles(String fileName) {
        ArrayList<Path> files = new ArrayList<Path>();
        for (String directory : OptionUtils.flatten(",", Options.ConfigurationFileDirectories.getValue())) {
            Path path = Paths.get(directory, fileName);
            if (!Files.exists(path, new LinkOption[0])) continue;
            files.add(path);
        }
        return files;
    }

    public static List<URL> findConfigurationResources(String fileName, ClassLoader classLoader) {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (String root : OptionUtils.flatten(",", Options.ConfigurationResourceRoots.getValue())) {
            String separator = "/";
            String relativeRoot = Stream.of(root.split("/")).filter(part -> !part.isEmpty() && !part.equals(".")).collect(Collectors.joining("/"));
            String relativePath = relativeRoot.isEmpty() ? fileName : relativeRoot + '/' + fileName;
            try {
                Enumeration<URL> e = classLoader.getResources(relativePath);
                while (e.hasMoreElements()) {
                    resources.add(e.nextElement());
                }
            }
            catch (IOException e) {
                throw UserError.abort(e, "Error while looking for %s in %s", fileName, root);
            }
        }
        return resources;
    }

    public static final class Options {
        @Option(help={"Directories directly containing configuration files for dynamic features at runtime."}, type=OptionType.User)
        static final HostedOptionKey<String[]> ConfigurationFileDirectories = new HostedOptionKey<Object>(null);
        @Option(help={"Resource path above configuration resources for dynamic features at runtime."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> ConfigurationResourceRoots = new HostedOptionKey<Object>(null);
        @Option(help={"file:doc-files/ReflectionConfigurationFilesHelp.txt"}, type=OptionType.User)
        public static final HostedOptionKey<String[]> ReflectionConfigurationFiles = new HostedOptionKey<Object>(null);
        @Option(help={"Resources describing program elements to be made available for reflection (see ReflectionConfigurationFiles)."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> ReflectionConfigurationResources = new HostedOptionKey<Object>(null);
        @Option(help={"file:doc-files/ProxyConfigurationFilesHelp.txt"}, type=OptionType.User)
        public static final HostedOptionKey<String[]> DynamicProxyConfigurationFiles = new HostedOptionKey<Object>(null);
        @Option(help={"Resources describing program elements to be made available for reflection (see ProxyConfigurationFiles)."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> DynamicProxyConfigurationResources = new HostedOptionKey<Object>(null);
        @Option(help={"Files describing Java resources to be included in the image."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> ResourceConfigurationFiles = new HostedOptionKey<String[]>(new String[0]);
        @Option(help={"Resources describing Java resources to be included in the image."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> ResourceConfigurationResources = new HostedOptionKey<String[]>(new String[0]);
        @Option(help={"Files describing program elements to be made accessible via JNI (for syntax, see ReflectionConfigurationFiles)"}, type=OptionType.User)
        public static final HostedOptionKey<String[]> JNIConfigurationFiles = new HostedOptionKey<Object>(null);
        @Option(help={"Resources describing program elements to be made accessible via JNI (see JNIConfigurationFiles)."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> JNIConfigurationResources = new HostedOptionKey<Object>(null);
        @Option(help={"Causes unknown attributes in configuration objects to abort the image build instead of emitting a warning."})
        public static final HostedOptionKey<Boolean> StrictConfiguration = new HostedOptionKey<Boolean>(false);
        @Option(help={"Comma-separated list of file names with declarative substitutions"}, type=OptionType.User)
        public static final HostedOptionKey<String[]> SubstitutionFiles = new HostedOptionKey<Object>(null);
    }
}

