/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.ReferenceHandlerRunnable;
import com.oracle.svm.core.jdk.RuntimeSupport;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class ReferenceHandlerThreadFeature
implements Feature {
    private Thread thread;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ReferenceHandler.useDedicatedThread();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        this.thread = new Thread((Runnable)new ReferenceHandlerRunnable(), "Reference Handler");
        this.thread.setPriority(10);
        this.thread.setDaemon(true);
        RuntimeSupport.getRuntimeSupport().addInitializationHook(this.thread::start);
    }

    public Thread getThread() {
        return this.thread;
    }
}

