/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedGraalUtils;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import com.oracle.svm.truffle.isolated.IsolatedCompilableTruffleAST;
import com.oracle.svm.truffle.isolated.IsolatedCompilationIdentifier;
import com.oracle.svm.truffle.isolated.IsolatedEventContext;
import com.oracle.svm.truffle.isolated.IsolatedTruffleCompilationTask;
import com.oracle.svm.truffle.isolated.IsolatedTruffleCompilerEventForwarder;
import com.oracle.svm.truffle.isolated.IsolatedTruffleInliningPlan;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilation;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.TruffleCompilationIdentifier;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Isolates;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.util.OptionsEncoder;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class IsolateAwareTruffleCompiler
implements SubstrateTruffleCompiler {
    private final UninterruptibleUtils.AtomicWord<Isolate> sharedIsolate = new UninterruptibleUtils.AtomicWord();
    protected final SubstrateTruffleCompiler delegate;
    private final AtomicBoolean firstCompilation;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public IsolateAwareTruffleCompiler(SubstrateTruffleCompiler delegate) {
        this.delegate = delegate;
        this.firstCompilation = new AtomicBoolean(true);
    }

    public void initialize(Map<String, Object> options, CompilableTruffleAST compilable, boolean firstInitialization) {
        if (!SubstrateOptions.shouldCompileInIsolates()) {
            this.delegate.initialize(options, compilable, firstInitialization);
        }
    }

    public TruffleCompilation openCompilation(CompilableTruffleAST compilable) {
        return this.delegate.openCompilation(compilable);
    }

    public TruffleDebugContext openDebugContext(Map<String, Object> options, TruffleCompilation compilation) {
        return this.delegate.openDebugContext(options, compilation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="False positive.")
    public void doCompile(TruffleDebugContext debug, TruffleCompilation compilation, Map<String, Object> options, TruffleInliningPlan inlining, TruffleCompilationTask task, TruffleCompilerListener listener) {
        if (!SubstrateOptions.shouldCompileInIsolates()) {
            this.delegate.doCompile(null, compilation, options, inlining, task, listener);
            return;
        }
        CompilerIsolateThread context = this.beforeCompilation();
        try {
            IsolatedCompileClient client = new IsolatedCompileClient(context);
            IsolatedCompileClient.set(client);
            try {
                ClientHandle<String> thrownException;
                String exception;
                byte[] encodedOptions = options.isEmpty() ? null : OptionsEncoder.encode(options);
                byte[] encodedRuntimeOptions = IsolatedGraalUtils.encodeRuntimeOptionValues();
                IsolatedEventContext eventContext = null;
                if (listener != null) {
                    eventContext = new IsolatedEventContext(listener, compilation.getCompilable(), inlining);
                }
                if ((exception = client.unhand(thrownException = IsolateAwareTruffleCompiler.doCompile0(context, (ClientIsolateThread)CurrentIsolate.getCurrentThread(), ImageHeapObjects.ref(this.delegate), client.hand((TruffleCompilationIdentifier)compilation), client.hand((SubstrateCompilableTruffleAST)compilation.getCompilable()), client.hand(encodedOptions), IsolatedGraalUtils.getNullableArrayLength(encodedOptions), client.hand(inlining), client.hand(task), client.hand(eventContext), client.hand(encodedRuntimeOptions), IsolatedGraalUtils.getNullableArrayLength(encodedRuntimeOptions), this.firstCompilation.getAndSet(false)))) != null) {
                    throw new RuntimeException("doCompile threw: " + exception);
                }
            }
            finally {
                IsolatedCompileClient.set(null);
            }
        }
        finally {
            this.afterCompilation(context);
        }
    }

    protected CompilerIsolateThread beforeCompilation() {
        Isolate isolate = this.sharedIsolate.get();
        if (isolate.isNull()) {
            CompilerIsolateThread thread = IsolatedGraalUtils.createCompilationIsolate();
            isolate = Isolates.getIsolate((IsolateThread)thread);
            if (this.sharedIsolate.compareAndSet((Isolate)WordFactory.nullPointer(), isolate)) {
                return thread;
            }
            Isolates.tearDownIsolate((IsolateThread)thread);
            isolate = this.sharedIsolate.get();
            assert (isolate.isNonNull());
        }
        return (CompilerIsolateThread)Isolates.attachCurrentThread((Isolate)isolate);
    }

    protected void afterCompilation(CompilerIsolateThread context) {
        Isolates.detachThread((IsolateThread)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<String> doCompile0(@CEntryPoint.IsolateThreadContext CompilerIsolateThread context, ClientIsolateThread client, ImageHeapRef<SubstrateTruffleCompiler> delegateRef, ClientHandle<TruffleCompilationIdentifier> compilationIdentifierHandle, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle, ClientHandle<byte[]> encodedOptionsHandle, int encodedOptionsLength, ClientHandle<TruffleInliningPlan> inliningHandle, ClientHandle<TruffleCompilationTask> taskHandle, ClientHandle<IsolatedEventContext> eventContextHandle, ClientHandle<byte[]> encodedRuntimeOptionsHandle, int encodedRuntimeOptionsLength, boolean firstCompilation) {
        IsolatedCompileContext.set(new IsolatedCompileContext(client));
        try {
            IsolatedGraalUtils.applyClientRuntimeOptionValues(encodedRuntimeOptionsHandle, encodedRuntimeOptionsLength);
            SubstrateTruffleCompiler delegate = ImageHeapObjects.deref(delegateRef);
            Map<String, Object> options = IsolateAwareTruffleCompiler.decodeOptions(client, encodedOptionsHandle, encodedOptionsLength);
            IsolatedCompilableTruffleAST compilable = new IsolatedCompilableTruffleAST(compilableHandle);
            delegate.initialize(options, compilable, firstCompilation);
            IsolatedCompilationIdentifier compilation = new IsolatedCompilationIdentifier(compilationIdentifierHandle, compilable);
            IsolatedTruffleInliningPlan inlining = new IsolatedTruffleInliningPlan(inliningHandle);
            IsolatedTruffleCompilationTask task = null;
            if (taskHandle.notEqual((ComparableWord)IsolatedHandles.nullHandle())) {
                task = new IsolatedTruffleCompilationTask(taskHandle);
            }
            IsolatedTruffleCompilerEventForwarder listener = null;
            if (eventContextHandle.notEqual((ComparableWord)IsolatedHandles.nullHandle())) {
                listener = new IsolatedTruffleCompilerEventForwarder(eventContextHandle);
            }
            delegate.doCompile(null, (TruffleCompilation)compilation, options, inlining, task, listener);
            ClientHandle clientHandle = (ClientHandle)IsolatedHandles.nullHandle();
            return clientHandle;
        }
        catch (Throwable t) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            ClientHandle<String> clientHandle = IsolatedCompileContext.get().createStringInClient(writer.toString());
            return clientHandle;
        }
        finally {
            IsolatedCompileContext.set(null);
        }
    }

    private static Map<String, Object> decodeOptions(ClientIsolateThread client, ClientHandle<byte[]> encodedOptionsHandle, int encodedOptionsLength) {
        if (encodedOptionsLength <= 0) {
            return Collections.emptyMap();
        }
        byte[] encodedOptions = new byte[encodedOptionsLength];
        try (PinnedObject pinnedEncodedOptions = PinnedObject.create((Object)encodedOptions);){
            IsolateAwareTruffleCompiler.copyEncodedOptions(client, encodedOptionsHandle, pinnedEncodedOptions.addressOfArrayElement(0));
        }
        return OptionsEncoder.decode((byte[])encodedOptions);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void copyEncodedOptions(@CEntryPoint.IsolateThreadContext ClientIsolateThread client, ClientHandle<byte[]> encodedOptionsHandle, PointerBase buffer) {
        byte[] encodedOptions = IsolatedCompileClient.get().unhand(encodedOptionsHandle);
        CTypeConversion.asByteBuffer((PointerBase)buffer, (int)encodedOptions.length).put(encodedOptions);
    }

    public String getCompilerConfigurationName() {
        return this.delegate.getCompilerConfigurationName();
    }

    @Override
    public void teardown() {
        if (SubstrateOptions.shouldCompileInIsolates()) {
            this.tearDownIsolateOnShutdown();
        }
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    protected void tearDownIsolateOnShutdown() {
        Isolate shared = this.sharedIsolate.get();
        if (shared.isNonNull()) {
            IsolateThread current = Isolates.attachCurrentThread((Isolate)shared);
            Isolates.tearDownIsolate((IsolateThread)current);
        }
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PartialEvaluator getPartialEvaluator() {
        return this.delegate.getPartialEvaluator();
    }

    public SnippetReflectionProvider getSnippetReflection() {
        return this.delegate.getSnippetReflection();
    }
}

