/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticFeature
public class JNIRegistrationPrefs
extends JNIRegistrationUtil
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        String preferencesImplementation = JNIRegistrationPrefs.getPlatformPreferencesClassName();
        JNIRegistrationPrefs.rerunClassInit((Feature.FeatureAccess)access, preferencesImplementation);
        if (JNIRegistrationPrefs.isDarwin()) {
            JNIRegistrationPrefs.rerunClassInit((Feature.FeatureAccess)access, "java.util.prefs.MacOSXPreferencesFile");
        }
        access.registerReachabilityHandler(JNIRegistrationPrefs::handlePreferencesClassReachable, new Object[]{JNIRegistrationPrefs.clazz((Feature.FeatureAccess)access, preferencesImplementation)});
    }

    private static String getPlatformPreferencesClassName() {
        if (JNIRegistrationPrefs.isLinux()) {
            return "java.util.prefs.FileSystemPreferences";
        }
        if (JNIRegistrationPrefs.isWindows()) {
            return "java.util.prefs.WindowsPreferences";
        }
        if (JNIRegistrationPrefs.isDarwin()) {
            return "java.util.prefs.MacOSXPreferences";
        }
        throw VMError.shouldNotReachHere("Unexpected platform");
    }

    private static void handlePreferencesClassReachable(Feature.DuringAnalysisAccess access) {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("prefs");
        } else if (JNIRegistrationPrefs.isDarwin()) {
            NativeLibraries nativeLibraries = ((FeatureImpl.DuringAnalysisAccessImpl)access).getNativeLibraries();
            nativeLibraries.addStaticJniLibrary("osx", new String[0]);
        }
        if (JNIRegistrationPrefs.isDarwin()) {
            JNIRuntimeAccess.register(String[].class);
        }
    }
}

