/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataImpl;
import com.oracle.svm.core.c.CGlobalDataNonConstantRegistry;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.serviceprovider.BufferUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class CGlobalDataFeature
implements GraalFeature {
    private final Method getCGlobalDataInfoMethod = ReflectionUtil.lookupMethod(CGlobalDataNonConstantRegistry.class, (String)"getCGlobalDataInfo", (Class[])new Class[]{CGlobalDataImpl.class});
    private final Field offsetField = ReflectionUtil.lookupField(CGlobalDataInfo.class, (String)"offset");
    private final Field isSymbolReferenceField = ReflectionUtil.lookupField(CGlobalDataInfo.class, (String)"isSymbolReference");
    private final CGlobalDataNonConstantRegistry nonConstantRegistry = new CGlobalDataNonConstantRegistry();
    private final JavaConstant nonConstantRegistryJavaConstant = SubstrateObjectConstant.forObject(this.nonConstantRegistry);
    private final Map<CGlobalDataImpl<?>, CGlobalDataInfo> map = new ConcurrentHashMap();
    private CGlobalDataInfo cGlobalDataBaseAddress;
    private int totalSize = -1;

    public static CGlobalDataFeature singleton() {
        return (CGlobalDataFeature)ImageSingletons.lookup(CGlobalDataFeature.class);
    }

    private boolean isLayouted() {
        return this.totalSize != -1;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(this::replaceObject);
        this.cGlobalDataBaseAddress = this.registerAsAccessedOrGet(CGlobalDataInfo.CGLOBALDATA_RUNTIME_BASE_ADDRESS);
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess access) {
        this.layout();
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, InvocationPlugins invocationPlugins, boolean analysis, boolean hosted) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(invocationPlugins, CGlobalData.class);
        r.register1("get", InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext builderContext, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode cGlobalDataNode = receiver.get();
                if (cGlobalDataNode.isConstant()) {
                    CGlobalDataImpl data = (CGlobalDataImpl)SubstrateObjectConstant.asObject(cGlobalDataNode.asConstant());
                    CGlobalDataInfo info = (CGlobalDataInfo)CGlobalDataFeature.this.map.get(data);
                    builderContext.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)new CGlobalDataLoadAddressNode(info));
                } else {
                    ConstantNode nonConstantRegistryNode = ConstantNode.forConstant((JavaConstant)CGlobalDataFeature.this.nonConstantRegistryJavaConstant, (MetaAccessProvider)builderContext.getMetaAccess(), (StructuredGraph)builderContext.getGraph());
                    ResolvedJavaMethod getCGlobalDataInfoResolvedMethod = builderContext.getMetaAccess().lookupJavaMethod((Executable)CGlobalDataFeature.this.getCGlobalDataInfoMethod);
                    ValueNode cGlobalDataInfo = (ValueNode)builderContext.handleReplacedInvoke(CallTargetNode.InvokeKind.Virtual, getCGlobalDataInfoResolvedMethod, new ValueNode[]{nonConstantRegistryNode, cGlobalDataNode}, false);
                    builderContext.pop(cGlobalDataInfo.getStackKind());
                    ResolvedJavaType resolvedJavaType = builderContext.getMetaAccess().lookupJavaType(CGlobalDataInfo.class);
                    if (resolvedJavaType instanceof AnalysisType) {
                        ((AnalysisType)resolvedJavaType).registerAsReachable();
                    }
                    ResolvedJavaField offset = builderContext.getMetaAccess().lookupJavaField(CGlobalDataFeature.this.offsetField);
                    ValueNode offsetFieldNode = builderContext.add((ValueNode)LoadFieldNode.create((Assumptions)builderContext.getAssumptions(), (ValueNode)cGlobalDataInfo, (ResolvedJavaField)offset));
                    CGlobalDataLoadAddressNode cGlobalDataBaseAddressNode = (CGlobalDataLoadAddressNode)builderContext.add((ValueNode)new CGlobalDataLoadAddressNode(CGlobalDataFeature.this.cGlobalDataBaseAddress));
                    ValueNode cGlobalDataInfoOffsetWidened = (ValueNode)builderContext.getGraph().addOrUnique((Node)SignExtendNode.create((ValueNode)offsetFieldNode, (int)IntegerStamp.getBits((Stamp)cGlobalDataBaseAddressNode.stamp(NodeView.DEFAULT)), (NodeView)NodeView.DEFAULT));
                    OffsetAddressNode cGlobalDataAddress = (OffsetAddressNode)builderContext.add((ValueNode)new OffsetAddressNode((ValueNode)cGlobalDataBaseAddressNode, cGlobalDataInfoOffsetWidened));
                    ResolvedJavaField isSymbolReference = builderContext.getMetaAccess().lookupJavaField(CGlobalDataFeature.this.isSymbolReferenceField);
                    ValueNode isSymbolReferenceNode = builderContext.add((ValueNode)LoadFieldNode.create((Assumptions)builderContext.getAssumptions(), (ValueNode)cGlobalDataInfo, (ResolvedJavaField)isSymbolReference));
                    LogicNode logicNode = IntegerEqualsNode.create((ValueNode)isSymbolReferenceNode, (ValueNode)ConstantNode.forBoolean((boolean)false, (StructuredGraph)builderContext.getGraph()), (NodeView)NodeView.DEFAULT);
                    AddNode calculatedAddress = (AddNode)builderContext.add((ValueNode)new AddNode(cGlobalDataAddress.getBase(), cGlobalDataAddress.getOffset()));
                    ReadNode cGlobalDataValue = (ReadNode)builderContext.add((ValueNode)new ReadNode((AddressNode)cGlobalDataAddress, NamedLocationIdentity.ANY_LOCATION, cGlobalDataBaseAddressNode.stamp(NodeView.DEFAULT), OnHeapMemoryAccess.BarrierType.NONE));
                    AbstractBeginNode trueBegin = (AbstractBeginNode)builderContext.add((ValueNode)new BeginNode());
                    FixedWithNextNode predecessor = (FixedWithNextNode)trueBegin.predecessor();
                    predecessor.setNext(null);
                    AbstractBeginNode falseBegin = (AbstractBeginNode)builderContext.add((ValueNode)new BeginNode());
                    trueBegin.setNext(null);
                    IfNode ifNode = (IfNode)builderContext.add((ValueNode)new IfNode(logicNode, trueBegin, falseBegin, 0.0010000000000000009));
                    falseBegin.setNext(null);
                    predecessor.setNext((FixedNode)ifNode);
                    EndNode thenEnd = (EndNode)builderContext.add((ValueNode)new EndNode());
                    trueBegin.setNext((FixedNode)thenEnd);
                    EndNode elseEnd = (EndNode)builderContext.add((ValueNode)new EndNode());
                    falseBegin.setNext((FixedNode)elseEnd);
                    AbstractMergeNode merge = (AbstractMergeNode)builderContext.add((ValueNode)new MergeNode());
                    merge.addForwardEnd(thenEnd);
                    merge.addForwardEnd(elseEnd);
                    ValuePhiNode phiNode = new ValuePhiNode(cGlobalDataBaseAddressNode.stamp(NodeView.DEFAULT), merge, new ValueNode[]{calculatedAddress, cGlobalDataValue});
                    builderContext.push(targetMethod.getSignature().getReturnKind(), (ValueNode)builderContext.getGraph().addOrUnique((Node)phiNode));
                    builderContext.setStateAfter((StateSplit)merge);
                }
                return true;
            }
        });
    }

    public void registerWithGlobalSymbol(CGlobalData<?> obj) {
        this.registerWithGlobalSymbolImpl(obj);
    }

    private CGlobalDataInfo registerWithGlobalSymbolImpl(CGlobalData<?> obj) {
        CGlobalDataInfo info = this.registerAsAccessedOrGet(obj);
        info.makeGlobalSymbol();
        return info;
    }

    public CGlobalDataInfo registerAsAccessedOrGet(CGlobalData<?> obj) {
        CGlobalDataImpl data = (CGlobalDataImpl)obj;
        VMError.guarantee(!this.isLayouted() || this.map.containsKey(data), "CGlobalData instance must have been discovered/registered before or during analysis");
        return this.map.computeIfAbsent((CGlobalDataImpl)obj, o -> {
            CGlobalDataInfo cGlobalDataInfo = new CGlobalDataInfo(data);
            if (data.nonConstant) {
                this.nonConstantRegistry.registerNonConstantSymbol(cGlobalDataInfo);
            }
            return cGlobalDataInfo;
        });
    }

    private Object replaceObject(Object obj) {
        if (obj instanceof CGlobalDataImpl) {
            this.registerAsAccessedOrGet((CGlobalData)obj);
        }
        return obj;
    }

    private void layout() {
        assert (!this.isLayouted()) : "Already layouted";
        int wordSize = ConfigurationValues.getTarget().wordSize;
        int offset = 0;
        for (Map.Entry<CGlobalDataImpl<?>, CGlobalDataInfo> entry : this.map.entrySet()) {
            int size;
            CGlobalDataImpl<?> data = entry.getKey();
            CGlobalDataInfo info = entry.getValue();
            byte[] bytes = null;
            if (data.bytesSupplier != null) {
                bytes = data.bytesSupplier.get();
                size = bytes.length;
            } else if (data.sizeSupplier != null) {
                size = data.sizeSupplier.getAsInt();
            } else {
                assert (data.symbolName != null) : "CGlobalData without bytes, size, or referenced symbol";
                size = wordSize;
            }
            info.assign(offset, bytes);
            offset += size;
            offset = offset + (wordSize - 1) & ~(wordSize - 1);
        }
        this.totalSize = offset;
        assert (this.isLayouted());
    }

    public int getSize() {
        assert (this.isLayouted()) : "Not layouted yet";
        return this.totalSize;
    }

    public void writeData(RelocatableBuffer buffer, BiFunction<Integer, String, ?> createSymbol, BiFunction<Integer, String, ?> createSymbolReference) {
        assert (this.isLayouted()) : "Not layouted yet";
        ByteBuffer bufferBytes = buffer.getByteBuffer();
        int start = bufferBytes.position();
        assert (IntStream.range(start, start + this.totalSize).allMatch(i -> bufferBytes.get(i) == 0)) : "Buffer must be zero-initialized";
        for (CGlobalDataInfo info : this.map.values()) {
            byte[] bytes = info.getBytes();
            if (bytes != null) {
                BufferUtil.asBaseBuffer((Buffer)bufferBytes).position(start + info.getOffset());
                bufferBytes.put(bytes, 0, bytes.length);
            }
            CGlobalDataImpl<?> data = info.getData();
            if (data.symbolName != null && !info.isSymbolReference()) {
                createSymbol.apply(info.getOffset(), data.symbolName);
            }
            if (!data.nonConstant) continue;
            createSymbolReference.apply(info.getOffset(), data.symbolName);
        }
    }
}

