/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.agent;

import com.oracle.svm.core.util.UserError;
import java.util.HashSet;
import java.util.Set;

public class TracingAdvisor {
    private final Set<String> classesForInitializationTracing = new HashSet<String>();
    private final Set<String> classesForObjectInstantiationTracing = new HashSet<String>();

    public TracingAdvisor(String options) {
        String[] optionPairs;
        for (String option : optionPairs = options.split(",")) {
            String[] optionKeyValue = option.split("=");
            if (optionKeyValue.length != 2) {
                throw UserError.abort("AgentTracingAdvisor: Option must be in format <option>=<val>: %s", option);
            }
            if (optionKeyValue[0].equals("c")) {
                this.classesForInitializationTracing.add(optionKeyValue[1]);
                continue;
            }
            if (optionKeyValue[0].equals("o")) {
                this.classesForObjectInstantiationTracing.add(optionKeyValue[1]);
                continue;
            }
            throw UserError.abort("AgentTracingAdvisor: Unknown option: %s", optionKeyValue[0]);
        }
    }

    public boolean shouldTraceClassInitialization(String className) {
        return className != null && this.classesForInitializationTracing.contains(className);
    }

    public boolean shouldTraceObjectInstantiation(String className) {
        return className != null && this.classesForObjectInstantiationTracing.contains(className);
    }
}

