/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.hosted.AbstractNativeImageClassLoaderSupport;
import com.oracle.svm.hosted.ImageClassLoader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;

public class NativeImageClassLoaderSupport
extends AbstractNativeImageClassLoaderSupport {
    NativeImageClassLoaderSupport(ClassLoader defaultSystemClassLoader, String[] classpath, String[] modulePath) {
        super(defaultSystemClassLoader, classpath);
    }

    @Override
    public List<Path> modulepath() {
        return Collections.emptyList();
    }

    @Override
    List<Path> applicationModulePath() {
        return Collections.emptyList();
    }

    @Override
    public Optional<Object> findModule(String moduleName) {
        return Optional.empty();
    }

    @Override
    Class<?> loadClassFromModule(Object module, String className) throws ClassNotFoundException {
        if (module != null) {
            throw new ClassNotFoundException(className, new UnsupportedOperationException("NativeImageClassLoader for Java 8 does not support modules"));
        }
        return Class.forName(className, false, this.classPathClassLoader);
    }

    @Override
    public void initAllClasses(ForkJoinPool executor, ImageClassLoader imageClassLoader) {
        new AbstractNativeImageClassLoaderSupport.ClassInit(executor, imageClassLoader, this).init();
    }
}

