/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

public final class Resources {
    private Resources() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerResource(String name, InputStream is) {
        ResourcesSupport support = (ResourcesSupport)ImageSingletons.lookup(ResourcesSupport.class);
        byte[] arr = new byte[4096];
        int pos = 0;
        try {
            while (true) {
                int len;
                if (pos == arr.length) {
                    byte[] tmp = new byte[arr.length * 2];
                    System.arraycopy(arr, 0, tmp, 0, arr.length);
                    arr = tmp;
                }
                if ((len = is.read(arr, pos, arr.length - pos)) != -1) {
                    pos += len;
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        byte[] res = new byte[pos];
        System.arraycopy(arr, 0, res, 0, pos);
        List<byte[]> list = support.resources.get(name);
        if (list == null) {
            list = new ArrayList<byte[]>();
            support.resources.put(name, list);
        }
        list.add(res);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerDirectoryResource(String dir, String content) {
        ResourcesSupport support = (ResourcesSupport)ImageSingletons.lookup(ResourcesSupport.class);
        byte[] arr = content.getBytes();
        List<byte[]> list = support.resources.get(dir);
        if (list == null) {
            list = new ArrayList<byte[]>();
            support.resources.put(dir, list);
        }
        list.add(arr);
    }

    public static List<byte[]> get(String name) {
        return ((ResourcesSupport)ImageSingletons.lookup(ResourcesSupport.class)).resources.get(name);
    }

    public static URL createURL(String name, final byte[] resourceBytes) {
        try {
            return new URL("resource", null, -1, name, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    class Conn
                    extends URLConnection {
                        final /* synthetic */ byte[] val$resourceBytes;

                        Conn(URL uRL) {
                            this.val$resourceBytes = (byte[])uRL;
                            super(url);
                        }

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return new ByteArrayInputStream(this.val$resourceBytes);
                        }

                        @Override
                        public long getContentLengthLong() {
                            return this.val$resourceBytes.length;
                        }
                    }
                    return new Conn(u, resourceBytes);
                }
            });
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @AutomaticFeature
    static class ResourcesFeature
    implements Feature {
        ResourcesFeature() {
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(ResourcesSupport.class, (Object)new ResourcesSupport());
        }

        public void afterCompilation(Feature.AfterCompilationAccess access) {
            for (List<byte[]> resourceList : ((ResourcesSupport)ImageSingletons.lookup(ResourcesSupport.class)).resources.values()) {
                for (byte[] resource : resourceList) {
                    access.registerAsImmutable((Object)resource);
                }
            }
        }
    }

    static class ResourcesSupport {
        final Map<String, List<byte[]>> resources = new HashMap<String, List<byte[]>>();

        ResourcesSupport() {
        }
    }
}

