/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jdk.Target_java_io_FileDescriptor_JNI;
import com.oracle.svm.core.jdk.Target_java_io_FileInputStream_JNI;
import com.oracle.svm.core.jdk.Target_java_io_FileOutputStream_JNI;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.PointerBase;

public abstract class JNIPlatformNativeLibrarySupport
extends PlatformNativeLibrarySupport {
    private static final CGlobalData<CCharPointer> EMPTY_C_STRING = CGlobalDataFactory.createCString("");

    @Platforms(value={InternalPlatform.PLATFORM_JNI.class})
    protected void loadJavaLibrary() {
        System.loadLibrary("java");
        Target_java_io_FileDescriptor_JNI.initIDs();
        Target_java_io_FileInputStream_JNI.initIDs();
        Target_java_io_FileOutputStream_JNI.initIDs();
        JNIPlatformNativeLibrarySupport.initializeEncoding();
    }

    private static void initializeEncoding() {
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)System.getProperty("sun.jnu.encoding"));){
                JNIPlatformNativeLibrarySupport.nativeInitializeEncoding((PointerBase)CurrentIsolate.getCurrentThread(), name.get());
            }
        } else {
            JNIPlatformNativeLibrarySupport.nativeNewStringPlatform((PointerBase)CurrentIsolate.getCurrentThread(), EMPTY_C_STRING.get());
        }
    }

    @CFunction(value="InitializeEncoding")
    private static native void nativeInitializeEncoding(PointerBase var0, CCharPointer var1);

    @CFunction(value="JNU_NewStringPlatform")
    private static native void nativeNewStringPlatform(PointerBase var0, CCharPointer var1);

    @Platforms(value={InternalPlatform.PLATFORM_JNI.class})
    protected void loadZipLibrary() {
        if (JavaVersionUtil.JAVA_SPEC == 8) {
            System.loadLibrary("zip");
        }
    }
}

