/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.GraalError;

public class SubstrateCompilationIdentifier
implements CompilationIdentifier {
    private static final AtomicLong uniqueIds = new AtomicLong();
    private final long id = uniqueIds.getAndIncrement();

    public final String toString() {
        return this.toString(CompilationIdentifier.Verbosity.DETAILED);
    }

    public String toString(CompilationIdentifier.Verbosity verbosity) {
        return this.buildString(new StringBuilder(), verbosity).toString();
    }

    protected StringBuilder buildString(StringBuilder sb, CompilationIdentifier.Verbosity verbosity) {
        switch (verbosity) {
            case ID: {
                this.buildID(sb);
                break;
            }
            case NAME: {
                this.buildName(sb);
                break;
            }
            case DETAILED: {
                this.buildID(sb);
                sb.append('[');
                this.buildName(sb);
                sb.append(']');
                break;
            }
            default: {
                throw new GraalError("unknown verbosity: " + verbosity);
            }
        }
        return sb;
    }

    protected StringBuilder buildID(StringBuilder sb) {
        sb.append("SubstrateCompilation-");
        return sb.append(this.id);
    }

    protected StringBuilder buildName(StringBuilder sb) {
        return this.buildID(sb);
    }
}

