/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.Timer;
import com.oracle.svm.core.log.Log;

final class Timers {
    final Timer blackenImageHeapRoots = new Timer("blackenImageHeapRoots");
    final Timer blackenDirtyCardRoots = new Timer("blackenDirtyCardRoots");
    final Timer blackenStackRoots = new Timer("blackenStackRoots");
    final Timer cheneyScanFromRoots = new Timer("cheneyScanFromRoots");
    final Timer cheneyScanFromDirtyRoots = new Timer("cheneyScanFromDirtyRoots");
    final Timer collection = new Timer("collection");
    final Timer cleanCodeCache = new Timer("cleanCodeCache");
    final Timer referenceObjects = new Timer("referenceObjects");
    final Timer promotePinnedObjects = new Timer("promotePinnedObjects");
    final Timer rootScan = new Timer("rootScan");
    final Timer scanGreyObjects = new Timer("scanGreyObjects");
    final Timer releaseSpaces = new Timer("releaseSpaces");
    final Timer verifyAfter = new Timer("verifyAfter");
    final Timer verifyBefore = new Timer("verifyBefore");
    final Timer walkThreadLocals = new Timer("walkThreadLocals");
    final Timer walkRuntimeCodeCache = new Timer("walkRuntimeCodeCache");
    final Timer cleanRuntimeCodeCache = new Timer("cleanRuntimeCodeCache");
    final Timer mutator = new Timer("mutator");

    Timers() {
    }

    void resetAllExceptMutator() {
        Log trace = Log.noopLog();
        trace.string("[Timers.resetAllExceptMutator:");
        this.verifyBefore.reset();
        this.collection.reset();
        this.rootScan.reset();
        this.cheneyScanFromRoots.reset();
        this.cheneyScanFromDirtyRoots.reset();
        this.promotePinnedObjects.reset();
        this.blackenStackRoots.reset();
        this.walkThreadLocals.reset();
        this.walkRuntimeCodeCache.reset();
        this.cleanRuntimeCodeCache.reset();
        this.blackenImageHeapRoots.reset();
        this.blackenDirtyCardRoots.reset();
        this.scanGreyObjects.reset();
        this.cleanCodeCache.reset();
        this.referenceObjects.reset();
        this.releaseSpaces.reset();
        this.verifyAfter.reset();
        trace.string("]").newline();
    }

    void logAfterCollection(Log log) {
        if (log.isEnabled()) {
            log.newline();
            log.string("  [GC nanoseconds:");
            Timers.logOneTimer(log, "    ", this.verifyBefore);
            Timers.logOneTimer(log, "    ", this.collection);
            Timers.logOneTimer(log, "      ", this.rootScan);
            Timers.logOneTimer(log, "        ", this.cheneyScanFromRoots);
            Timers.logOneTimer(log, "        ", this.cheneyScanFromDirtyRoots);
            Timers.logOneTimer(log, "          ", this.promotePinnedObjects);
            Timers.logOneTimer(log, "          ", this.blackenStackRoots);
            Timers.logOneTimer(log, "          ", this.walkThreadLocals);
            Timers.logOneTimer(log, "          ", this.walkRuntimeCodeCache);
            Timers.logOneTimer(log, "          ", this.cleanRuntimeCodeCache);
            Timers.logOneTimer(log, "          ", this.blackenImageHeapRoots);
            Timers.logOneTimer(log, "          ", this.blackenDirtyCardRoots);
            Timers.logOneTimer(log, "          ", this.scanGreyObjects);
            Timers.logOneTimer(log, "      ", this.cleanCodeCache);
            Timers.logOneTimer(log, "      ", this.referenceObjects);
            Timers.logOneTimer(log, "      ", this.releaseSpaces);
            Timers.logOneTimer(log, "    ", this.verifyAfter);
            Timers.logGCLoad(log, "    ", "GCLoad", this.collection, this.mutator);
            log.string("]");
        }
    }

    static void logOneTimer(Log log, String prefix, Timer timer) {
        if (timer.getMeasuredNanos() > 0L) {
            log.newline().string(prefix).string(timer.getName()).string(": ").signed(timer.getMeasuredNanos());
        }
    }

    private static void logGCLoad(Log log, String prefix, String label, Timer cTimer, Timer mTimer) {
        long collectionNanos = cTimer.getLastIntervalNanos();
        long mutatorNanos = mTimer.getLastIntervalNanos();
        long intervalNanos = mutatorNanos + collectionNanos;
        long intervalGCPercent = (100L * collectionNanos + intervalNanos / 2L) / intervalNanos;
        log.newline().string(prefix).string(label).string(": ").signed(intervalGCPercent).string("%");
    }
}

