/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CollectingObjectReferenceVisitor;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.FrameInfoVerifier;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.ReferenceMapEncoder;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import java.util.BitSet;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackLockValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.code.site.ExceptionHandler;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

class CodeInfoVerifier {
    CodeInfoVerifier() {
    }

    static void verifyMethod(SharedMethod method, CompilationResult compilation, int compilationOffset, CodeInfo info) {
        CodeInfoQueryResult queryResult;
        for (int relativeIP = 0; relativeIP < compilation.getTargetCodeSize(); ++relativeIP) {
            int totalIP = relativeIP + compilationOffset;
            CodeInfoQueryResult queryResult2 = new CodeInfoQueryResult();
            CodeInfoAccess.lookupCodeInfo(info, (long)totalIP, queryResult2);
            assert (queryResult2.isEntryPoint() == method.isEntryPoint());
            assert (queryResult2.hasCalleeSavedRegisters() == method.hasCalleeSavedRegisters());
            assert (queryResult2.getTotalFrameSize() == (long)compilation.getTotalFrameSize());
            assert (CodeInfoAccess.lookupStackReferenceMapIndex(info, totalIP) == queryResult2.getReferenceMapIndex());
        }
        for (Infopoint infopoint : compilation.getInfopoints()) {
            int offset;
            if (infopoint.debugInfo == null || (offset = CodeInfoEncoder.getEntryOffset(infopoint)) < 0) continue;
            assert (offset < compilation.getTargetCodeSize());
            queryResult = new CodeInfoQueryResult();
            CodeInfoAccess.lookupCodeInfo(info, (long)(offset + compilationOffset), queryResult);
            CollectingObjectReferenceVisitor visitor = new CollectingObjectReferenceVisitor();
            CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)WordFactory.zero(), CodeInfoAccess.getStackReferenceMapEncoding(info), queryResult.getReferenceMapIndex(), visitor);
            ReferenceMapEncoder.Input expected = (ReferenceMapEncoder.Input)infopoint.debugInfo.getReferenceMap();
            visitor.result.verify();
            assert (expected.equals(visitor.result));
            if (queryResult.frameInfo == CodeInfoQueryResult.NO_FRAME_INFO) continue;
            CodeInfoVerifier.verifyFrame(compilation, infopoint.debugInfo.frame(), queryResult.frameInfo, new BitSet());
        }
        for (ExceptionHandler handler : compilation.getExceptionHandlers()) {
            int offset = handler.pcOffset;
            assert (offset >= 0 && offset < compilation.getTargetCodeSize());
            queryResult = new CodeInfoQueryResult();
            CodeInfoAccess.lookupCodeInfo(info, (long)(offset + compilationOffset), queryResult);
            long actual = queryResult.getExceptionOffset();
            long expected = handler.handlerPos - handler.pcOffset;
            assert (expected != 0L);
            assert (expected == actual);
        }
    }

    private static void verifyFrame(CompilationResult compilation, BytecodeFrame expectedFrame, FrameInfoQueryResult actualFrame, BitSet visitedVirtualObjects) {
        assert (expectedFrame == null == (actualFrame == null));
        if (expectedFrame == null || !actualFrame.needLocalValues) {
            return;
        }
        CodeInfoVerifier.verifyFrame(compilation, expectedFrame.caller(), actualFrame.getCaller(), visitedVirtualObjects);
        for (int i = 0; i < expectedFrame.values.length; ++i) {
            JavaValue expectedValue = expectedFrame.values[i];
            if (i >= actualFrame.getValueInfos().length) {
                assert (ValueUtil.isIllegalJavaValue((JavaValue)expectedValue));
                continue;
            }
            FrameInfoQueryResult.ValueInfo actualValue = actualFrame.getValueInfos()[i];
            JavaKind expectedKind = FrameInfoEncoder.getFrameValueKind(expectedFrame, i);
            assert (expectedKind == actualValue.getKind());
            CodeInfoVerifier.verifyValue(compilation, expectedValue, actualValue, actualFrame, visitedVirtualObjects);
        }
    }

    private static void verifyValue(CompilationResult compilation, JavaValue e, FrameInfoQueryResult.ValueInfo actualValue, FrameInfoQueryResult actualFrame, BitSet visitedVirtualObjects) {
        JavaValue expectedValue = e;
        if (expectedValue instanceof StackLockValue) {
            StackLockValue lock = (StackLockValue)expectedValue;
            assert (ValueUtil.isIllegal((Value)lock.getSlot()));
            assert (lock.isEliminated() == actualValue.isEliminatedMonitor());
            expectedValue = lock.getOwner();
        } else assert (!actualValue.isEliminatedMonitor());
        if (ValueUtil.isIllegalJavaValue((JavaValue)expectedValue)) {
            assert (actualValue.getType() == FrameInfoQueryResult.ValueType.Illegal);
        } else if (ValueUtil.isConstantJavaValue((JavaValue)expectedValue)) {
            assert (actualValue.getType() == FrameInfoQueryResult.ValueType.Constant || actualValue.getType() == FrameInfoQueryResult.ValueType.DefaultConstant);
            JavaConstant expectedConstant = ValueUtil.asConstantJavaValue((JavaValue)expectedValue);
            JavaConstant actualConstant = actualValue.getValue();
            FrameInfoVerifier.verifyConstant(expectedConstant, actualConstant);
        } else if (expectedValue instanceof StackSlot) {
            assert (actualValue.getType() == FrameInfoQueryResult.ValueType.StackSlot);
            int expectedOffset = ((StackSlot)expectedValue).getOffset(compilation.getTotalFrameSize());
            long actualOffset = actualValue.getData();
            assert ((long)expectedOffset == actualOffset);
        } else if (ReservedRegisters.singleton().isAllowedInFrameState(expectedValue)) {
            assert (actualValue.getType() == FrameInfoQueryResult.ValueType.ReservedRegister);
            int expectedNumber = ValueUtil.asRegister((Value)((RegisterValue)expectedValue)).number;
            long actualNumber = actualValue.getData();
            assert ((long)expectedNumber == actualNumber);
        } else if (CalleeSavedRegisters.supportedByPlatform() && expectedValue instanceof RegisterValue) {
            assert (actualValue.getType() == FrameInfoQueryResult.ValueType.Register);
            int expectedOffset = CalleeSavedRegisters.singleton().getOffsetInFrame(ValueUtil.asRegister((Value)((RegisterValue)expectedValue)));
            long actualOffset = actualValue.getData();
            assert ((long)expectedOffset == actualOffset);
            assert (actualOffset < 0L) : "Registers are stored in callee saved area of callee frame, i.e., with negative offset";
        } else if (ValueUtil.isVirtualObject((JavaValue)expectedValue)) {
            assert (actualValue.getType() == FrameInfoQueryResult.ValueType.VirtualObject);
            int expectedId = ValueUtil.asVirtualObject((JavaValue)expectedValue).getId();
            long actualId = actualValue.getData();
            assert ((long)expectedId == actualId);
            CodeInfoVerifier.verifyVirtualObject(compilation, ValueUtil.asVirtualObject((JavaValue)expectedValue), actualFrame.getVirtualObjects()[expectedId], actualFrame, visitedVirtualObjects);
        } else {
            throw VMError.shouldNotReachHere();
        }
    }

    private static void verifyVirtualObject(CompilationResult compilation, VirtualObject expectedObject, FrameInfoQueryResult.ValueInfo[] actualObject, FrameInfoQueryResult actualFrame, BitSet visitedVirtualObjects) {
        if (visitedVirtualObjects.get(expectedObject.getId())) {
            return;
        }
        visitedVirtualObjects.set(expectedObject.getId());
        ObjectLayout objectLayout = ConfigurationValues.getObjectLayout();
        SharedType expectedType = (SharedType)expectedObject.getType();
        if (expectedType.isArray()) {
            JavaKind kind = ((SharedType)expectedType.getComponentType()).getStorageKind();
            int expectedLength = 0;
            for (int i = 0; i < expectedObject.getValues().length; ++i) {
                JavaValue expectedValue = expectedObject.getValues()[i];
                UnsignedWord expectedOffset = WordFactory.unsigned((long)objectLayout.getArrayElementOffset(kind, expectedLength));
                FrameInfoQueryResult.ValueInfo actualValue = CodeInfoVerifier.findActualArrayElement(actualObject, expectedOffset);
                CodeInfoVerifier.verifyValue(compilation, expectedValue, actualValue, actualFrame, visitedVirtualObjects);
                JavaKind valueKind = expectedObject.getSlotKind(i);
                if (objectLayout.sizeInBytes(kind) == 4 && objectLayout.sizeInBytes(valueKind) == 8) {
                    expectedLength += 2;
                    continue;
                }
                ++expectedLength;
            }
            int actualLength = actualObject[1].value.asInt();
            assert (expectedLength == actualLength);
        } else {
            SharedField[] expectedFields = (SharedField[])expectedType.getInstanceFields(true);
            int fieldIdx = 0;
            int valueIdx = 0;
            while (valueIdx < expectedObject.getValues().length) {
                SharedField expectedField = expectedFields[fieldIdx];
                ++fieldIdx;
                JavaValue expectedValue = expectedObject.getValues()[valueIdx];
                JavaKind valueKind = expectedObject.getSlotKind(valueIdx);
                ++valueIdx;
                JavaKind kind = expectedField.getStorageKind();
                if (objectLayout.sizeInBytes(kind) == 4 && objectLayout.sizeInBytes(valueKind) == 8) {
                    ++fieldIdx;
                }
                UnsignedWord expectedOffset = WordFactory.unsigned((int)expectedField.getLocation());
                FrameInfoQueryResult.ValueInfo actualValue = CodeInfoVerifier.findActualField(actualObject, expectedOffset);
                CodeInfoVerifier.verifyValue(compilation, expectedValue, actualValue, actualFrame, visitedVirtualObjects);
            }
        }
    }

    private static FrameInfoQueryResult.ValueInfo findActualArrayElement(FrameInfoQueryResult.ValueInfo[] actualObject, UnsignedWord expectedOffset) {
        DynamicHub hub = KnownIntrinsics.convertUnknownValue(SubstrateObjectConstant.asObject((Constant)actualObject[0].getValue()), DynamicHub.class);
        ObjectLayout objectLayout = ConfigurationValues.getObjectLayout();
        assert (LayoutEncoding.isArray(hub.getLayoutEncoding()));
        return CodeInfoVerifier.findActualValue(actualObject, expectedOffset, objectLayout, LayoutEncoding.getArrayBaseOffset(hub.getLayoutEncoding()), 2);
    }

    private static FrameInfoQueryResult.ValueInfo findActualField(FrameInfoQueryResult.ValueInfo[] actualObject, UnsignedWord expectedOffset) {
        DynamicHub hub = KnownIntrinsics.convertUnknownValue(SubstrateObjectConstant.asObject((Constant)actualObject[0].getValue()), DynamicHub.class);
        ObjectLayout objectLayout = ConfigurationValues.getObjectLayout();
        assert (LayoutEncoding.isInstance(hub.getLayoutEncoding()));
        return CodeInfoVerifier.findActualValue(actualObject, expectedOffset, objectLayout, WordFactory.unsigned((int)objectLayout.getFirstFieldOffset()), 1);
    }

    private static FrameInfoQueryResult.ValueInfo findActualValue(FrameInfoQueryResult.ValueInfo[] actualObject, UnsignedWord expectedOffset, ObjectLayout objectLayout, UnsignedWord startOffset, int startIdx) {
        UnsignedWord curOffset = startOffset;
        int curIdx = startIdx;
        while (curOffset.belowThan(expectedOffset)) {
            FrameInfoQueryResult.ValueInfo value = actualObject[curIdx];
            curOffset = curOffset.add(objectLayout.sizeInBytes(value.getKind()));
            ++curIdx;
        }
        if (curOffset.equal(expectedOffset)) {
            return actualObject[curIdx];
        }
        FrameInfoQueryResult.ValueInfo illegal = new FrameInfoQueryResult.ValueInfo();
        illegal.type = FrameInfoQueryResult.ValueType.Illegal;
        return illegal;
    }
}

