/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.Target_java_lang_Shutdown;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.ReentrantLock;

@TargetClass(className="java.io.DeleteOnExitHook")
final class Target_java_io_DeleteOnExitHook {
    @Alias
    @InjectAccessors(value=FilesAccessors.class)
    private static LinkedHashSet<String> files;

    Target_java_io_DeleteOnExitHook() {
    }

    @Alias
    static native void runHooks();

    static final class FilesAccessors {
        private static volatile LinkedHashSet<String> injectedFiles = null;
        private static volatile boolean initialized = false;
        private static ReentrantLock lock = new ReentrantLock();

        FilesAccessors() {
        }

        static LinkedHashSet<String> getFiles() {
            FilesAccessors.initializeOnce();
            return injectedFiles;
        }

        static void setFiles(LinkedHashSet<String> value) {
            FilesAccessors.initializeOnce();
            injectedFiles = value;
        }

        static void initializeOnce() {
            block7: {
                if (!initialized) {
                    lock.lock();
                    try {
                        if (initialized) break block7;
                        try {
                            Target_java_lang_Shutdown.add(2, true, new Runnable(){

                                @Override
                                public void run() {
                                    Target_java_io_DeleteOnExitHook.runHooks();
                                }
                            });
                        }
                        catch (InternalError internalError) {
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        injectedFiles = new LinkedHashSet();
                        initialized = true;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

