/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.log.Log;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class SpaceAccounting {
    private long alignedCount;
    private UnsignedWord alignedChunkBytes;
    private long unalignedCount;
    private UnsignedWord unalignedChunkBytes;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    SpaceAccounting() {
        this.reset();
    }

    public void reset() {
        this.alignedCount = 0L;
        this.alignedChunkBytes = (UnsignedWord)WordFactory.zero();
        this.unalignedCount = 0L;
        this.unalignedChunkBytes = (UnsignedWord)WordFactory.zero();
    }

    public UnsignedWord getChunkBytes() {
        return this.getAlignedChunkBytes().add(this.getUnalignedChunkBytes());
    }

    public long getAlignedChunkCount() {
        return this.alignedCount;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getAlignedChunkBytes() {
        return this.alignedChunkBytes;
    }

    public long getUnalignedChunkCount() {
        return this.unalignedCount;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getUnalignedChunkBytes() {
        return this.unalignedChunkBytes;
    }

    void report(Log reportLog) {
        reportLog.string("aligned: ").unsigned((WordBase)this.alignedChunkBytes).string("/").unsigned(this.alignedCount);
        reportLog.string(" ");
        reportLog.string("unaligned: ").unsigned((WordBase)this.unalignedChunkBytes).string("/").unsigned(this.unalignedCount);
    }

    void noteAlignedHeapChunk(AlignedHeapChunk.AlignedHeader chunk) {
        UnsignedWord size = AlignedHeapChunk.getCommittedObjectMemory(chunk);
        ++this.alignedCount;
        this.alignedChunkBytes = this.alignedChunkBytes.add(size);
    }

    void unnoteAlignedHeapChunk(AlignedHeapChunk.AlignedHeader chunk) {
        UnsignedWord size = AlignedHeapChunk.getCommittedObjectMemory(chunk);
        --this.alignedCount;
        this.alignedChunkBytes = this.alignedChunkBytes.subtract(size);
    }

    void noteUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        UnsignedWord size = UnalignedHeapChunk.getCommittedObjectMemory(chunk);
        ++this.unalignedCount;
        this.unalignedChunkBytes = this.unalignedChunkBytes.add(size);
    }

    void unnoteUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        UnsignedWord size = UnalignedHeapChunk.getCommittedObjectMemory(chunk);
        --this.unalignedCount;
        this.unalignedChunkBytes = this.unalignedChunkBytes.subtract(size);
    }
}

