/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import org.graalvm.collections.Pair;

public final class InitKind
extends Enum<InitKind> {
    public static final /* enum */ InitKind BUILD_TIME = new InitKind();
    public static final /* enum */ InitKind RERUN = new InitKind();
    public static final /* enum */ InitKind RUN_TIME = new InitKind();
    public static final String SEPARATOR = ":";
    private static final /* synthetic */ InitKind[] $VALUES;

    public static InitKind[] values() {
        return (InitKind[])$VALUES.clone();
    }

    public static InitKind valueOf(String name) {
        return Enum.valueOf(InitKind.class, name);
    }

    InitKind max(InitKind other) {
        return this.ordinal() > other.ordinal() ? this : other;
    }

    InitKind min(InitKind other) {
        return this.ordinal() < other.ordinal() ? this : other;
    }

    boolean isRunTime() {
        return this.equals((Object)RUN_TIME);
    }

    String suffix() {
        return SEPARATOR + this.name().toLowerCase();
    }

    Consumer<String> stringConsumer(ClassInitializationSupport support) {
        if (this == RUN_TIME) {
            return name -> support.initializeAtRunTime((String)name, "from the command line");
        }
        if (this == RERUN) {
            return name -> support.rerunInitialization((String)name, "from the command line");
        }
        return name -> support.initializeAtBuildTime((String)name, "from the command line");
    }

    static Pair<String, InitKind> strip(String input) {
        Optional<InitKind> it = Arrays.stream(InitKind.values()).filter(x -> input.endsWith(x.suffix())).findAny();
        assert (it.isPresent());
        return Pair.create((Object)input.substring(0, input.length() - it.get().suffix().length()), (Object)((Object)it.get()));
    }

    static {
        $VALUES = new InitKind[]{BUILD_TIME, RERUN, RUN_TIME};
    }
}

