/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.graal.code.SubstrateCompiledCode;
import com.oracle.svm.core.graal.meta.SharedCodeCacheProvider;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.RuntimeCodeInstaller;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.SuppressFBWarnings;

public class SubstrateCodeCacheProvider
extends SharedCodeCacheProvider {
    protected SubstrateCodeCacheProvider(TargetDescription target, RegisterConfig registerConfig) {
        super(target, registerConfig);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="We know what we are doing.")
    public InstalledCode installCode(ResolvedJavaMethod method, CompiledCode compiledCode, InstalledCode predefinedInstalledCode, SpeculationLog log, boolean isDefault) {
        VMError.guarantee(!isDefault);
        SubstrateInstalledCode substrateInstalledCode = predefinedInstalledCode instanceof SubstrateInstalledCode.Access ? ((SubstrateInstalledCode.Access)predefinedInstalledCode).getSubstrateInstalledCode() : (SubstrateInstalledCode)predefinedInstalledCode;
        CompilationResult compResult = ((SubstrateCompiledCode)compiledCode).getCompilationResult();
        RuntimeCodeInstaller.install((SharedRuntimeMethod)method, compResult, substrateInstalledCode);
        return predefinedInstalledCode;
    }
}

