/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.word.Pointer;

public final class AArch64CGlobalDataLoadAddressOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64CGlobalDataLoadAddressOp> TYPE = LIRInstructionClass.create(AArch64CGlobalDataLoadAddressOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private AllocatableValue result;
    private final CGlobalDataInfo dataInfo;

    AArch64CGlobalDataLoadAddressOp(CGlobalDataInfo dataInfo, AllocatableValue result) {
        super(TYPE);
        this.dataInfo = dataInfo;
        this.result = result;
    }

    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        int bits = this.result.getPlatformKind().getSizeInBytes() * 8;
        if (SubstrateUtil.HOSTED) {
            crb.compilationResult.recordDataPatch(masm.position(), (Reference)new CGlobalDataReference(this.dataInfo));
            Register resultRegister = ValueUtil.asRegister((Value)this.result);
            if (this.dataInfo.isSymbolReference()) {
                masm.adrpLdr(64, resultRegister, resultRegister);
            } else {
                masm.adrpAdd(resultRegister);
            }
        } else {
            Pointer globalsBase = CGlobalDataInfo.CGLOBALDATA_RUNTIME_BASE_ADDRESS.get();
            Pointer address = globalsBase.add(this.dataInfo.getOffset());
            masm.mov(ValueUtil.asRegister((Value)this.result), address.rawValue());
            if (this.dataInfo.isSymbolReference()) {
                masm.ldr(bits, ValueUtil.asRegister((Value)this.result), AArch64Address.createBaseRegisterOnlyAddress((Register)ValueUtil.asRegister((Value)this.result)));
            }
        }
    }
}

