/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.AuxiliaryImageHeap;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.HeapPolicyOptions;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ImageHeapWalker;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.PinnedObjectImpl;
import com.oracle.svm.core.genscavenge.RuntimeCodeInfoGCSupportImpl;
import com.oracle.svm.core.genscavenge.StackVerifier;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.genscavenge.graal.SubstrateCardTableBarrierSet;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.heap.RuntimeCodeInfoGCSupport;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.UserError;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.nodes.gc.CardTableBarrierSet;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class HeapImpl
extends Heap {
    private static final VMMutex REF_MUTEX = new VMMutex();
    private static final VMCondition REF_CONDITION = new VMCondition(REF_MUTEX);
    private final YoungGeneration youngGeneration = new YoungGeneration("YoungGeneration");
    private final OldGeneration oldGeneration = new OldGeneration("OldGeneration");
    private final HeapChunkProvider chunkProvider = new HeapChunkProvider();
    private final ObjectHeaderImpl objectHeaderImpl = new ObjectHeaderImpl();
    private final GCImpl gcImpl;
    private final RuntimeCodeInfoGCSupportImpl runtimeCodeInfoGcSupport;
    private final HeapPolicy heapPolicy;
    private final ImageHeapInfo imageHeapInfo = new ImageHeapInfo();
    private HeapVerifier heapVerifier;
    private final StackVerifier stackVerifier;
    private Reference<?> refPendingList;
    private long refListOfferCounter;
    private long refListWaiterWakeUpCounter;
    private final UninterruptibleUtils.AtomicReference<PinnedObjectImpl> pinHead = new UninterruptibleUtils.AtomicReference();
    private List<Class<?>> classList;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapImpl(Feature.FeatureAccess access) {
        this.gcImpl = new GCImpl(access);
        this.runtimeCodeInfoGcSupport = new RuntimeCodeInfoGCSupportImpl();
        this.heapPolicy = new HeapPolicy(access);
        if (HeapImpl.getVerifyHeapBeforeGC() || HeapImpl.getVerifyHeapAfterGC() || HeapImpl.getVerifyStackBeforeGC() || HeapImpl.getVerifyStackAfterGC() || HeapImpl.getVerifyDirtyCardBeforeGC() || HeapImpl.getVerifyDirtyCardAfterGC()) {
            this.heapVerifier = new HeapVerifier();
            this.stackVerifier = new StackVerifier();
        } else {
            this.heapVerifier = null;
            this.stackVerifier = null;
        }
        SubstrateUtil.DiagnosticThunkRegister.getSingleton().register(log -> {
            this.logImageHeapPartitionBoundaries(log).newline();
            HeapImpl.zapValuesToLog(log).newline();
            this.report(log, true).newline();
            log.newline();
        });
    }

    @Fold
    public static HeapImpl getHeapImpl() {
        Heap heap = Heap.getHeap();
        assert (heap instanceof HeapImpl) : "VMConfiguration heap is not a HeapImpl.";
        return (HeapImpl)heap;
    }

    @Fold
    public static ImageHeapInfo getImageHeapInfo() {
        return HeapImpl.getHeapImpl().imageHeapInfo;
    }

    @Fold
    static HeapChunkProvider getChunkProvider() {
        return HeapImpl.getHeapImpl().chunkProvider;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Object obj) {
        return this.isInImageHeap((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Pointer pointer) {
        return this.imageHeapInfo.isInImageHeap(pointer) || AuxiliaryImageHeap.isPresent() && AuxiliaryImageHeap.singleton().containsObject(pointer);
    }

    boolean isInImageHeapSlow(Object obj) {
        return this.isInImageHeapSlow((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isInImageHeapSlow(Pointer p) {
        return this.imageHeapInfo.isInImageHeapSlow(p) || AuxiliaryImageHeap.isPresent() && AuxiliaryImageHeap.singleton().containsObjectSlow(p);
    }

    @Override
    public void suspendAllocation() {
        ThreadLocalAllocation.suspendInCurrentThread();
    }

    @Override
    public void resumeAllocation() {
        ThreadLocalAllocation.resumeInCurrentThread();
    }

    @Override
    public boolean walkObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("must only be executed at a safepoint");
        return this.walkImageHeapObjects(visitor) && this.walkCollectedHeapObjects(visitor);
    }

    boolean walkMemory(MemoryWalker.Visitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("must only be executed at a safepoint");
        return this.walkNativeImageHeapRegions(visitor) && this.getYoungGeneration().walkHeapChunks(visitor) && this.getOldGeneration().walkHeapChunks(visitor) && HeapImpl.getChunkProvider().walkHeapChunks(visitor);
    }

    @Override
    @Uninterruptible(reason="Tear-down in progress.")
    public boolean tearDown() {
        this.youngGeneration.tearDown();
        this.oldGeneration.tearDown();
        HeapImpl.getChunkProvider().tearDown();
        return true;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public ObjectHeader getObjectHeader() {
        return this.objectHeaderImpl;
    }

    ObjectHeaderImpl getObjectHeaderImpl() {
        return this.objectHeaderImpl;
    }

    @Override
    @Fold
    public GC getGC() {
        return this.getGCImpl();
    }

    @Override
    @Fold
    public RuntimeCodeInfoGCSupport getRuntimeCodeInfoGCSupport() {
        return this.runtimeCodeInfoGcSupport;
    }

    GCImpl getGCImpl() {
        return this.gcImpl;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAllocationDisallowed() {
        return NoAllocationVerifier.isActive() || this.gcImpl.isCollectionInProgress();
    }

    static void exitIfAllocationDisallowed(String callSite, String typeName) {
        if (HeapImpl.getHeapImpl().isAllocationDisallowed()) {
            NoAllocationVerifier.exit(callSite, typeName);
        }
    }

    @AlwaysInline(value="GC performance")
    Object promoteObject(Object original, UnsignedWord header) {
        Log trace = Log.noopLog().string("[HeapImpl.promoteObject:").string("  original: ").object(original);
        Object result = HeapPolicy.getMaxSurvivorSpaces() > 0 && !this.getGCImpl().isCompleteCollection() ? this.getYoungGeneration().promoteObject(original, header) : this.getOldGeneration().promoteObject(original, header);
        trace.string("  result: ").object(result).string("]").newline();
        return result;
    }

    @AlwaysInline(value="GC performance")
    void dirtyCardIfNecessary(Object holderObject, Object object) {
        if (HeapPolicy.getMaxSurvivorSpaces() == 0 || holderObject == null || GCImpl.getGCImpl().isCompleteCollection() || !this.youngGeneration.contains(object)) {
            return;
        }
        UnsignedWord objectHeader = ObjectHeaderImpl.readHeaderFromObject(holderObject);
        if (ObjectHeaderImpl.hasRememberedSet(objectHeader)) {
            if (ObjectHeaderImpl.isAlignedObject(holderObject)) {
                AlignedHeapChunk.dirtyCardForObject(holderObject, false);
            } else {
                assert (ObjectHeaderImpl.isUnalignedObject(holderObject)) : "sanity";
                UnalignedHeapChunk.dirtyCardForObject(holderObject, false);
            }
        }
    }

    HeapPolicy getHeapPolicy() {
        return this.heapPolicy;
    }

    YoungGeneration getYoungGeneration() {
        return this.youngGeneration;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    OldGeneration getOldGeneration() {
        return this.oldGeneration;
    }

    UninterruptibleUtils.AtomicReference<PinnedObjectImpl> getPinHead() {
        return this.pinHead;
    }

    @Uninterruptible(reason="Necessary to return a reasonably consistent value (a GC can change the queried values).")
    public UnsignedWord getUsedBytes() {
        return this.getOldGeneration().getChunkBytes().add(HeapPolicy.getYoungUsedBytes());
    }

    @Uninterruptible(reason="Necessary to return a reasonably consistent value (a GC can change the queried values).")
    public UnsignedWord getCommittedBytes() {
        return this.getUsedBytes().add(HeapImpl.getChunkProvider().getBytesInUnusedChunks());
    }

    void report(Log log) {
        this.report(log, HeapPolicyOptions.TraceHeapChunks.getValue());
    }

    Log report(Log log, boolean traceHeapChunks) {
        log.newline().string("[Heap:").indent(true);
        this.getYoungGeneration().report(log, traceHeapChunks).newline();
        this.getOldGeneration().report(log, traceHeapChunks).newline();
        HeapImpl.getChunkProvider().report(log, traceHeapChunks);
        log.redent(false).string("]");
        return log;
    }

    Log logImageHeapPartitionBoundaries(Log log) {
        log.string("[Native image heap boundaries: ").indent(true);
        ImageHeapWalker.logPartitionBoundaries(log, this.imageHeapInfo);
        log.redent(false).string("]");
        return log;
    }

    static Log zapValuesToLog(Log log) {
        if (HeapPolicy.getZapProducedHeapChunks() || HeapPolicy.getZapConsumedHeapChunks()) {
            log.string("[Heap Chunk zap values: ").indent(true);
            if (HeapPolicy.getZapProducedHeapChunks()) {
                log.string("  producedHeapChunkZapInt: ").string("  hex: ").spaces(8).hex(HeapPolicy.getProducedHeapChunkZapInt()).string("  signed: ").spaces(9).signed(HeapPolicy.getProducedHeapChunkZapInt()).string("  unsigned: ").spaces(10).unsigned(HeapPolicy.getProducedHeapChunkZapInt()).newline();
                log.string("  producedHeapChunkZapWord:").string("  hex: ").hex((WordBase)HeapPolicy.getProducedHeapChunkZapWord()).string("  signed: ").signed((WordBase)HeapPolicy.getProducedHeapChunkZapWord()).string("  unsigned: ").unsigned((WordBase)HeapPolicy.getProducedHeapChunkZapWord());
                if (HeapPolicy.getZapConsumedHeapChunks()) {
                    log.newline();
                }
            }
            if (HeapPolicy.getZapConsumedHeapChunks()) {
                log.string("  consumedHeapChunkZapInt: ").string("  hex: ").spaces(8).hex(HeapPolicy.getConsumedHeapChunkZapInt()).string("  signed: ").spaces(10).signed(HeapPolicy.getConsumedHeapChunkZapInt()).string("  unsigned: ").spaces(10).unsigned(HeapPolicy.getConsumedHeapChunkZapInt()).newline();
                log.string("  consumedHeapChunkZapWord:").string("  hex: ").hex((WordBase)HeapPolicy.getConsumedHeapChunkZapWord()).string("  signed: ").signed((WordBase)HeapPolicy.getConsumedHeapChunkZapWord()).string("  unsigned: ").unsigned((WordBase)HeapPolicy.getConsumedHeapChunkZapWord());
            }
            log.redent(false).string("]");
        }
        return log;
    }

    @Override
    public int getClassCount() {
        return this.imageHeapInfo.dynamicHubCount;
    }

    @Override
    public List<Class<?>> getClassList() {
        if (this.classList == null) {
            ArrayList list = new ArrayList(1024);
            ImageHeapWalker.walkRegions(this.imageHeapInfo, new ClassListBuilderVisitor(list));
            this.classList = Collections.unmodifiableList(list);
        }
        assert (this.classList.size() == this.imageHeapInfo.dynamicHubCount);
        return this.classList;
    }

    HeapVerifier getHeapVerifier() {
        return this.heapVerifier;
    }

    void setHeapVerifier(HeapVerifier value) {
        this.heapVerifier = value;
    }

    @Fold
    static boolean getVerifyHeapBeforeGC() {
        return SubstrateGCOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyHeapBeforeCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyHeapAfterGC() {
        return SubstrateGCOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyHeapAfterCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyStackBeforeGC() {
        return SubstrateGCOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyStackBeforeCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyStackAfterGC() {
        return SubstrateGCOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyStackAfterCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyDirtyCardBeforeGC() {
        return SubstrateGCOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyDirtyCardsBeforeCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyDirtyCardAfterGC() {
        return SubstrateGCOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyDirtyCardsAfterCollection.getValue() != false;
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    void verifyBeforeGC(String cause, UnsignedWord epoch) {
        Log trace = Log.noopLog().string("[HeapImpl.verifyBeforeGC:");
        trace.string("  getVerifyHeapBeforeGC(): ").bool(HeapImpl.getVerifyHeapBeforeGC()).string("  heapVerifier: ").object(this.heapVerifier);
        trace.string("  getVerifyStackBeforeGC(): ").bool(HeapImpl.getVerifyStackBeforeGC()).string("  stackVerifier: ").object(this.stackVerifier);
        if (HeapImpl.getVerifyHeapBeforeGC()) {
            assert (this.heapVerifier != null) : "No heap verifier!";
            if (!this.heapVerifier.verifyOperation("before collection", HeapVerifier.Occasion.BEFORE_COLLECTION)) {
                Log.log().string("[HeapImpl.verifyBeforeGC:").string("  cause: ").string(cause).string("  heap fails to verify before epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        if (HeapImpl.getVerifyStackBeforeGC()) {
            assert (this.stackVerifier != null) : "No stack verifier!";
            if (!this.stackVerifier.verifyInAllThreads(KnownIntrinsics.readCallerStackPointer(), "before collection")) {
                Log.log().string("[HeapImpl.verifyBeforeGC:").string("  cause: ").string(cause).string("  stack fails to verify epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        if (HeapImpl.getVerifyDirtyCardBeforeGC()) {
            assert (this.heapVerifier != null) : "No heap verifier!";
            HeapVerifier.verifyDirtyCard(false);
        }
        trace.string("]").newline();
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    void verifyAfterGC(String cause, UnsignedWord epoch) {
        if (HeapImpl.getVerifyHeapAfterGC()) {
            assert (this.heapVerifier != null) : "No heap verifier!";
            if (!this.heapVerifier.verifyOperation("after collection", HeapVerifier.Occasion.AFTER_COLLECTION)) {
                Log.log().string("[HeapImpl.verifyAfterGC:").string("  cause: ").string(cause).string("  heap fails to verify after epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        if (HeapImpl.getVerifyStackAfterGC()) {
            assert (this.stackVerifier != null) : "No stack verifier!";
            if (!this.stackVerifier.verifyInAllThreads(KnownIntrinsics.readCallerStackPointer(), "after collection")) {
                Log.log().string("[HeapImpl.verifyAfterGC:").string("  cause: ").string(cause).string("  stack fails to verify after epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        if (HeapImpl.getVerifyDirtyCardAfterGC()) {
            assert (this.heapVerifier != null) : "No heap verifier!";
            HeapVerifier.verifyDirtyCard(true);
        }
    }

    @Override
    public void prepareForSafepoint() {
    }

    @Override
    public void endSafepoint() {
    }

    @Override
    @Uninterruptible(reason="Called during startup.")
    public void attachThread(IsolateThread isolateThread) {
    }

    @Override
    public void detachThread(IsolateThread isolateThread) {
        ThreadLocalAllocation.disableAndFlushForThread(isolateThread);
    }

    @Fold
    public static boolean usesImageHeapChunks() {
        return HeapImpl.usesImageHeapCardMarking();
    }

    @Fold
    public static boolean usesImageHeapCardMarking() {
        Boolean enabled = HeapOptions.ImageHeapCardMarking.getValue();
        if (enabled == Boolean.FALSE) {
            return false;
        }
        if (enabled == null) {
            return CommittedMemoryProvider.get().guaranteesHeapPreferredAddressSpaceAlignment() && HeapPolicyOptions.MaxSurvivorSpaces.getValue() == 0;
        }
        UserError.guarantee(CommittedMemoryProvider.get().guaranteesHeapPreferredAddressSpaceAlignment(), "Enabling option %s requires a custom image heap alignment at runtime, which cannot be ensured with the current configuration (option %s might be disabled)", new Object[]{HeapOptions.ImageHeapCardMarking, SubstrateOptions.SpawnIsolates});
        UserError.guarantee(HeapPolicyOptions.MaxSurvivorSpaces.getValue() == 0, "Enabling option %s is currently not supported together with non-zero %s", new Object[]{HeapOptions.ImageHeapCardMarking, HeapPolicyOptions.MaxSurvivorSpaces});
        return true;
    }

    @Override
    @Fold
    public int getPreferredAddressSpaceAlignment() {
        if (HeapImpl.usesImageHeapChunks()) {
            return UnsignedUtils.safeToInt(HeapPolicy.getAlignedHeapChunkAlignment());
        }
        return ConfigurationValues.getObjectLayout().getAlignment();
    }

    @Override
    @Fold
    public int getImageHeapOffsetInAddressSpace() {
        return 0;
    }

    @Override
    public boolean walkImageHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("Must only be called at a safepoint");
        if (visitor != null) {
            return ImageHeapWalker.walkImageHeapObjects(this.imageHeapInfo, visitor) && (!AuxiliaryImageHeap.isPresent() || AuxiliaryImageHeap.singleton().walkObjects(visitor));
        }
        return true;
    }

    @Override
    public boolean walkCollectedHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("Must only be called at a safepoint");
        return this.getYoungGeneration().walkObjects(visitor) && this.getOldGeneration().walkObjects(visitor);
    }

    boolean walkNativeImageHeapRegions(MemoryWalker.ImageHeapRegionVisitor visitor) {
        return ImageHeapWalker.walkRegions(this.imageHeapInfo, visitor) && (!AuxiliaryImageHeap.isPresent() || AuxiliaryImageHeap.singleton().walkRegions(visitor));
    }

    public CardTableBarrierSet createBarrierSet(MetaAccessProvider metaAccess) {
        ResolvedJavaType objectArrayType = metaAccess.lookupJavaType(Object[].class);
        return new SubstrateCardTableBarrierSet(objectArrayType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToReferencePendingList(Reference<?> list) {
        VMOperation.guaranteeGCInProgress("Must only be called during a GC.");
        if (list == null) {
            return;
        }
        REF_MUTEX.lock();
        try {
            if (this.refPendingList != null) {
                Reference<?> current = this.refPendingList;
                Reference<?> next = ReferenceInternals.getNextDiscovered(current);
                while (next != null) {
                    current = next;
                    next = ReferenceInternals.getNextDiscovered(current);
                }
                ReferenceInternals.setNextDiscovered(current, list);
            } else {
                this.refPendingList = list;
                ++this.refListOfferCounter;
                REF_CONDITION.broadcast();
            }
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public boolean hasReferencePendingList() {
        REF_MUTEX.lockNoTransition();
        try {
            boolean bl = this.refPendingList != null;
            return bl;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public void waitForReferencePendingList() throws InterruptedException {
        long initialWakeUps;
        long initialOffers;
        REF_MUTEX.lockNoTransition();
        try {
            if (this.refPendingList != null) {
                return;
            }
            initialOffers = this.refListOfferCounter;
            initialWakeUps = this.refListWaiterWakeUpCounter;
        }
        finally {
            REF_MUTEX.unlock();
        }
        HeapImpl.transitionToParkedInNativeThenAwaitPendingRefs(initialOffers, initialWakeUps);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", calleeMustBe=false)
    private static void transitionToParkedInNativeThenAwaitPendingRefs(long initialOffers, long initialWakeUps) throws InterruptedException {
        HeapImpl.doTransitionToParkedInNativeThenAwaitPendingRefs(initialOffers, initialWakeUps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doTransitionToParkedInNativeThenAwaitPendingRefs(long initialOffers, long initialWakeUps) throws InterruptedException {
        Thread currentThread = Thread.currentThread();
        int oldThreadStatus = JavaThreads.getThreadStatus(currentThread);
        JavaThreads.setThreadStatus(currentThread, 657);
        try {
            boolean offered;
            do {
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            } while (!(offered = HeapImpl.transitionToNativeThenAwaitPendingRefs(initialOffers, initialWakeUps)));
        }
        finally {
            JavaThreads.setThreadStatus(currentThread, oldThreadStatus);
        }
    }

    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
    private static boolean transitionToNativeThenAwaitPendingRefs(long initialOffers, long initialWakeUps) {
        CFunctionPrologueNode.cFunctionPrologue(3);
        boolean offered = HeapImpl.awaitPendingRefsInNative(initialOffers, initialWakeUps);
        CFunctionEpilogueNode.cFunctionEpilogue(3);
        return offered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="In native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static boolean awaitPendingRefsInNative(long initialOffers, long initialWakeUps) {
        REF_MUTEX.lockNoTransition();
        try {
            while (HeapImpl.getHeapImpl().refListOfferCounter == initialOffers) {
                REF_CONDITION.blockNoTransition();
                if (HeapImpl.getHeapImpl().refListWaiterWakeUpCounter == initialWakeUps) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public void wakeUpReferencePendingListWaiters() {
        REF_MUTEX.lockNoTransition();
        try {
            ++this.refListWaiterWakeUpCounter;
            REF_CONDITION.broadcast();
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public Reference<?> getAndClearReferencePendingList() {
        REF_MUTEX.lockNoTransition();
        try {
            Reference<?> list = this.refPendingList;
            this.refPendingList = null;
            Reference<?> reference = list;
            return reference;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    private static class ClassListBuilderVisitor
    implements MemoryWalker.ImageHeapRegionVisitor,
    ObjectVisitor {
        private final List<Class<?>> list;

        ClassListBuilderVisitor(List<Class<?>> list) {
            this.list = list;
        }

        @Override
        public <T> boolean visitNativeImageHeapRegion(T region, MemoryWalker.NativeImageHeapRegionAccess<T> access) {
            if (!access.isWritable(region) && access.containsReferences(region)) {
                access.visitObjects(region, this);
            }
            return true;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true, reason="Allocation is fine: this method traverses only the image heap.")
        public boolean visitObject(Object o) {
            if (o instanceof Class) {
                this.list.add(KnownIntrinsics.convertUnknownValue(o, Class.class));
            }
            return true;
        }
    }
}

