/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.aarch64;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.MemoryUtil;
import com.oracle.svm.core.aarch64.AArch64LibCHelper;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;

public class AArch64CPUFeatureAccess
implements CPUFeatureAccess {
    @Platforms(value={Platform.AARCH64.class})
    public static EnumSet<AArch64.CPUFeature> determineHostCPUFeatures() {
        EnumSet<AArch64.CPUFeature> features = EnumSet.noneOf(AArch64.CPUFeature.class);
        AArch64LibCHelper.CPUFeatures cpuFeatures = (AArch64LibCHelper.CPUFeatures)StackValue.get(AArch64LibCHelper.CPUFeatures.class);
        MemoryUtil.fillToMemoryAtomic((Pointer)cpuFeatures, SizeOf.unsigned(AArch64LibCHelper.CPUFeatures.class), (byte)0);
        AArch64LibCHelper.determineCPUFeatures(cpuFeatures);
        if (cpuFeatures.fFP()) {
            features.add(AArch64.CPUFeature.FP);
        }
        if (cpuFeatures.fASIMD()) {
            features.add(AArch64.CPUFeature.ASIMD);
        }
        if (cpuFeatures.fEVTSTRM()) {
            features.add(AArch64.CPUFeature.EVTSTRM);
        }
        if (cpuFeatures.fAES()) {
            features.add(AArch64.CPUFeature.AES);
        }
        if (cpuFeatures.fPMULL()) {
            features.add(AArch64.CPUFeature.PMULL);
        }
        if (cpuFeatures.fSHA1()) {
            features.add(AArch64.CPUFeature.SHA1);
        }
        if (cpuFeatures.fSHA2()) {
            features.add(AArch64.CPUFeature.SHA2);
        }
        if (cpuFeatures.fCRC32()) {
            features.add(AArch64.CPUFeature.CRC32);
        }
        if (cpuFeatures.fLSE()) {
            features.add(AArch64.CPUFeature.LSE);
        }
        if (cpuFeatures.fSTXRPREFETCH()) {
            features.add(AArch64.CPUFeature.STXR_PREFETCH);
        }
        if (cpuFeatures.fA53MAC()) {
            features.add(AArch64.CPUFeature.A53MAC);
        }
        if (cpuFeatures.fDMBATOMICS()) {
            try {
                features.add(AArch64.CPUFeature.valueOf((String)"DMB_ATOMICS"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return features;
    }

    @Override
    public void verifyHostSupportsArchitecture(Architecture imageArchitecture) {
        AArch64 architecture = (AArch64)imageArchitecture;
        EnumSet<AArch64.CPUFeature> features = AArch64CPUFeatureAccess.determineHostCPUFeatures();
        if (!features.containsAll(architecture.getFeatures())) {
            ArrayList<AArch64.CPUFeature> missingFeatures = new ArrayList<AArch64.CPUFeature>();
            for (AArch64.CPUFeature feature : architecture.getFeatures()) {
                if (features.contains(feature)) continue;
                missingFeatures.add(feature);
            }
            throw VMError.shouldNotReachHere("Current target does not support the following CPU features that are required by the image: " + missingFeatures);
        }
    }

    @Override
    public void enableFeatures(Architecture runtimeArchitecture) {
        AArch64 architecture = (AArch64)runtimeArchitecture;
        EnumSet<AArch64.CPUFeature> features = AArch64CPUFeatureAccess.determineHostCPUFeatures();
        architecture.getFeatures().addAll(features);
    }
}

