/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.WeakHashMap;

public final class NativeImageSystemClassLoader
extends SecureClassLoader {
    public final ClassLoader defaultSystemClassLoader;
    private volatile ClassLoader nativeImageClassLoader = null;
    private WeakHashMap<ClassLoader, Boolean> disallowedClassLoaders = new WeakHashMap();
    private static final Method loadClass = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"loadClass", (Class[])new Class[]{String.class, Boolean.TYPE});
    private static final Method findResource = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"findResource", (Class[])new Class[]{String.class});
    private static final Method findResources = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"findResources", (Class[])new Class[]{String.class});

    public NativeImageSystemClassLoader(ClassLoader defaultSystemClassLoader) {
        super(defaultSystemClassLoader);
        this.defaultSystemClassLoader = defaultSystemClassLoader;
    }

    public static NativeImageSystemClassLoader singleton() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (loader instanceof NativeImageSystemClassLoader) {
            return (NativeImageSystemClassLoader)loader;
        }
        throw UserError.abort("NativeImageSystemClassLoader is not the default system class loader. This might create problems when using reflection during class initialization at build-time.To fix this error add -Djava.system.class.loader=%s", NativeImageSystemClassLoader.class.getCanonicalName());
    }

    public void setNativeImageClassLoader(ClassLoader nativeImageClassLoader) {
        if (nativeImageClassLoader == null && this.nativeImageClassLoader != null) {
            this.disallowedClassLoaders.put(this.nativeImageClassLoader, Boolean.TRUE);
        }
        this.nativeImageClassLoader = nativeImageClassLoader;
    }

    public ClassLoader getNativeImageClassLoader() {
        return this.nativeImageClassLoader;
    }

    public boolean isNativeImageClassLoader(ClassLoader c) {
        ClassLoader loader = this.nativeImageClassLoader;
        if (loader == null) {
            return false;
        }
        return c == loader;
    }

    public boolean isDisallowedClassLoader(ClassLoader c) {
        return this.disallowedClassLoaders.containsKey(c);
    }

    static Class<?> loadClass(ClassLoader classLoader, String name, boolean resolve) throws ClassNotFoundException {
        Class loadedClass = null;
        try {
            loadedClass = (Class)loadClass.invoke((Object)classLoader, name, resolve);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getCause();
            }
            String message = String.format("Can not load class: %s, with class loader: %s", name, classLoader);
            VMError.shouldNotReachHere(message, e);
        }
        return loadedClass;
    }

    static URL findResource(ClassLoader classLoader, String name) {
        try {
            return (URL)findResource.invoke((Object)classLoader, name);
        }
        catch (ReflectiveOperationException e) {
            String message = String.format("Can not find resource: %s using class loader: %s", name, classLoader);
            VMError.shouldNotReachHere(message, e);
            return null;
        }
    }

    static Enumeration<URL> findResources(ClassLoader classLoader, String name) {
        try {
            return (Enumeration)findResources.invoke((Object)classLoader, name);
        }
        catch (ReflectiveOperationException e) {
            String message = String.format("Can not find resources: %s using class loader: %s", name, classLoader);
            VMError.shouldNotReachHere(message, e);
            return null;
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return NativeImageSystemClassLoader.loadClass(this.getActiveClassLoader(), name, resolve);
    }

    @Override
    protected URL findResource(String name) {
        return NativeImageSystemClassLoader.findResource(this.getActiveClassLoader(), name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return NativeImageSystemClassLoader.findResources(this.getActiveClassLoader(), name);
    }

    public String toString() {
        String clString = super.toString();
        return clString + " {delegate=" + this.nativeImageClassLoader + ", defaultSystemClassLoader=" + this.defaultSystemClassLoader + '}';
    }

    private ClassLoader getActiveClassLoader() {
        ClassLoader delegate = this.nativeImageClassLoader;
        return delegate != null ? delegate : this.defaultSystemClassLoader;
    }

    private void appendToClassPathForInstrumentation(String classPathEntry) {
        try {
            Method method = ReflectionUtil.lookupMethod(this.getParent().getClass(), (String)"appendToClassPathForInstrumentation", (Class[])new Class[]{String.class});
            method.invoke((Object)this.getParent(), classPathEntry);
        }
        catch (ReflectiveOperationException e) {
            String message = String.format("Can not add jar: %s to class path. Due to %s", classPathEntry, e);
            VMError.shouldNotReachHere(message, e);
        }
    }
}

