/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.reflect.hosted.AccessorComputer;
import com.oracle.svm.reflect.hosted.FieldOffsetComputer;
import com.oracle.svm.reflect.target.ReflectionHelper;
import com.oracle.svm.reflect.target.Target_jdk_internal_reflect_FieldAccessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.util.Map;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import sun.reflect.generics.repository.FieldRepository;

@TargetClass(value=Field.class)
public final class Target_java_lang_reflect_Field {
    @Alias
    FieldRepository genericInfo;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AccessorComputer.class)
    Target_jdk_internal_reflect_FieldAccessor fieldAccessor;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AccessorComputer.class)
    Target_jdk_internal_reflect_FieldAccessor overrideFieldAccessor;
    @Alias
    Map<Class<? extends Annotation>, Annotation> declaredAnnotations;
    @Alias
    Target_java_lang_reflect_Field root;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=FieldOffsetComputer.class)
    int offset;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotatedTypeComputer.class)
    AnnotatedType annotatedType;

    @Alias
    native Target_java_lang_reflect_Field copy();

    @Substitute
    public Target_jdk_internal_reflect_FieldAccessor acquireFieldAccessor(boolean overrideFinalCheck) {
        if (this.fieldAccessor == null) {
            throw VMError.unsupportedFeature("Runtime reflection is not supported.");
        }
        return this.fieldAccessor;
    }

    @Substitute
    Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        Target_java_lang_reflect_Field holder = ReflectionHelper.getHolder(this);
        return ReflectionHelper.requireNonNull(holder.declaredAnnotations, "Declared annotations must be computed during native image generation.");
    }

    @Substitute
    public AnnotatedType getAnnotatedType() {
        Target_java_lang_reflect_Field holder = ReflectionHelper.getHolder(this);
        return ReflectionHelper.requireNonNull(holder.annotatedType, "Annotated type must be computed during native image generation.");
    }

    public static final class AnnotatedTypeComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Field field = (Field)receiver;
            return field.getAnnotatedType();
        }
    }
}

