/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.methodhandles;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.hosted.NativeImageOptions;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Executable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
public class MethodHandleFeature
implements Feature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return NativeImageOptions.areMethodHandlesSupported();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerReachabilityHandler(duringAccess -> {
            try {
                RuntimeReflection.register((Class[])new Class[]{MethodHandle.class});
                RuntimeReflection.register((Executable[])new Executable[]{MethodHandle.class.getDeclaredMethod("invokeBasic", Object[].class)});
                RuntimeReflection.register((Executable[])new Executable[]{MethodHandle.class.getDeclaredMethod("linkToVirtual", Object[].class)});
                RuntimeReflection.register((Executable[])new Executable[]{MethodHandle.class.getDeclaredMethod("linkToStatic", Object[].class)});
            }
            catch (NoSuchMethodException e) {
                throw new GraalError((Throwable)e);
            }
        }, new Object[]{MethodHandle.class});
    }
}

