/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.hosted.substitute.DeletedElementException;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;

public class SubstitutionReflectivityFilter {
    public static boolean shouldExclude(Class<?> classObj, AnalysisMetaAccess metaAccess) {
        try {
            AnalysisType analysisClass = metaAccess.lookupJavaType(classObj);
            if (analysisClass.isAnnotationPresent(Delete.class)) {
                return true;
            }
        }
        catch (DeletedElementException ignored) {
            return true;
        }
        return false;
    }

    public static boolean shouldExclude(Executable method, AnalysisMetaAccess metaAccess) {
        try {
            AnalysisMethod aMethod = metaAccess.lookupJavaMethod(method);
            if (aMethod.isAnnotationPresent(Delete.class)) {
                return true;
            }
            if (aMethod.isSynthetic() && aMethod.getDeclaringClass().isAnnotationPresent(TargetClass.class)) {
                return true;
            }
        }
        catch (DeletedElementException ignored) {
            return true;
        }
        return false;
    }

    public static boolean shouldExclude(Field field, AnalysisMetaAccess metaAccess) {
        try {
            AnalysisField aField = metaAccess.lookupJavaField(field);
            if (aField.isAnnotationPresent(Delete.class)) {
                return true;
            }
        }
        catch (DeletedElementException ignored) {
            return true;
        }
        return false;
    }
}

