/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.graal.nodes.DeadEndNode;
import com.oracle.svm.core.graal.phases.TrustedInterfaceTypePlugin;
import com.oracle.svm.core.graal.word.SubstrateWordTypes;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.NativeImageUtil;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.phases.NoClassInitializationPlugin;
import com.oracle.svm.hosted.phases.SubstrateClassInitializationPlugin;
import com.oracle.svm.hosted.snippets.IntrinsificationPluginRegistry;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.StreamSupport;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ArithmeticOperation;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.TypePlugin;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.MethodHandlePlugin;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.WordOperationPlugin;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.ImageSingletons;

public class IntrinsifyMethodHandlesInvocationPlugin
implements NodePlugin {
    private final boolean analysis;
    private final Providers parsingProviders;
    private final Providers universeProviders;
    private final AnalysisUniverse aUniverse;
    private final HostedUniverse hUniverse;
    private final ClassInitializationPlugin classInitializationPlugin;
    private final IntrinsificationRegistry intrinsificationRegistry;
    private final ResolvedJavaType methodHandleType;
    private final Set<String> methodHandleInvokeMethodNames;
    private final Class<?> varHandleClass;
    private final ResolvedJavaType varHandleType;
    private final Field varHandleVFormField;
    private final Method varFormInitMethod;
    private static final Method unsupportedFeatureMethod = ReflectionUtil.lookupMethod(VMError.class, (String)"unsupportedFeature", (Class[])new Class[]{String.class});

    public IntrinsifyMethodHandlesInvocationPlugin(boolean analysis, Providers providers, AnalysisUniverse aUniverse, HostedUniverse hUniverse) {
        this.analysis = analysis;
        this.aUniverse = aUniverse;
        this.hUniverse = hUniverse;
        this.universeProviders = providers;
        Providers originalProviders = GraalAccess.getOriginalProviders();
        this.parsingProviders = new Providers(originalProviders).copyWith((MetaAccessExtensionProvider)new MethodHandlesMetaAccessExtensionProvider());
        this.classInitializationPlugin = new SubstrateClassInitializationPlugin((SVMHost)aUniverse.hostVM());
        if (analysis) {
            this.intrinsificationRegistry = new IntrinsificationRegistry();
            ImageSingletons.add(IntrinsificationRegistry.class, (Object)this.intrinsificationRegistry);
        } else {
            this.intrinsificationRegistry = (IntrinsificationRegistry)ImageSingletons.lookup(IntrinsificationRegistry.class);
        }
        this.methodHandleType = this.universeProviders.getMetaAccess().lookupJavaType(MethodHandle.class);
        this.methodHandleInvokeMethodNames = new HashSet<String>(Arrays.asList("invokeExact", "invoke", "invokeBasic", "linkToVirtual", "linkToStatic", "linkToSpecial", "linkToInterface"));
        if (NativeImageOptions.areMethodHandlesSupported()) {
            this.methodHandleInvokeMethodNames.remove("invokeBasic");
        }
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            try {
                this.varHandleClass = Class.forName("java.lang.invoke.VarHandle");
                this.varHandleType = this.universeProviders.getMetaAccess().lookupJavaType(this.varHandleClass);
                this.varHandleVFormField = ReflectionUtil.lookupField(this.varHandleClass, (String)"vform");
                Class<?> varFormClass = Class.forName("java.lang.invoke.VarForm");
                this.varFormInitMethod = ReflectionUtil.lookupMethod(varFormClass, (String)"getMethodType_V", (Class[])new Class[]{Integer.TYPE});
            }
            catch (ClassNotFoundException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        } else {
            this.varHandleClass = null;
            this.varHandleType = null;
            this.varHandleVFormField = null;
            this.varFormInitMethod = null;
        }
    }

    public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        if (b.getInvokeKind().isDirect() && (IntrinsifyMethodHandlesInvocationPlugin.hasMethodHandleArgument(args) || this.isVarHandleMethod(method, args))) {
            this.processInvokeWithMethodHandle(b, this.universeProviders.getReplacements(), method, args);
            return true;
        }
        if (this.methodHandleType.equals(method.getDeclaringClass()) && this.methodHandleInvokeMethodNames.contains(method.getName())) {
            IntrinsifyMethodHandlesInvocationPlugin.reportUnsupportedFeature(b, method);
            return true;
        }
        return false;
    }

    private static boolean hasMethodHandleArgument(ValueNode[] args) {
        for (ValueNode argument : args) {
            if (!argument.isConstant() || argument.getStackKind() != JavaKind.Object || !(SubstrateObjectConstant.asObject((Constant)argument.asJavaConstant()) instanceof MethodHandle)) continue;
            return true;
        }
        return false;
    }

    private boolean isVarHandleMethod(ResolvedJavaMethod method, ValueNode[] args) {
        if (method.getDeclaringClass().toJavaName(true).equals("java.lang.invoke.VarHandleGuards")) {
            if (args.length < 1 || !args[0].isJavaConstant() || !this.isVarHandle(args[0])) {
                throw new UnsupportedFeatureException("VarHandle object must be a compile time constant");
            }
            try {
                Object varHandle = SubstrateObjectConstant.asObject((Constant)args[0].asJavaConstant());
                Object varForm = this.varHandleVFormField.get(varHandle);
                this.varFormInitMethod.invoke(varForm, 0);
            }
            catch (ReflectiveOperationException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
            return true;
        }
        return false;
    }

    private boolean isVarHandle(ValueNode arg) {
        return this.varHandleType.isAssignableFrom(this.universeProviders.getMetaAccess().lookupJavaType(arg.asJavaConstant()));
    }

    private static void registerInvocationPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.invoke.DirectMethodHandle", replacements);
        r.register1("ensureInitialized", InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                return true;
            }
        });
        r = new InvocationPlugins.Registration(plugins, "java.lang.invoke.Invokers", replacements);
        r.registerOptional1("maybeCustomize", MethodHandle.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode mh) {
                return true;
            }
        });
        r = new InvocationPlugins.Registration(plugins, Objects.class, replacements);
        r.register1("requireNonNull", Object.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode object) {
                b.push(JavaKind.Object, b.addNonNullCast(object));
                return true;
            }
        });
    }

    private void processInvokeWithMethodHandle(GraphBuilderContext b, Replacements replacements, ResolvedJavaMethod methodHandleMethod, ValueNode[] methodHandleArguments) {
        if (!this.analysis && this.intrinsificationRegistry.get(b.getMethod(), b.bci()) != Boolean.TRUE) {
            IntrinsifyMethodHandlesInvocationPlugin.reportUnsupportedFeature(b, methodHandleMethod);
            return;
        }
        GraphBuilderConfiguration.Plugins graphBuilderPlugins = new GraphBuilderConfiguration.Plugins(this.parsingProviders.getReplacements().getGraphBuilderPlugins());
        IntrinsifyMethodHandlesInvocationPlugin.registerInvocationPlugins(graphBuilderPlugins.getInvocationPlugins(), replacements);
        graphBuilderPlugins.prependParameterPlugin((ParameterPlugin)new MethodHandlesParameterPlugin(methodHandleArguments));
        graphBuilderPlugins.clearInlineInvokePlugins();
        graphBuilderPlugins.prependInlineInvokePlugin((InlineInvokePlugin)new MethodHandlesInlineInvokePlugin());
        graphBuilderPlugins.prependNodePlugin((NodePlugin)new MethodHandlePlugin(this.parsingProviders.getConstantReflection().getMethodHandleAccess(), false));
        SnippetReflectionProvider originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
        WordOperationPlugin wordOperationPlugin = new WordOperationPlugin(originalSnippetReflection, (WordTypes)new SubstrateWordTypes(this.parsingProviders.getMetaAccess(), FrameAccess.getWordKind()));
        graphBuilderPlugins.appendInlineInvokePlugin((InlineInvokePlugin)wordOperationPlugin);
        graphBuilderPlugins.appendTypePlugin((TypePlugin)wordOperationPlugin);
        graphBuilderPlugins.appendTypePlugin((TypePlugin)new TrustedInterfaceTypePlugin());
        graphBuilderPlugins.appendNodePlugin((NodePlugin)wordOperationPlugin);
        graphBuilderPlugins.setClassInitializationPlugin((ClassInitializationPlugin)new NoClassInitializationPlugin());
        GraphBuilderConfiguration graphBuilderConfig = GraphBuilderConfiguration.getSnippetDefault((GraphBuilderConfiguration.Plugins)graphBuilderPlugins);
        GraphBuilderPhase.Instance graphBuilder = new GraphBuilderPhase.Instance((CoreProviders)this.parsingProviders, graphBuilderConfig, OptimisticOptimizations.NONE, null);
        DebugContext debug = b.getDebug();
        StructuredGraph graph = new StructuredGraph.Builder(b.getOptions(), debug).method(NativeImageUtil.toOriginal(methodHandleMethod)).build();
        try (DebugContext.Scope s = debug.scope((Object)"IntrinsifyMethodHandles", (Object)graph);){
            graphBuilder.apply(graph);
            CanonicalizerPhase.create().apply(graph, (Object)this.parsingProviders);
            debug.dump(3, (Object)graph, "Intrinisfication graph before transplant");
            NodeMap transplanted = new NodeMap((Graph)graph);
            for (ParameterNode oParam : graph.getNodes(ParameterNode.TYPE)) {
                transplanted.put((Node)oParam, (Object)methodHandleArguments[oParam.index()]);
            }
            Transplanter transplanter = new Transplanter(b, methodHandleMethod, (NodeMap<Node>)transplanted);
            try {
                transplanter.graph(graph);
                if (this.analysis) {
                    this.intrinsificationRegistry.add(b.getMethod(), b.bci(), Boolean.TRUE);
                }
            }
            catch (AbortTransplantException abortTransplantException) {
                // empty catch block
            }
        }
        catch (Throwable ex) {
            throw debug.handle(ex);
        }
    }

    private static void reportUnsupportedFeature(GraphBuilderContext b, ResolvedJavaMethod methodHandleMethod) {
        String message = "Invoke with MethodHandle argument could not be reduced to at most a single call or single field access. The method handle must be a compile time constant, e.g., be loaded from a `static final` field. Method that contains the method handle invocation: " + methodHandleMethod.format("%H.%n(%p)");
        if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
            ((BytecodeParser)b).getFrameStateBuilder().clearStack();
            b.handleReplacedInvoke(CallTargetNode.InvokeKind.Static, b.getMetaAccess().lookupJavaMethod((Executable)unsupportedFeatureMethod), new ValueNode[]{ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(message), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph())}, false);
            b.append((ValueNode)new DeadEndNode());
            return;
        }
        throw new UnsupportedFeatureException(message + System.lineSeparator() + "To enable method handles that do not require LambdaForm interpretation (e.g. because of a call to MethodHandle.bindTo()) or to diagnose the issue, you can add the option " + SubstrateOptionsParser.commandArgument(NativeImageOptions.ReportUnsupportedElementsAtRuntime, "+") + ". The error is then reported at run time when the invoke is executed and the method handle has to be interpreted.");
    }

    private void maybeEmitClassInitialization(GraphBuilderContext b, boolean isStatic, ResolvedJavaType declaringClass) {
        if (isStatic) {
            this.classInitializationPlugin.apply(b, declaringClass, () -> ((BytecodeParser)b).getFrameStateBuilder().create(b.bci(), (BytecodeParser)b.getNonIntrinsicAncestor(), false, null, null));
        }
    }

    private ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        Object result = this.aUniverse.lookup((JavaMethod)method);
        if (this.hUniverse != null) {
            result = this.hUniverse.lookup((JavaMethod)result);
        }
        return result;
    }

    private ResolvedJavaField lookup(ResolvedJavaField field) {
        this.aUniverse.lookup((JavaType)field.getDeclaringClass()).registerAsReachable();
        Object result = this.aUniverse.lookup((JavaField)field);
        if (this.hUniverse != null) {
            result = this.hUniverse.lookup((JavaField)result);
        }
        return result;
    }

    private ResolvedJavaType lookup(ResolvedJavaType type) {
        Object result = this.aUniverse.lookup((JavaType)type);
        if (this.hUniverse != null) {
            result = this.hUniverse.lookup((JavaType)result);
        }
        return result;
    }

    private ResolvedJavaType optionalLookup(ResolvedJavaType type) {
        Object result = this.aUniverse.optionalLookup(type);
        if (result != null && this.hUniverse != null) {
            result = this.hUniverse.optionalLookup((JavaType)result);
        }
        return result;
    }

    private JavaConstant lookup(JavaConstant constant) {
        return this.aUniverse.lookup(constant);
    }

    private JavaConstant toOriginal(JavaConstant constant) {
        return this.aUniverse.toHosted(constant);
    }

    static class AbortTransplantException
    extends Exception {
        AbortTransplantException() {
        }
    }

    class Transplanter {
        private final BytecodeParser b;
        private final ResolvedJavaMethod methodHandleMethod;
        private final NodeMap<Node> transplanted;

        Transplanter(GraphBuilderContext b, ResolvedJavaMethod methodHandleMethod, NodeMap<Node> transplanted) {
            this.b = (BytecodeParser)b;
            this.methodHandleMethod = methodHandleMethod;
            this.transplanted = transplanted;
        }

        void graph(StructuredGraph graph) throws AbortTransplantException {
            JavaKind returnResultKind = this.b.getInvokeReturnType().getJavaKind().getStackKind();
            FixedNode oNode = graph.start().next();
            while (this.fixedWithNextNode(oNode)) {
                oNode = ((FixedWithNextNode)oNode).next();
            }
            if (oNode instanceof ReturnNode) {
                ReturnNode oReturn = (ReturnNode)oNode;
                if (returnResultKind != JavaKind.Void) {
                    this.b.push(returnResultKind, this.node((Node)oReturn.result()));
                }
                return;
            }
            throw this.bailout();
        }

        private boolean fixedWithNextNode(FixedNode oNode) throws AbortTransplantException {
            if (oNode.getClass() == InvokeNode.class) {
                InvokeNode oInvoke = (InvokeNode)oNode;
                MethodCallTargetNode oCallTarget = (MethodCallTargetNode)oInvoke.callTarget();
                ResolvedJavaMethod tTargetMethod = IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oCallTarget.targetMethod());
                IntrinsifyMethodHandlesInvocationPlugin.this.maybeEmitClassInitialization((GraphBuilderContext)this.b, oCallTarget.invokeKind() == CallTargetNode.InvokeKind.Static, tTargetMethod.getDeclaringClass());
                this.b.handleReplacedInvoke(oCallTarget.invokeKind(), tTargetMethod, this.nodes((List<ValueNode>)oCallTarget.arguments()), false);
                JavaKind invokeResultKind = oInvoke.getStackKind();
                if (invokeResultKind != JavaKind.Void) {
                    this.transplanted.put((Node)oInvoke, (Object)this.b.pop(invokeResultKind));
                }
                return true;
            }
            if (oNode.getClass() == FixedGuardNode.class) {
                ValueNode[] tExceptionArguments;
                BytecodeExceptionNode.BytecodeExceptionKind tExceptionKind;
                FixedGuardNode oGuard = (FixedGuardNode)oNode;
                if (oGuard.getReason() == DeoptimizationReason.NullCheckException) {
                    tExceptionKind = BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER;
                    tExceptionArguments = new ValueNode[]{};
                } else if (oGuard.getReason() == DeoptimizationReason.ClassCastException && oGuard.condition().getClass() == InstanceOfNode.class) {
                    InstanceOfNode oCondition = (InstanceOfNode)oGuard.condition();
                    tExceptionKind = BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST;
                    tExceptionArguments = new ValueNode[]{this.node((Node)oCondition.getValue()), ConstantNode.forConstant((JavaConstant)this.b.getConstantReflection().asJavaClass(IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oCondition.type().getType())), (MetaAccessProvider)this.b.getMetaAccess(), (StructuredGraph)this.b.getGraph())};
                } else {
                    return false;
                }
                AbstractBeginNode tPassingSuccessor = this.b.emitBytecodeExceptionCheck((LogicNode)this.node((Node)oGuard.condition()), !oGuard.isNegated(), tExceptionKind, tExceptionArguments);
                this.transplanted.put((Node)oGuard, tPassingSuccessor != null ? tPassingSuccessor : this.b.add((ValueNode)new BeginNode()));
                return true;
            }
            if (oNode.getClass() == LoadFieldNode.class) {
                LoadFieldNode oLoad = (LoadFieldNode)oNode;
                ResolvedJavaField tTarget = IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oLoad.field());
                IntrinsifyMethodHandlesInvocationPlugin.this.maybeEmitClassInitialization((GraphBuilderContext)this.b, tTarget.isStatic(), tTarget.getDeclaringClass());
                ValueNode tLoad = this.b.add((ValueNode)LoadFieldNode.create(null, (ValueNode)this.node((Node)oLoad.object()), (ResolvedJavaField)tTarget));
                this.transplanted.put((Node)oLoad, (Object)tLoad);
                return true;
            }
            if (oNode.getClass() == StoreFieldNode.class) {
                StoreFieldNode oStore = (StoreFieldNode)oNode;
                ResolvedJavaField tTarget = IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oStore.field());
                IntrinsifyMethodHandlesInvocationPlugin.this.maybeEmitClassInitialization((GraphBuilderContext)this.b, tTarget.isStatic(), tTarget.getDeclaringClass());
                this.b.add((ValueNode)new StoreFieldNode(this.node((Node)oStore.object()), tTarget, this.node((Node)oStore.value())));
                return true;
            }
            if (oNode.getClass() == NewInstanceNode.class) {
                NewInstanceNode oNew = (NewInstanceNode)oNode;
                ResolvedJavaType tInstanceClass = IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oNew.instanceClass());
                IntrinsifyMethodHandlesInvocationPlugin.this.maybeEmitClassInitialization((GraphBuilderContext)this.b, true, tInstanceClass);
                NewInstanceNode tNew = (NewInstanceNode)this.b.add((ValueNode)new NewInstanceNode(tInstanceClass, oNew.fillContents()));
                this.transplanted.put((Node)oNew, (Object)tNew);
                return true;
            }
            if (oNode.getClass() == NewArrayNode.class) {
                NewArrayNode oNew = (NewArrayNode)oNode;
                NewArrayNode tNew = (NewArrayNode)this.b.add((ValueNode)new NewArrayNode(IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oNew.elementType()), this.node((Node)oNew.length()), oNew.fillContents()));
                this.transplanted.put((Node)oNew, (Object)tNew);
                return true;
            }
            return false;
        }

        private ValueNode[] nodes(List<ValueNode> oNodes) throws AbortTransplantException {
            ValueNode[] tNodes = new ValueNode[oNodes.size()];
            for (int i = 0; i < tNodes.length; ++i) {
                tNodes[i] = this.node((Node)oNodes.get(i));
            }
            return tNodes;
        }

        private ValueNode node(Node oNode) throws AbortTransplantException {
            if (oNode == null) {
                return null;
            }
            Node tNode = (Node)this.transplanted.get(oNode);
            if (tNode != null) {
                return (ValueNode)tNode;
            }
            if (oNode.getClass() == ConstantNode.class) {
                ConstantNode oConstant = (ConstantNode)oNode;
                tNode = ConstantNode.forConstant((JavaConstant)this.constant(oConstant.getValue()), (MetaAccessProvider)IntrinsifyMethodHandlesInvocationPlugin.this.universeProviders.getMetaAccess());
            } else if (oNode.getClass() == PiNode.class) {
                PiNode oPi = (PiNode)oNode;
                tNode = new PiNode(this.node((Node)oPi.object()), this.stamp(oPi.piStamp()), this.node((Node)oPi.getGuard().asNode()));
            } else if (oNode.getClass() == InstanceOfNode.class) {
                InstanceOfNode oInstanceOf = (InstanceOfNode)oNode;
                tNode = InstanceOfNode.createHelper((ObjectStamp)this.stamp(oInstanceOf.getCheckedStamp()), (ValueNode)this.node((Node)oInstanceOf.getValue()), (JavaTypeProfile)oInstanceOf.profile(), (AnchoringNode)((AnchoringNode)this.node((Node)((ValueNode)oInstanceOf.getAnchor()))));
            } else if (oNode.getClass() == IsNullNode.class) {
                IsNullNode oIsNull = (IsNullNode)oNode;
                tNode = IsNullNode.create((ValueNode)this.node((Node)oIsNull.getValue()));
            } else if (oNode instanceof ArithmeticOperation) {
                for (Node input : oNode.inputs()) {
                    this.node(input);
                }
                List<Node> oNodes = Collections.singletonList(oNode);
                UnmodifiableEconomicMap tNodes = this.b.getGraph().addDuplicates(oNodes, oNode.graph(), 1, this.transplanted);
                assert (StreamSupport.stream(tNodes.getKeys().spliterator(), false).count() == 1L);
                tNode = (Node)tNodes.get((Object)oNode);
            } else {
                throw this.bailout();
            }
            tNode = this.b.add((ValueNode)tNode);
            assert (tNode.verify());
            this.transplanted.put(oNode, (Object)tNode);
            return (ValueNode)tNode;
        }

        private <T extends Stamp> T stamp(T oStamp) throws AbortTransplantException {
            Object result;
            if (oStamp.getClass() == ObjectStamp.class) {
                ObjectStamp oObjectStamp = (ObjectStamp)oStamp;
                result = new ObjectStamp(IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oObjectStamp.type()), oObjectStamp.isExactType(), oObjectStamp.nonNull(), oObjectStamp.alwaysNull());
            } else if (oStamp instanceof PrimitiveStamp) {
                result = oStamp;
            } else {
                throw this.bailout();
            }
            assert (oStamp.getClass() == result.getClass());
            return result;
        }

        private JavaConstant constant(Constant oConstant) throws AbortTransplantException {
            if (oConstant == JavaConstant.NULL_POINTER) {
                return JavaConstant.NULL_POINTER;
            }
            if (!(oConstant instanceof JavaConstant)) {
                throw this.bailout();
            }
            JavaConstant tConstant = IntrinsifyMethodHandlesInvocationPlugin.this.lookup((JavaConstant)oConstant);
            if (tConstant.getJavaKind() == JavaKind.Object) {
                Object oldObject = IntrinsifyMethodHandlesInvocationPlugin.this.aUniverse.getSnippetReflection().asObject(Object.class, tConstant);
                Object newObject = IntrinsifyMethodHandlesInvocationPlugin.this.aUniverse.replaceObject(oldObject);
                if (newObject != oldObject) {
                    return IntrinsifyMethodHandlesInvocationPlugin.this.aUniverse.getSnippetReflection().forObject(newObject);
                }
            }
            return tConstant;
        }

        private RuntimeException bailout() throws AbortTransplantException {
            IntrinsifyMethodHandlesInvocationPlugin.reportUnsupportedFeature((GraphBuilderContext)this.b, this.methodHandleMethod);
            throw new AbortTransplantException();
        }
    }

    class MethodHandlesMetaAccessExtensionProvider
    implements MetaAccessExtensionProvider {
        MethodHandlesMetaAccessExtensionProvider() {
        }

        public JavaKind getStorageKind(JavaType type) {
            throw VMError.shouldNotReachHere("storage kind information is only needed for optimization phases not used by the method handle intrinsification");
        }

        public boolean canConstantFoldDynamicAllocation(ResolvedJavaType type) {
            if (IntrinsifyMethodHandlesInvocationPlugin.this.hUniverse == null) {
                return true;
            }
            ResolvedJavaType convertedType = IntrinsifyMethodHandlesInvocationPlugin.this.optionalLookup(type);
            return convertedType != null && ((HostedType)convertedType).isInstantiated();
        }

        public boolean isGuaranteedSafepoint(ResolvedJavaMethod method, boolean isDirect) {
            throw VMError.shouldNotReachHere();
        }
    }

    class MethodHandlesInlineInvokePlugin
    implements InlineInvokePlugin {
        MethodHandlesInlineInvokePlugin() {
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            if (b.getDepth() > 20) {
                return null;
            }
            String className = method.getDeclaringClass().toJavaName(true);
            if (className.startsWith("java.lang.invoke.VarHandle") && !className.equals("java.lang.invoke.VarHandle")) {
                return null;
            }
            if (className.startsWith("java.lang.invoke")) {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)method);
            }
            return null;
        }
    }

    class MethodHandlesParameterPlugin
    implements ParameterPlugin {
        private final ValueNode[] methodHandleArguments;

        MethodHandlesParameterPlugin(ValueNode[] methodHandleArguments) {
            this.methodHandleArguments = methodHandleArguments;
        }

        public FloatingNode interceptParameter(GraphBuilderTool b, int index, StampPair stamp) {
            if (this.methodHandleArguments[index].isConstant()) {
                return ConstantNode.forConstant((JavaConstant)IntrinsifyMethodHandlesInvocationPlugin.this.toOriginal(this.methodHandleArguments[index].asJavaConstant()), (MetaAccessProvider)IntrinsifyMethodHandlesInvocationPlugin.this.parsingProviders.getMetaAccess());
            }
            Stamp argStamp = this.methodHandleArguments[index].stamp(NodeView.DEFAULT);
            ResolvedJavaType argType = StampTool.typeOrNull((Stamp)argStamp);
            if (argType != null) {
                TypeReference typeref = TypeReference.createWithoutAssumptions((ResolvedJavaType)NativeImageUtil.toOriginal(argType));
                argStamp = StampTool.isPointerNonNull((Stamp)argStamp) ? StampFactory.objectNonNull((TypeReference)typeref) : StampFactory.object((TypeReference)typeref);
            }
            return new ParameterNode(index, StampPair.createSingle((Stamp)argStamp));
        }
    }

    static class IntrinsificationRegistry
    extends IntrinsificationPluginRegistry {
        IntrinsificationRegistry() {
        }
    }
}

