/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.svm.hosted.classinitialization.ClassInitalizerHasSideEffectsException;
import com.oracle.svm.hosted.phases.NoClassInitializationPlugin;
import java.util.function.Supplier;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;

class AbortOnUnitializedClassPlugin
extends NoClassInitializationPlugin {
    AbortOnUnitializedClassPlugin() {
    }

    @Override
    public boolean apply(GraphBuilderContext b, ResolvedJavaType type, Supplier<FrameState> frameState, ValueNode[] classInit) {
        ResolvedJavaMethod clinitMethod = b.getGraph().method();
        if (!(type.isInitialized() || type.isArray() || type.equals(clinitMethod.getDeclaringClass()))) {
            throw new ClassInitalizerHasSideEffectsException("Reference of class that is not initialized: " + type.toJavaName(true));
        }
        return false;
    }
}

