/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.CErrorNumber;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.posix.headers.Dlfcn;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Locale;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.Wait;
import com.oracle.svm.core.posix.linux.libc.GLibC;
import com.oracle.svm.core.util.VMError;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.function.Function;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class PosixUtils {
    static String setLocale(String category, String locale) {
        int intCategory = PosixUtils.getCategory(category);
        return PosixUtils.setLocale(intCategory, locale);
    }

    private static String setLocale(int category, String locale) {
        if (locale == null) {
            CCharPointer cstrResult = Locale.setlocale(category, (CCharPointer)WordFactory.nullPointer());
            return CTypeConversion.toJavaString((CCharPointer)cstrResult);
        }
        try (CTypeConversion.CCharPointerHolder localePin = CTypeConversion.toCString((CharSequence)locale);){
            CCharPointer cstrLocale = localePin.get();
            CCharPointer cstrResult = Locale.setlocale(category, cstrLocale);
            String string = CTypeConversion.toJavaString((CCharPointer)cstrResult);
            return string;
        }
    }

    private static int getCategory(String category) {
        switch (category) {
            case "LC_ALL": {
                return Locale.LC_ALL();
            }
            case "LC_COLLATE": {
                return Locale.LC_COLLATE();
            }
            case "LC_CTYPE": {
                return Locale.LC_CTYPE();
            }
            case "LC_MONETARY": {
                return Locale.LC_MONETARY();
            }
            case "LC_NUMERIC": {
                return Locale.LC_NUMERIC();
            }
            case "LC_TIME": {
                return Locale.LC_TIME();
            }
            case "LC_MESSAGES": {
                return Locale.LC_MESSAGES();
            }
        }
        if (Platform.includedIn(Platform.LINUX.class) && ((LibCBase)ImageSingletons.lookup(LibCBase.class)).getClass().equals(GLibC.class)) {
            switch (category) {
                case "LC_PAPER": {
                    return Locale.LC_PAPER();
                }
                case "LC_NAME": {
                    return Locale.LC_NAME();
                }
                case "LC_ADDRESS": {
                    return Locale.LC_ADDRESS();
                }
                case "LC_TELEPHONE": {
                    return Locale.LC_TELEPHONE();
                }
                case "LC_MEASUREMENT": {
                    return Locale.LC_MEASUREMENT();
                }
                case "LC_IDENTIFICATION": {
                    return Locale.LC_IDENTIFICATION();
                }
            }
        }
        throw new IllegalArgumentException("Unknown locale category: " + category);
    }

    public static int getFD(FileDescriptor descriptor) {
        return SubstrateUtil.cast((Object)descriptor, Target_java_io_FileDescriptor.class).fd;
    }

    public static void setFD(FileDescriptor descriptor, int fd) {
        SubstrateUtil.cast((Object)descriptor, Target_java_io_FileDescriptor.class).fd = fd;
    }

    public static String lastErrorString(String defaultMsg) {
        int errno = CErrorNumber.getCErrorNumber();
        return PosixUtils.errorString(errno, defaultMsg);
    }

    public static IOException newIOExceptionWithLastError(String defaultMsg) {
        return new IOException(PosixUtils.lastErrorString(defaultMsg));
    }

    public static String errorString(int errno, String defaultMsg) {
        String result = "";
        if (errno != 0) {
            result = CTypeConversion.toJavaString((CCharPointer)Errno.strerror(errno));
        }
        return result.length() != 0 ? result : defaultMsg;
    }

    public static int getpid() {
        return Unistd.getpid();
    }

    public static int getpid(Process process) {
        Target_java_lang_UNIXProcess instance = SubstrateUtil.cast(process, Target_java_lang_UNIXProcess.class);
        return instance.pid;
    }

    public static int waitForProcessExit(int ppid) {
        int status;
        CIntPointer statusptr = (CIntPointer)StackValue.get(CIntPointer.class);
        if (Wait.waitpid(ppid, statusptr, 0) < 0) {
            if (CErrorNumber.getCErrorNumber() == Errno.ECHILD()) {
                return 0;
            }
            if (CErrorNumber.getCErrorNumber() != Errno.EINTR()) {
                return -1;
            }
        }
        if (Wait.WIFEXITED(status = statusptr.read())) {
            return Wait.WEXITSTATUS(status);
        }
        if (Wait.WIFSIGNALED(status)) {
            return 128 + Wait.WTERMSIG(status);
        }
        return status;
    }

    public static boolean writeBytes(FileDescriptor descriptor, CCharPointer bytes, UnsignedWord length) {
        CCharPointer curBuf = bytes;
        UnsignedWord curLen = length;
        while (curLen.notEqual(0)) {
            int fd = PosixUtils.getFD(descriptor);
            if (fd == -1) {
                return false;
            }
            SignedWord n = Unistd.write(fd, (PointerBase)curBuf, curLen);
            if (n.equal(-1)) {
                return false;
            }
            curBuf = curBuf.addressOf(n);
            curLen = curLen.subtract((UnsignedWord)n);
        }
        return true;
    }

    public static boolean flush(FileDescriptor descriptor) {
        int fd = PosixUtils.getFD(descriptor);
        return Unistd.fsync(fd) == 0;
    }

    public static PointerBase dlopen(String file, int mode) {
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)file);){
            CCharPointer pathPtr = pathPin.get();
            PointerBase pointerBase = Dlfcn.dlopen(pathPtr, mode);
            return pointerBase;
        }
    }

    public static <T extends PointerBase> T dlsym(PointerBase handle, String name) {
        try (CTypeConversion.CCharPointerHolder namePin = CTypeConversion.toCString((CharSequence)name);){
            CCharPointer namePtr = namePin.get();
            Object t = Dlfcn.dlsym(handle, namePtr);
            return t;
        }
    }

    public static String dlerror() {
        return CTypeConversion.toJavaString((CCharPointer)Dlfcn.dlerror());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void checkStatusIs0(int status, String message) {
        VMError.guarantee(status == 0, message);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean readEntirely(int fd, CCharPointer buffer, int bufferLen) {
        int readBytes;
        int bufferOffset = 0;
        do {
            if ((readBytes = PosixUtils.readBytes(fd, buffer, bufferLen - 1, bufferOffset)) < 0) {
                return false;
            }
            bufferOffset += readBytes;
        } while (readBytes != 0);
        buffer.write(bufferOffset, (byte)0);
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int readBytes(int fd, CCharPointer buffer, int bufferLen, int readOffset) {
        int readBytes = -1;
        if (readOffset < bufferLen) {
            while ((readBytes = (int)Unistd.NoTransitions.read(fd, (PointerBase)buffer.addressOf(readOffset), WordFactory.unsigned((int)(bufferLen - readOffset))).rawValue()) == -1 && CErrorNumber.getCErrorNumber() == Errno.EINTR()) {
            }
        }
        return readBytes;
    }

    @TargetClass(classNameProvider=ProcessNameProvider.class)
    private static final class Target_java_lang_UNIXProcess {
        @Alias
        int pid;

        private Target_java_lang_UNIXProcess() {
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final class ProcessNameProvider
    implements Function<TargetClass, String> {
        private ProcessNameProvider() {
        }

        @Override
        public String apply(TargetClass annotation) {
            if (JavaVersionUtil.JAVA_SPEC <= 8) {
                return "java.lang.UNIXProcess";
            }
            return "java.lang.ProcessImpl";
        }
    }

    @TargetClass(value=FileDescriptor.class)
    private static final class Target_java_io_FileDescriptor {
        @Alias
        int fd;

        private Target_java_io_FileDescriptor() {
        }
    }
}

