/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.meta.SharedMethod;
import java.lang.reflect.AnnotatedElement;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.common.LoopSafepointInsertionPhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.util.DirectAnnotationAccess;

public class MethodSafepointInsertionPhase
extends LoopSafepointInsertionPhase {
    public boolean checkContract() {
        return false;
    }

    public static boolean needSafepointCheck(SharedMethod method) {
        if (method.isUninterruptible()) {
            return false;
        }
        return !DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)method), CFunction.class) && !DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)method), InvokeCFunctionPointer.class);
    }

    public static boolean needsSafepointCheck(StructuredGraph graph) {
        SharedMethod method = (SharedMethod)graph.method();
        return MethodSafepointInsertionPhase.needSafepointCheck(method);
    }

    public static void insertMethodEndSafepoints(StructuredGraph graph) {
        for (ReturnNode returnNode : graph.getNodes(ReturnNode.TYPE)) {
            SafepointNode safepointNode = (SafepointNode)graph.add((Node)new SafepointNode());
            graph.addBeforeFixed((FixedNode)returnNode, (FixedWithNextNode)safepointNode);
        }
    }

    protected void run(StructuredGraph graph, MidTierContext context) {
        if (!MethodSafepointInsertionPhase.needsSafepointCheck(graph)) {
            return;
        }
        MethodSafepointInsertionPhase.insertMethodEndSafepoints(graph);
        super.run(graph, context);
    }
}

