/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

public class LinearImageHeapAllocator {
    private long position;

    public LinearImageHeapAllocator(long position) {
        this.position = position;
    }

    public long getPosition() {
        return this.position;
    }

    public long allocate(long size) {
        long begin = this.position;
        this.position += size;
        return begin;
    }

    public void align(int multiple) {
        this.allocate(LinearImageHeapAllocator.computePadding(this.position, multiple));
    }

    static long computePadding(long offset, int alignment) {
        long remainder = offset % (long)alignment;
        return remainder == 0L ? 0L : (long)alignment - remainder;
    }
}

